// Copyright (C) 2007-2008  CEA/DEN, EDF R&D
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
// See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
// ---
//
// File   : GHS3DPRLPlugin_GHS3DPRL_i.cxx
// Author : Christian VAN WAMBEKE (CEA) (from Hexotic plugin Lioka RAZAFINDRAZAKA)
//
// ---

#include "GHS3DPRLPlugin_GHS3DPRL_i.hxx"
#include "SMESH_Gen.hxx"
#include "GHS3DPRLPlugin_GHS3DPRL.hxx"

#include "Utils_CorbaException.hxx"
#include "utilities.h"

//=============================================================================
/*!
 *  GHS3DPRLPlugin_GHS3DPRL_i::GHS3DPRLPlugin_GHS3DPRL_i
 *
 *  Constructor
 */
//=============================================================================

GHS3DPRLPlugin_GHS3DPRL_i::GHS3DPRLPlugin_GHS3DPRL_i( PortableServer::POA_ptr thePOA,
						      int                     theStudyId,
						      ::SMESH_Gen*            theGenImpl )
  : SALOME::GenericObj_i( thePOA ),
    SMESH_Hypothesis_i( thePOA ),
    SMESH_Algo_i( thePOA ),
    SMESH_3D_Algo_i( thePOA )
{
  MESSAGE( "GHS3DPRLPlugin_GHS3DPRL_i::GHS3DPRLPlugin_GHS3DPRL_i" );
  myBaseImpl = new ::GHS3DPRLPlugin_GHS3DPRL( theGenImpl->GetANewId(),
					      theStudyId,
					      theGenImpl );
}

//=============================================================================
/*!
 *  GHS3DPRLPlugin_GHS3DPRL_i::~GHS3DPRLPlugin_GHS3DPRL_i
 *
 *  Destructor
 */
//=============================================================================

GHS3DPRLPlugin_GHS3DPRL_i::~GHS3DPRLPlugin_GHS3DPRL_i()
{
  MESSAGE( "GHS3DPRLPlugin_GHS3DPRL_i::~GHS3DPRLPlugin_GHS3DPRL_i" );
}

//=============================================================================
/*!
 *  GHS3DPRLPlugin_GHS3DPRL_i::GetImpl
 *
 *  Get implementation
 */
//=============================================================================

::GHS3DPRLPlugin_GHS3DPRL* GHS3DPRLPlugin_GHS3DPRL_i::GetImpl()
{
  MESSAGE( "GHS3DPRLPlugin_GHS3DPRL_i::GetImpl" );
  return ( ::GHS3DPRLPlugin_GHS3DPRL* )myBaseImpl;
}
