//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
//
//  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
//  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
#ifdef WNT
#pragma warning( disable:4786 )
#endif

#include <Standard_Stream.hxx>

#include "GEOM_Gen_i.hh"

#include <TCollection_AsciiString.hxx>
#include <TCollection_ExtendedString.hxx>
#include <TColStd_HSequenceOfAsciiString.hxx>
#include <Resource_DataMapOfAsciiStringAsciiString.hxx>

#include <vector>
#include <string>

//=======================================================================
//function : DumpPython
//purpose  : 
//=======================================================================

Engines::TMPFile* GEOM_Gen_i::DumpPython(CORBA::Object_ptr theStudy, 
					 CORBA::Boolean isPublished, 
					 CORBA::Boolean& isValidScript)
{
  SALOMEDS::Study_var aStudy = SALOMEDS::Study::_narrow(theStudy);
  if(CORBA::is_nil(aStudy))
    return new Engines::TMPFile(0);   

  SALOMEDS::SObject_var aSO = aStudy->FindComponent(ComponentDataType());
  if(CORBA::is_nil(aSO))
    return new Engines::TMPFile(0);  

  Resource_DataMapOfAsciiStringAsciiString aMap;

  TVariablesList aVariableMap;

  SALOMEDS::ChildIterator_var Itr = aStudy->NewChildIterator(aSO);
  for(Itr->InitEx(true); Itr->More(); Itr->Next()) {
    SALOMEDS::SObject_var aValue = Itr->Value();
    CORBA::String_var IOR = aValue->GetIOR();
    if(strlen(IOR.in()) > 0) {
      CORBA::Object_var obj = _orb->string_to_object(IOR);
      GEOM::GEOM_Object_var GO = GEOM::GEOM_Object::_narrow(obj);
      if(!CORBA::is_nil(GO)) {
        CORBA::String_var aName = aValue->GetName();
        CORBA::String_var anEntry = GO->GetEntry();
	aMap.Bind( (char*)anEntry.in(), (char*)aName.in() );

	//Find attribute with list of used notebook variables
	SALOMEDS::GenericAttribute_var anAttr;
	SALOMEDS::AttributeString_var anAttrStr;
	if(aValue->FindAttribute(anAttr,"AttributeString")){
	  anAttrStr = SALOMEDS::AttributeString::_narrow(anAttr);
	  SALOMEDS::ListOfListOfStrings_var aSections = aStudy->ParseVariables(anAttrStr->Value());
	  ObjectStates* aStates = new ObjectStates();
	  for(int i = 0; i < aSections->length(); i++) {
	    TState aState;
	    SALOMEDS::ListOfStrings aListOfVars = aSections[i];
	    for(int j = 0; j < aListOfVars.length(); j++) {
	      bool isVar = aStudy->IsVariable(aListOfVars[j].in());
	      TVariable aVar = TVariable( (char*)aListOfVars[j].in(), isVar );
	      aState.push_back(aVar);
	    }
	    aStates->AddState(aState);
	  }
	  aVariableMap.insert(pair<TCollection_AsciiString,ObjectStates*>(TCollection_AsciiString(anEntry),aStates));
	}
      }
    }
  }
  
  TCollection_AsciiString aScript =
    "# -*- coding: iso-8859-1 -*-\n"
    "### This file is generated by SALOME automatically by dump python functionality\n"
      "### of GEOM component\n\n";
  aScript += _impl->DumpPython(aStudy->StudyId(), aMap, aVariableMap, isPublished, isValidScript);

  if (isPublished)
  {
    //Output the script that sets up the visual parameters.
    char* script = aStudy->GetDefaultScript(ComponentDataType(), "\t");
    if (script && strlen(script) > 0) {
      aScript += "\n\t### Store presentation parameters of displayed objects\n";
      aScript += script;
      CORBA::string_free(script);
    }
  }

  aScript += "\n\tpass\n";

  int aLen = aScript.Length(); 
  unsigned char* aBuffer = new unsigned char[aLen+1];
  strcpy((char*)aBuffer, aScript.ToCString());

  CORBA::Octet* anOctetBuf =  (CORBA::Octet*)aBuffer;
  Engines::TMPFile_var aStreamFile = new Engines::TMPFile(aLen+1, aLen+1, anOctetBuf, 1); 

  return aStreamFile._retn(); 
}

//=======================================================================
//function : GetDumpName
//purpose  : 
//=======================================================================

char* GEOM_Gen_i::GetDumpName (const char* theStudyEntry)
{
  const char* name = _impl->GetDumpName( theStudyEntry );
  if ( name && strlen( name ) > 0 )
    return strdup( name );

  return NULL;
}

//=======================================================================
//function : GetAllDumpNames
//purpose  : 
//=======================================================================

GEOM::string_array* GEOM_Gen_i::GetAllDumpNames()
{
  Handle(TColStd_HSequenceOfAsciiString) aHSeq = _impl->GetAllDumpNames();
  int i = 0, aLen = aHSeq->Length();

  GEOM::string_array_var seq = new GEOM::string_array();
  seq->length(aLen);

  for (; i < aLen; i++) {
    seq[i] = CORBA::string_dup(aHSeq->Value(i + 1).ToCString());
  }

  return seq._retn();
}
