# -*- coding: utf-8 -*-

# Copyright (C) 2010-2011 by Mike Gabriel <mike.gabriel@das-netzwerkteam.de>
#
# Python X2go is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Python X2go is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the
# Free Software Foundation, Inc.,
# 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

"""\
Python X2go exceptions.

"""
__NAME__ = 'x2goexceptions-pylib'

# modules
import paramiko
import exceptions

from defaults import X2GOCLIENT_OS as _X2GOCLIENT_OS

# Python X2go Exceptions
AuthenticationException = paramiko.AuthenticationException
"""inherited from Python Paramiko library"""
PasswordRequiredException = paramiko.AuthenticationException
"""inherited from Python Paramiko library"""
BadHostKeyException = paramiko.AuthenticationException
"""inherited from Python Paramiko library"""
SSHException = paramiko.SSHException
"""inherited from Python Paramiko library"""

class _X2goException(exceptions.BaseException): pass
class X2goClientException(_X2goException): pass
class X2goClientPrintingException(_X2goException): pass
class X2goClientSettingsException(_X2goException): pass
class X2goSessionException(_X2goException): pass
class X2goControlSessionException(_X2goException): pass
class X2goRemoteHomeException(_X2goException): pass
class X2goHostKeyException(_X2goException): pass
class X2goSSHProxyHostKeyException(_X2goException): pass
class X2goTerminalSessionException(_X2goException): pass
class X2goSessionCacheException(_X2goException): pass
class X2goUserException(_X2goException): pass
class X2goProfileException(_X2goException): pass
class X2goSessionRegistryException(_X2goException): pass
class X2goFwTunnelException(_X2goException): pass
class X2goRevFwTunnelException(_X2goException): pass
class X2goPrintException(_X2goException): pass
class X2goPrintQueueException(_X2goException): pass
class X2goPrintActionException(_X2goException): pass
class X2goMIMEboxActionException(_X2goException): pass
class X2goMIMEboxQueueException(_X2goException): pass
class X2goSSHProxyException(_X2goException): pass
class X2goSSHProxyAuthenticationException(_X2goException): pass
class X2goNotImplementedYetException(_X2goException): pass
class X2goDesktopSharingException(_X2goException): pass
class X2goTimeOutException(_X2goException): pass
if _X2GOCLIENT_OS != 'Windows':
    # faking Windows errors on non-Windows systems...
    class WindowsError(_X2goException): pass
