#!/usr/bin/python

from arsenal.arsenal_lib import *
from lpltk import LaunchpadService

lp          = LaunchpadService()
d           = lp.launchpad.distributions["ubuntu"]

sponsors = [ 'ubuntu-main-sponsors', 'ubuntu-universe-sponsors' ]

message = """
I'm unsubscribing the Sponsors' Team for now. Please re-subscribe when ready.
"""

def unsub(bugnr):
    bug = lp.get_bug(sys.argv[1])

    print bug.id, "  ", bug.title
    for s in bug.subscriptions:
        if s.person.name in sponsors:
            try:
                # TODO:  launchpadlib's API doesn't permit a person argument (LP: #321738)
                bug.unsubscribe(s.person)
                print "Unsubscribed ",s.person.name
            except:
                print >> sys.stderr, "Failed to unsubscribe ",s.person.name
                raise

def main():
    if len(sys.argv) < 2:
        print >> sys.stderr, "Usage: unsub <bug nr>"
        sys.exit(1)
    for arg in sys.argv[1:]:
        unsub(arg)

if __name__ == '__main__':
        main()
