/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTScrollView;
import org.eclipse.swt.internal.cocoa.SWTView;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ToolBar
extends Composite {
    int itemCount;
    ToolItem[] items;
    NSArray accessibilityAttributes = null;
    ToolItem lastFocus;

    public ToolBar(Composite parent, int style) {
        super(parent, ToolBar.checkStyle(style));
        this.style = (style & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
    }

    int accessibilityAttributeValue(int id2, int sel, int arg0) {
        id returnObject;
        NSString nsAttributeName = new NSString(arg0);
        if (id2 == this.accessibleHandle() && this.accessible != null && (returnObject = this.accessible.internal_accessibilityAttributeValue(nsAttributeName, -1)) != null) {
            return returnObject.id;
        }
        if (nsAttributeName.isEqualToString(OS.NSAccessibilityRoleAttribute) || nsAttributeName.isEqualToString(OS.NSAccessibilityRoleDescriptionAttribute)) {
            NSString role = OS.NSAccessibilityToolbarRole;
            if (nsAttributeName.isEqualToString(OS.NSAccessibilityRoleAttribute)) {
                return role.id;
            }
            int roleDescription = OS.NSAccessibilityRoleDescription(role.id, 0);
            return roleDescription;
        }
        if (nsAttributeName.isEqualToString(OS.NSAccessibilityChildrenAttribute)) {
            NSMutableArray returnValue = NSMutableArray.arrayWithCapacity(this.itemCount);
            int i = 0;
            while (i < this.itemCount) {
                returnValue.addObject(new id(this.getItem(i).accessibleHandle()));
                ++i;
            }
            return returnValue.id;
        }
        if (nsAttributeName.isEqualToString(OS.NSAccessibilityEnabledAttribute)) {
            return NSNumber.numberWithBool((boolean)this.isEnabled()).id;
        }
        if (nsAttributeName.isEqualToString(OS.NSAccessibilityFocusedAttribute)) {
            boolean focused = this.view.id == this.view.window().firstResponder().id;
            return NSNumber.numberWithBool((boolean)focused).id;
        }
        return super.accessibilityAttributeValue(id2, sel, arg0);
    }

    boolean accessibilityIsIgnored(int id2, int sel) {
        if (id2 == this.view.id) {
            return false;
        }
        return super.accessibilityIsIgnored(id2, sel);
    }

    static int checkStyle(int style) {
        return style & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = wHint;
        int height = hHint;
        if (wHint == -1) {
            width = Integer.MAX_VALUE;
        }
        if (hHint == -1) {
            height = Integer.MAX_VALUE;
        }
        int[] result = this.layout(width, height, false);
        Point extent = new Point(result[1], result[2]);
        if (wHint != -1) {
            extent.x = wHint;
        }
        if (hHint != -1) {
            extent.y = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, extent.x, extent.y);
        return new Point(trim.width, trim.height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        if (this.scrollView != null) {
            NSSize size = new NSSize();
            size.width = width;
            size.height = height;
            size = NSScrollView.frameSizeForContentSize(size, false, false, 2);
            width = (int)size.width;
            height = (int)size.height;
            NSRect frame = this.scrollView.contentView().frame();
            x = (int)((float)x - frame.x);
            y = (int)((float)y - frame.y);
        }
        return new Rectangle(x, y, width, height);
    }

    void createHandle() {
        this.state |= 0x800;
        if (this.hasBorder()) {
            NSRect rect = new NSRect();
            NSScrollView scrollWidget = (NSScrollView)new SWTScrollView().alloc();
            scrollWidget.initWithFrame(rect);
            scrollWidget.setDrawsBackground(false);
            scrollWidget.setBorderType(2);
            this.scrollView = scrollWidget;
        }
        NSView widget = (NSView)new SWTView().alloc();
        widget.init();
        this.view = widget;
        if (this.scrollView != null) {
            this.view.setAutoresizingMask(18);
        }
    }

    void createItem(ToolItem item, int index) {
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            ToolItem[] newItems = new ToolItem[this.itemCount + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        item.createWidget();
        this.view.addSubview(item.view);
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount++ - index);
        this.items[index] = item;
        this.relayout();
    }

    void createWidget() {
        super.createWidget();
        this.items = new ToolItem[4];
        this.itemCount = 0;
    }

    void destroyItem(ToolItem item) {
        int index = 0;
        while (index < this.itemCount) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index == this.itemCount) {
            return;
        }
        if (item == this.lastFocus) {
            this.lastFocus = null;
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
        item.view.removeFromSuperview();
        this.relayout();
    }

    void drawBackground(int id2, NSGraphicsContext context, NSRect rect) {
        if (id2 != this.view.id) {
            return;
        }
        if (this.background != null) {
            this.fillBackground(this.view, context, rect, -1);
        }
    }

    void enableWidget(boolean enabled) {
        super.enableWidget(enabled);
        int i = 0;
        while (i < this.itemCount) {
            ToolItem item = this.items[i];
            if (item != null) {
                item.enableWidget(enabled);
            }
            ++i;
        }
    }

    Widget findTooltip(NSPoint pt) {
        pt = this.view.convertPoint_fromView_(pt, null);
        int i = 0;
        while (i < this.itemCount) {
            ToolItem item = this.items[i];
            if (OS.NSPointInRect(pt, item.view.frame())) {
                return item;
            }
            ++i;
        }
        return super.findTooltip(pt);
    }

    boolean forceFocus(NSView focusView) {
        if (this.lastFocus != null && this.lastFocus.setFocus()) {
            return true;
        }
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            ToolItem item = items[i];
            if (item.setFocus()) {
                this.lastFocus = item;
                return true;
            }
            ++i;
        }
        return super.forceFocus(focusView);
    }

    public ToolItem getItem(int index) {
        this.checkWidget();
        if (index >= 0 && index < this.itemCount) {
            return this.items[index];
        }
        this.error(6);
        return null;
    }

    public ToolItem getItem(Point pt) {
        this.checkWidget();
        if (pt == null) {
            this.error(4);
        }
        int i = 0;
        while (i < this.itemCount) {
            Rectangle rect = this.items[i].getBounds();
            if (rect.contains(pt)) {
                return this.items[i];
            }
            ++i;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        ToolItem[] result = new ToolItem[this.itemCount];
        System.arraycopy(this.items, 0, result, 0, this.itemCount);
        return result;
    }

    public int getRowCount() {
        this.checkWidget();
        Rectangle rect = this.getClientArea();
        return this.layout(rect.width, rect.height, false)[0];
    }

    boolean hasKeyboardFocus(int inId) {
        return this.hasFocus();
    }

    public int indexOf(ToolItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        int i = 0;
        while (i < this.itemCount) {
            if (this.items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    int[] layoutHorizontal(int width, int height, boolean resize) {
        int xSpacing = 0;
        int ySpacing = 2;
        int marginWidth = 0;
        int marginHeight = 0;
        int x = marginWidth;
        int y = marginHeight;
        int maxX = 0;
        int rows = 1;
        boolean wrap = (this.style & 0x40) != 0;
        int itemHeight = 0;
        Point[] sizes = new Point[this.itemCount];
        int i = 0;
        while (i < this.itemCount) {
            Point size = sizes[i] = this.items[i].computeSize();
            itemHeight = Math.max(itemHeight, size.y);
            ++i;
        }
        i = 0;
        while (i < this.itemCount) {
            ToolItem item = this.items[i];
            Point size = sizes[i];
            if (wrap && i != 0 && x + size.x > width) {
                ++rows;
                x = marginWidth;
                y += ySpacing + itemHeight;
            }
            if (resize) {
                item.setBounds(x, y, size.x, itemHeight);
                boolean visible = x + size.x <= width && y + itemHeight <= height;
                item.setVisible(visible);
                Control control = item.control;
                if (control != null) {
                    int controlY = y + (itemHeight - size.y) / 2;
                    control.setBounds(x, controlY, size.x, itemHeight - (controlY - y));
                }
            }
            maxX = Math.max(maxX, x += xSpacing + size.x);
            ++i;
        }
        return new int[]{rows, maxX, y + itemHeight};
    }

    int[] layoutVertical(int width, int height, boolean resize) {
        int xSpacing = 2;
        int ySpacing = 0;
        int marginWidth = 0;
        int marginHeight = 0;
        int x = marginWidth;
        int y = marginHeight;
        int maxY = 0;
        int cols = 1;
        boolean wrap = (this.style & 0x40) != 0;
        int itemWidth = 0;
        Point[] sizes = new Point[this.itemCount];
        int i = 0;
        while (i < this.itemCount) {
            Point size = sizes[i] = this.items[i].computeSize();
            itemWidth = Math.max(itemWidth, size.x);
            ++i;
        }
        i = 0;
        while (i < this.itemCount) {
            ToolItem item = this.items[i];
            Point size = sizes[i];
            if (wrap && i != 0 && y + size.y > height) {
                ++cols;
                x += xSpacing + itemWidth;
                y = marginHeight;
            }
            if (resize) {
                item.setBounds(x, y, itemWidth, size.y);
                boolean visible = x + itemWidth <= width && y + size.y <= height;
                item.setVisible(visible);
                Control control = item.control;
                if (control != null) {
                    int controlX = x + (itemWidth - size.x) / 2;
                    control.setBounds(controlX, y, itemWidth - (controlX - x), size.y);
                }
            }
            maxY = Math.max(maxY, y += ySpacing + size.y);
            ++i;
        }
        return new int[]{cols, x + itemWidth, maxY};
    }

    int[] layout(int nWidth, int nHeight, boolean resize) {
        if ((this.style & 0x200) != 0) {
            return this.layoutVertical(nWidth, nHeight, resize);
        }
        return this.layoutHorizontal(nWidth, nHeight, resize);
    }

    void relayout() {
        if (!this.getDrawing()) {
            return;
        }
        Rectangle rect = this.getClientArea();
        this.layout(rect.width, rect.height, true);
    }

    void releaseChildren(boolean destroy) {
        if (this.items != null) {
            int i = 0;
            while (i < this.itemCount) {
                ToolItem item = this.items[i];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++i;
            }
            this.itemCount = 0;
            this.items = null;
        }
        super.releaseChildren(destroy);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.accessibilityAttributes != null) {
            this.accessibilityAttributes.release();
        }
        this.accessibilityAttributes = null;
    }

    void removeControl(Control control) {
        super.removeControl(control);
        int i = 0;
        while (i < this.itemCount) {
            ToolItem item = this.items[i];
            if (item.control == control) {
                item.setControl(null);
            }
            ++i;
        }
    }

    void resized() {
        super.resized();
        this.relayout();
    }

    void reskinChildren(int flags) {
        if (this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                ToolItem item = this.items[i];
                if (item != null) {
                    item.reskin(flags);
                }
                ++i;
            }
        }
        super.reskinChildren(flags);
    }

    boolean sendMouseEvent(NSEvent nsEvent, int type, boolean send) {
        switch (type) {
            case 5: 
            case 6: {
                NSPoint toolbarPoint = NSEvent.mouseLocation();
                toolbarPoint = this.view.window().convertScreenToBase(toolbarPoint);
                toolbarPoint = this.view.convertPoint_fromView_(toolbarPoint, null);
                int i = 0;
                while (i < this.itemCount) {
                    ToolItem item = this.items[i];
                    int currState = item.state;
                    item.state = OS.NSPointInRect(toolbarPoint, item.view.frame()) ? (item.state |= 0x20) : (item.state &= 0xFFFFFFDF);
                    if (currState != item.state) {
                        item.updateImage(true);
                    }
                    ++i;
                }
                break;
            }
            case 7: {
                int i = 0;
                while (i < this.itemCount) {
                    ToolItem item = this.items[i];
                    int currState = item.state;
                    item.state &= 0xFFFFFFDF;
                    if (currState != item.state) {
                        item.updateImage(true);
                    }
                    ++i;
                }
                break;
            }
        }
        return super.sendMouseEvent(nsEvent, type, send);
    }

    void setFont(NSFont font) {
        int i = 0;
        while (i < this.itemCount) {
            ToolItem item = this.items[i];
            if (item.button != null) {
                item.button.setAttributedTitle(item.createString());
            }
            ++i;
        }
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        super.setRedraw(redraw);
        if (redraw && this.drawCount == 0) {
            this.relayout();
        }
    }

    boolean translateTraversal(int key, NSEvent theEvent, boolean[] consume) {
        boolean result = super.translateTraversal(key, theEvent, consume);
        if (result) {
            return result;
        }
        boolean next = false;
        boolean checkPopup = false;
        switch (key) {
            case 123: {
                next = false;
                break;
            }
            case 124: {
                next = true;
                break;
            }
            case 126: {
                next = false;
                checkPopup = true;
                break;
            }
            case 125: {
                next = true;
                checkPopup = true;
                break;
            }
            default: {
                return false;
            }
        }
        consume[0] = true;
        if (checkPopup && this.lastFocus != null && this.lastFocus.handleKeyDown()) {
            return false;
        }
        ToolItem[] items = this.getItems();
        ToolItem item = this.lastFocus;
        int length = items.length;
        int index = 0;
        while (index < length) {
            if (items[index] == item) break;
            ++index;
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            ToolItem child = items[index];
            if (child.isDisposed() || !child.setFocus()) continue;
            this.lastFocus = child;
            return false;
        }
        return false;
    }
}

