use ExtUtils::MakeMaker;

WriteMakefile(
	'NAME'    => 'Buffy',			# Name of package
	'VERSION' => '0.13',
	'LIBS'    => [`pkg-config --libs "libbuffy >= 1.4"`],		# Name of custom libraries
	'OBJECT'  => 'buffy_wrap.o',		# Object files
	'PM'      => { 'Buffy.pm' => '$(INST_LIBDIR)/Buffy.pm' },
	'clean'	  => { FILES => 'buffy_wrap.cc Buffy.pm' }
);

sub MY::postamble {
	return <<'MAKE_FRAG';
Buffy.pm: buffy_wrap.cc

buffy_wrap.cc: ../buffy.i
	swig -perl -c++ -I/usr/include -o $@ $<
MAKE_FRAG
}
