/***************************************************************************
 *   Copyright (C) 2004 by Michael Schulze                                 *
 *   mike.s@genion.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SLAVEUTILS_H
#define SLAVEUTILS_H

#include <qmutex.h>
#include <kio/slavebase.h>
#include <kio/job.h>

#include "ipod.h"


class Job2SlaveSyncronizer : public QObject {
    Q_OBJECT

    KIO::SlaveBase * _slave;
    QMutex waitLock;

public:

    int error;
    QString errorText;

    Job2SlaveSyncronizer(KIO::Job * job, KIO::SlaveBase * slave);
    
    void yield();
    
private slots:
    void slotResult( KIO::Job *job );

    void slotInfoMessage( KIO::Job *job, const QString &msg );

    void slotTotalSize( KIO::Job *job, KIO::filesize_t size );

    void slotProcessedSize( KIO::Job *job, KIO::filesize_t size );

    void slotSpeed( KIO::Job *job, unsigned long bytesPerSecond );

};

#endif
