/***************************************************************************
 *   Copyright (C) 2004 by Andrew de Quincey                               *
 *   adq@lidskialf.net                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef IPODDEVICEDETAILS_H
#define IPODDEVICEDETAILS_H

#include <qstring.h>
#include <qfile.h>

/**
 * Class encapsulating the DeviceDetails (name, owner, comment).
 * @author Andrew de Quincey
 */
class IPodDeviceDetails {
public:
  IPodDeviceDetails(const QString& filename);
  ~IPodDeviceDetails();
  bool load();
  bool save();    

  /**
   * Accessor for name property.
   *
   * @return The value.
   */
  QString getName();
  
  /**
   * Accessor for owner property.
   *
   * @return The name.
   */
  QString getOwner();
  
  /**
   * Accessor for comment property.
   *
   * @return The comment.
   */
  QString getComment();
  
  /**
   * Setter for name property.
   *
   * @param name The value.
   */
  void setName(const QString& name);
  
  /**
   * Setter for owner property.
   *
   * @param name The name.
   */
  void setOwner(const QString& owner);
  
  /**
   * Setter for comment property.
   *
   * @param comment The comment.
   */
  void setComment(const QString& comment);
  
private:  
  QString readDeviceInfoString(QFile& file, int position);
  
  QString filename;

  QString name;
  QString owner;
  QString comment;
  
  bool dirty;
};

#endif
