/***************************************************************************
 *   Copyright (C) 2004 by Michael Schulze                                 *
 *   mike.s@genion.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "ejectutility.h"
#include <kprocess.h>

const QString EjectUtility::defaultmimetype= QString( "text/html");
const QString EjectUtility::name= QString( "Eject Device");

EjectUtility::EjectUtility()
 : IPodUtility()
{
}


EjectUtility::~EjectUtility()
{
}


const QString& EjectUtility::getDefaultMimeType() {
    return defaultmimetype;
}

const QString& EjectUtility::getName() {
    return name;
}

void EjectUtility::handleRequest(IPod& ipod, const KURL& request, QByteArray& response, QString& mimeType) {
    QTextOStream stream( response);
    QString really= request.queryItem( "really" );

    mimeType= QString( "text/html");
    stream << "<html><head><title>" + name + "</title></head>\n<body bgcolor=\"white\">";
    stream << "<H1 align=\"right\">Eject <em>" << ipod.getName() << " (" << ipod.getDevice() << ")" << "</em></H1>" << endl;
    stream << "<br><div align=\"center\"><strong>Attention: DO NOT USE THIS UTILITY WITH FIREWIRE IPODS</strong>" << endl;
    stream << "<br>Due to a kernel bug you may experience machine lockups if you do otherwise.<div>" << endl;
    if( ipod.isChanged() ) {
        stream << "<br><strong>Your iPod contains unsaved changes.</strong> Use the Sync utility to save these changes.<br>";
    }
    if ( really != "OK") {
        stream << "<br>Press the Eject button if you really want to eject.<br>\n<hr>";
        stream << "<p><FORM method=\"GET\" action=\""+ name + "\">\n<INPUT type=\"hidden\" name=\"really\" value=\"OK\"><INPUT type=\"submit\" name=\"b\" value=\"Eject USB iPod\">\n</FORM></p>";
    } else {
        sync(); // flush file system buffers
        KProcess * ejectProcess = new KProcess();
        *ejectProcess << "eject";   // TODO could be configured
        *ejectProcess << ipod.getDevice();
        ejectProcess->start(KProcess::DontCare);
        delete ejectProcess;
        stream << "<br>Eject triggered. Wait until the iPod is ready for disconnect.";
    }

    stream << "</div></body></html>\n";
}

