import Graphics.Vty
import System.IO

import qualified Data.ByteString.Char8 as B

main = do vt <- mkVty
          (sx,sy) <- getSize vt
          play vt 0 0 sx sy ""

pieceA = setFG red attr
dumpA = setRV attr

play vt x y sx sy btl = do update vt (render x y sx sy btl)
                           k <- getEvent vt
                           case k of EvKey (KASCII 'r') [MCtrl]    -> refresh vt >> play vt x y sx sy btl
                                     EvKey KLeft  [] | x /= 0      -> play vt (x-1) y sx sy btl
                                     EvKey KRight [] | x /= (sx-1) -> play vt (x+1) y sx sy btl
                                     EvKey KUp    [] | y /= 0      -> play vt x (y-1) sx sy btl
                                     EvKey KDown  [] | y /= (sy-2) -> play vt x (y+1) sx sy btl
                                     EvKey KEsc   []               -> shutdown vt >> return ()
                                     EvResize nx ny                -> play vt (min x (nx-1)) (min y (ny-2)) nx ny btl
                                     _                             -> play vt x y sx sy (take sx (show k ++ btl))


render x y sx sy btl = pic { pCursor = Cursor x y,
                             pImage = renderFill pieceA ' ' sx y <->
                                      renderHFill pieceA ' ' x <|> renderChar pieceA '@' <|> renderHFill pieceA ' ' (sx - x - 1) <->
                                      renderFill pieceA ' ' sx (sy - y - 1) <->
                                      renderBS dumpA (B.pack $ take sx (btl ++ repeat ' ')) }
