#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Author : Steven Harper
# License : GNU GENERAL PUBLIC LICENSE V2
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

import gtk


ICON_PATH_OPEN="/icons/open.png"
ICON_PATH_CLOSE="/icons/close.png"
ICON_PATH_CREATE="/icons/create.png"
ICON_PATH_RECREATE="/icons/create.png"
ICON_PATH_CHANGE_PASSWORD="/icons/edit.png"
ICON_PATH_CONFIG="/icons/config.png"
ICON_SIZE=20

class EasyCryptPopupMenu:
	def __init__(self, crypt_manager):
		
		# root menu
		self.menu = None
		# history menu
		self.history_menu = None
		
		# Make me an Image
		self.item_open = None
		self.item_close = None
		self.item_change_password = None
		self.item_create = None 
		self.item_recreate = None 
		self.item_config = None 
		#self.item_history = None
		self.item_about = None  
		self.item_exit = None


		if crypt_manager.easyCryptConfig.getOption("use_stock_icons") == "yes":
			
			imageicon_open = gtk.image_new_from_stock(gtk.STOCK_OPEN, gtk.ICON_SIZE_MENU)
			imageicon_close = gtk.image_new_from_stock(gtk.STOCK_CLOSE, gtk.ICON_SIZE_MENU)
			
			imageicon_create = gtk.image_new_from_stock(gtk.STOCK_NEW, gtk.ICON_SIZE_MENU)
			imageicon_recreate = gtk.image_new_from_stock(gtk.STOCK_NEW, gtk.ICON_SIZE_MENU)
			imageicon_change_password = gtk.image_new_from_stock(gtk.STOCK_DIALOG_AUTHENTICATION, gtk.ICON_SIZE_MENU)
			imageicon_config = gtk.image_new_from_stock(gtk.STOCK_PREFERENCES, gtk.ICON_SIZE_MENU)
			
		else :
					
			imageicon_open = gtk.Image()
			pixbuf = gtk.gdk.pixbuf_new_from_file( crypt_manager.root + ICON_PATH_OPEN )
			scaled_buf = pixbuf.scale_simple(ICON_SIZE,ICON_SIZE,gtk.gdk.INTERP_BILINEAR)
			imageicon_open.set_from_pixbuf(scaled_buf)
			
			imageicon_close = gtk.Image()
			pixbuf = gtk.gdk.pixbuf_new_from_file( crypt_manager.root + ICON_PATH_CLOSE )
			scaled_buf = pixbuf.scale_simple(ICON_SIZE,ICON_SIZE,gtk.gdk.INTERP_BILINEAR)
			imageicon_close.set_from_pixbuf(scaled_buf)
			
			imageicon_create = gtk.Image()
			pixbuf = gtk.gdk.pixbuf_new_from_file( crypt_manager.root + ICON_PATH_CREATE )
			scaled_buf = pixbuf.scale_simple(ICON_SIZE,ICON_SIZE,gtk.gdk.INTERP_BILINEAR)
			imageicon_create.set_from_pixbuf(scaled_buf)
			
			imageicon_recreate = gtk.Image()
			pixbuf = gtk.gdk.pixbuf_new_from_file( crypt_manager.root + ICON_PATH_RECREATE )
			scaled_buf = pixbuf.scale_simple(ICON_SIZE,ICON_SIZE,gtk.gdk.INTERP_BILINEAR)
			imageicon_recreate.set_from_pixbuf(scaled_buf)
			
			imageicon_change_password = gtk.Image()
			pixbuf = gtk.gdk.pixbuf_new_from_file( crypt_manager.root + ICON_PATH_CHANGE_PASSWORD )
			scaled_buf = pixbuf.scale_simple(ICON_SIZE,ICON_SIZE,gtk.gdk.INTERP_BILINEAR)
			imageicon_change_password.set_from_pixbuf(scaled_buf)
			
			imageicon_config = gtk.Image()
			pixbuf = gtk.gdk.pixbuf_new_from_file( crypt_manager.root + ICON_PATH_CONFIG )
			scaled_buf = pixbuf.scale_simple(ICON_SIZE,ICON_SIZE,gtk.gdk.INTERP_BILINEAR)
			imageicon_config.set_from_pixbuf(scaled_buf)

		#ATM, haven't got any idea for this icon, so just use one in stock
		imageicon_history = gtk.image_new_from_stock(gtk.STOCK_DIRECTORY, gtk.ICON_SIZE_MENU)

		# Create menu items
		if crypt_manager.isExpert:
			item_open = gtk.ImageMenuItem( crypt_manager._("Open a Crypt"), gtk.TRUE)
			item_close = gtk.ImageMenuItem( crypt_manager._("Close a Crypt"), gtk.TRUE)
		else :
			item_open = gtk.ImageMenuItem( crypt_manager._("Open the Crypt"), gtk.TRUE)
			item_close = gtk.ImageMenuItem( crypt_manager._("Close the Crypt"), gtk.TRUE)

		item_open.set_image(imageicon_open)
		item_close.set_image(imageicon_close)
		item_change_password = gtk.ImageMenuItem( crypt_manager._("Change Crypt Password"), gtk.TRUE)
		item_change_password.set_image(imageicon_change_password)
		item_create = gtk.ImageMenuItem( crypt_manager._("Create New Crypt"), gtk.TRUE)
		item_create.set_image(imageicon_create)
		item_recreate = gtk.ImageMenuItem( crypt_manager._("Setup Crypt"), gtk.TRUE)
		item_recreate.set_image(imageicon_recreate)
		#item_history = gtk.ImageMenuItem( crypt_manager._("Recently used"), gtk.TRUE)
		#item_history.set_image(imageicon_history)
		item_config = gtk.ImageMenuItem( crypt_manager._("Preferences"), gtk.TRUE)
		item_config.set_image(imageicon_config)
		item_about  = gtk.ImageMenuItem(gtk.STOCK_ABOUT)
		item_exit = gtk.ImageMenuItem(gtk.STOCK_QUIT)

		# item in history submenu
		item_clear_history = gtk.ImageMenuItem(crypt_manager._("Clear recently used"), gtk.TRUE)
		item_clear_history.set_image(gtk.image_new_from_stock(gtk.STOCK_PREFERENCES, gtk.ICON_SIZE_MENU))

		# Connect the events
		item_open.connect( 'activate', crypt_manager.doOpenEvent)
		item_close.connect( 'activate', crypt_manager.doCloseEvent)
		item_change_password.connect( 'activate', crypt_manager.doChangePasswordEvent)
		item_create.connect( 'activate', crypt_manager.doCreateEvent)
		item_recreate.connect( 'activate', crypt_manager.doReCreateEvent)
		item_config.connect( 'activate', crypt_manager.doConfigEvent)
		item_about.connect( 'activate', crypt_manager.showAboutWindowEvent)
		item_exit.connect( 'activate', crypt_manager.exit)

		#create the history menu
		self.history_menu = gtk.Menu()
		self.history_menu.append( gtk.SeparatorMenuItem())
		self.history_menu.append(item_clear_history)
		self.history_menu.show_all()

		#item_history.set_submenu(self.history_menu)		

		# Create the menu
		self.menu = gtk.Menu()
		# Append menu items to the menu
		self.menu.append( item_open)
		self.menu.append( item_close)
		self.menu.append( gtk.SeparatorMenuItem())
		if crypt_manager.isExpert:
			self.menu.append( item_create)
		else :
			self.menu.append( item_recreate )
		self.menu.append( item_change_password)
		self.menu.append( item_config)
		self.menu.append( gtk.SeparatorMenuItem())
		#self.menu.append( item_history)
		#self.menu.append( gtk.SeparatorMenuItem())
		self.menu.append( item_about)
		self.menu.append( gtk.SeparatorMenuItem())
		self.menu.append( item_exit)
		self.menu.show_all()

		return

	def enableCloseButton(self):
		self.item_close.set_sensitive(True)

	def disableCloseButton(self):
		self.item_close.set_sensitive(False)

	def enableChangePwdButton(self):
		self.item_change_password.set_sensitive(True)

	def disableChangePwdButton(self):
		self.item_change_password.set_sensitive(False)

