#include <glib-object.h>

#include "common.h"

#include <gmyth/gmyth_uri.h>
#include <gmyth/gmyth_backendinfo.h>
#include <gmyth/gmyth_livetv.h>
#include <gmyth/gmyth_file.h>
#include <gmyth/gmyth_file_transfer.h>
#include <gmyth/gmyth_file_local.h>
#include <gmyth/gmyth_common.h>

#define URI_DEFAULT	"myth://192.168.3.165:6543/livetv?channel=9"

static          gboolean
test_tvchain_setup(gchar * uri)
{
    GMythTVChain   *tvchain = NULL;
    gchar          *channel = NULL;
    gboolean        ret = TRUE;

    if (NULL == uri)
        uri = g_strdup(URI_DEFAULT);

    GMythURI       *gmyth_uri = gmyth_uri_new_with_value(uri);

    GMythBackendInfo *backend_info = gmyth_backend_info_new_with_uri(uri);

    channel = gmyth_uri_get_channel_name(gmyth_uri);

    /*
     * Creates livetv chain handler 
     */
    tvchain = gmyth_tvchain_new();
    gmyth_tvchain_initialize(tvchain, backend_info);

    if (tvchain == NULL || tvchain->tvchain_id == NULL) {
        ret = FALSE;
        goto init_failed;
    }

    ret = (gmyth_tvchain_get_id(tvchain) != NULL);
    if (!ret) {
        g_debug("[%s] TV Chain ID is NULL.\n", __FUNCTION__);
        goto init_failed;
    }

    gmyth_backend_info_set_username(tvchain->backend_info, "mythtv");
    gmyth_backend_info_set_password(tvchain->backend_info, "mythtv");
    gmyth_backend_info_set_db_name(tvchain->backend_info, "mythconverg");
    GList          *prog_list =
        gmyth_tvchain_get_program_info_from_channel(tvchain,
                                                    channel);
    GMythProgramInfo *ch_prog = NULL;
    if (prog_list != NULL && g_list_length(prog_list) > 0) {
        ch_prog = (GMythProgramInfo *) g_list_nth_data(prog_list, 0);
        g_debug("Channel program info (from a list with size = %d)!",
                g_list_length(prog_list));
        gmyth_program_info_print(ch_prog);
    }

    g_debug("Program Info: %s\n", gmyth_program_info_to_string(ch_prog));

    /*
     * Reload all TV chain from Mysql database. 
     */
    gmyth_tvchain_reload_all(tvchain);

    if (tvchain == NULL) {
        ret = FALSE;
        goto init_failed;
    }

    /*
     * Get program info from database using chanid and starttime 
     */
    ch_prog = gmyth_tvchain_get_program_at(tvchain, 0);
    if (NULL == ch_prog) {
        g_debug("TVChain not successfully started.\n");
        ret = FALSE;
        goto init_failed;
    } else {
        ret = TRUE;
        g_debug
            ("GMythTVChain: All requests to backend to start TV were OK. [%s]\n",
             ch_prog->pathname->str);
    }


  init_failed:
    if (tvchain != NULL)
        g_object_unref(tvchain);

    if (gmyth_uri != NULL)
        g_object_unref(gmyth_uri);

    if (ch_prog != NULL)
        g_object_unref(ch_prog);

    if (prog_list != NULL)
        g_list_free(prog_list);

    if (backend_info != NULL)
        g_object_unref(backend_info);

    return ret;

}

gint
main(gint args, const gchar ** argv)
{
    gboolean        ret;

    g_type_init();
    g_thread_init(NULL);

    fprintf(stdout, SYNC_STRING);
    fflush(NULL);
    getchar();

    if (args > 1)
        ret = test_tvchain_setup(argv[1]);
    else
        ret = test_tvchain_setup(NULL);

    if (!ret)
        g_debug("Error when running TV Chain setup test script!");
    else
        g_debug("TV Chain setup test script finished with success.");

    return (0);
}
