// *** THIS FILE IS GENERATED - DO NOT EDIT ***
// See sync_validation_generator.py for modifications

/***************************************************************************
 *
 * Copyright (c) 2015-2025 Valve Corporation
 * Copyright (c) 2015-2025 LunarG, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ****************************************************************************/

// NOLINTBEGIN

#pragma once

#include <array>
#include <bitset>
#include <map>
#include <stdint.h>
#include <vulkan/vulkan.h>
#include "containers/custom_containers.h"
// clang-format off
static constexpr VkAccessFlags2 kShaderReadExpandBits = VK_ACCESS_2_SHADER_SAMPLED_READ_BIT|VK_ACCESS_2_SHADER_STORAGE_READ_BIT|VK_ACCESS_2_SHADER_TILE_ATTACHMENT_READ_BIT_QCOM|VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR;
static constexpr VkAccessFlags2 kShaderWriteExpandBits = VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT|VK_ACCESS_2_SHADER_TILE_ATTACHMENT_WRITE_BIT_QCOM;
static constexpr VkPipelineStageFlags2 kAllTransferExpandBits = VK_PIPELINE_STAGE_2_COPY_BIT|VK_PIPELINE_STAGE_2_RESOLVE_BIT|VK_PIPELINE_STAGE_2_BLIT_BIT|VK_PIPELINE_STAGE_2_CLEAR_BIT|VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR;

// Fake stages and accesses for acquire present support
static const VkPipelineStageFlagBits2 VK_PIPELINE_STAGE_2_PRESENT_ENGINE_BIT_SYNCVAL = 0x0000200000000000ULL;
static const VkAccessFlagBits2 VK_ACCESS_2_PRESENT_ACQUIRE_READ_BIT_SYNCVAL = 0x0020000000000000ULL;
static const VkAccessFlagBits2 VK_ACCESS_2_PRESENT_PRESENTED_BIT_SYNCVAL = 0x0040000000000000ULL;
// Unique number for each  stage/access combination
enum SyncAccessIndex {
    SYNC_ACCESS_INDEX_NONE = 0,
    SYNC_DRAW_INDIRECT_INDIRECT_COMMAND_READ = 1,
    SYNC_DRAW_INDIRECT_TRANSFORM_FEEDBACK_COUNTER_READ_EXT = 2,
    SYNC_VERTEX_SHADER_ACCELERATION_STRUCTURE_READ = 3,
    SYNC_VERTEX_SHADER_DESCRIPTOR_BUFFER_READ_EXT = 4,
    SYNC_VERTEX_SHADER_SHADER_BINDING_TABLE_READ = 5,
    SYNC_VERTEX_SHADER_SHADER_SAMPLED_READ = 6,
    SYNC_VERTEX_SHADER_SHADER_STORAGE_READ = 7,
    SYNC_VERTEX_SHADER_SHADER_STORAGE_WRITE = 8,
    SYNC_VERTEX_SHADER_UNIFORM_READ = 9,
    SYNC_TESSELLATION_CONTROL_SHADER_ACCELERATION_STRUCTURE_READ = 10,
    SYNC_TESSELLATION_CONTROL_SHADER_DESCRIPTOR_BUFFER_READ_EXT = 11,
    SYNC_TESSELLATION_CONTROL_SHADER_SHADER_BINDING_TABLE_READ = 12,
    SYNC_TESSELLATION_CONTROL_SHADER_SHADER_SAMPLED_READ = 13,
    SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_READ = 14,
    SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_WRITE = 15,
    SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ = 16,
    SYNC_TESSELLATION_EVALUATION_SHADER_ACCELERATION_STRUCTURE_READ = 17,
    SYNC_TESSELLATION_EVALUATION_SHADER_DESCRIPTOR_BUFFER_READ_EXT = 18,
    SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_BINDING_TABLE_READ = 19,
    SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_SAMPLED_READ = 20,
    SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_READ = 21,
    SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_WRITE = 22,
    SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ = 23,
    SYNC_GEOMETRY_SHADER_ACCELERATION_STRUCTURE_READ = 24,
    SYNC_GEOMETRY_SHADER_DESCRIPTOR_BUFFER_READ_EXT = 25,
    SYNC_GEOMETRY_SHADER_SHADER_BINDING_TABLE_READ = 26,
    SYNC_GEOMETRY_SHADER_SHADER_SAMPLED_READ = 27,
    SYNC_GEOMETRY_SHADER_SHADER_STORAGE_READ = 28,
    SYNC_GEOMETRY_SHADER_SHADER_STORAGE_WRITE = 29,
    SYNC_GEOMETRY_SHADER_UNIFORM_READ = 30,
    SYNC_FRAGMENT_SHADER_ACCELERATION_STRUCTURE_READ = 31,
    SYNC_FRAGMENT_SHADER_COLOR_ATTACHMENT_READ = 32,
    SYNC_FRAGMENT_SHADER_DEPTH_STENCIL_ATTACHMENT_READ = 33,
    SYNC_FRAGMENT_SHADER_DESCRIPTOR_BUFFER_READ_EXT = 34,
    SYNC_FRAGMENT_SHADER_INPUT_ATTACHMENT_READ = 35,
    SYNC_FRAGMENT_SHADER_SHADER_BINDING_TABLE_READ = 36,
    SYNC_FRAGMENT_SHADER_SHADER_SAMPLED_READ = 37,
    SYNC_FRAGMENT_SHADER_SHADER_STORAGE_READ = 38,
    SYNC_FRAGMENT_SHADER_SHADER_STORAGE_WRITE = 39,
    SYNC_FRAGMENT_SHADER_SHADER_TILE_ATTACHMENT_READ_QCOM = 40,
    SYNC_FRAGMENT_SHADER_SHADER_TILE_ATTACHMENT_WRITE_QCOM = 41,
    SYNC_FRAGMENT_SHADER_UNIFORM_READ = 42,
    SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ = 43,
    SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE = 44,
    SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ = 45,
    SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE = 46,
    SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ = 47,
    SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_NONCOHERENT_EXT = 48,
    SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_WRITE = 49,
    SYNC_COMPUTE_SHADER_ACCELERATION_STRUCTURE_READ = 50,
    SYNC_COMPUTE_SHADER_DESCRIPTOR_BUFFER_READ_EXT = 51,
    SYNC_COMPUTE_SHADER_SHADER_BINDING_TABLE_READ = 52,
    SYNC_COMPUTE_SHADER_SHADER_SAMPLED_READ = 53,
    SYNC_COMPUTE_SHADER_SHADER_STORAGE_READ = 54,
    SYNC_COMPUTE_SHADER_SHADER_STORAGE_WRITE = 55,
    SYNC_COMPUTE_SHADER_SHADER_TILE_ATTACHMENT_READ_QCOM = 56,
    SYNC_COMPUTE_SHADER_SHADER_TILE_ATTACHMENT_WRITE_QCOM = 57,
    SYNC_COMPUTE_SHADER_UNIFORM_READ = 58,
    SYNC_HOST_HOST_READ = 59,
    SYNC_HOST_HOST_WRITE = 60,
    SYNC_COMMAND_PREPROCESS_EXT_COMMAND_PREPROCESS_READ_EXT = 61,
    SYNC_COMMAND_PREPROCESS_EXT_COMMAND_PREPROCESS_WRITE_EXT = 62,
    SYNC_CONDITIONAL_RENDERING_EXT_CONDITIONAL_RENDERING_READ_EXT = 63,
    SYNC_TASK_SHADER_EXT_ACCELERATION_STRUCTURE_READ = 64,
    SYNC_TASK_SHADER_EXT_DESCRIPTOR_BUFFER_READ_EXT = 65,
    SYNC_TASK_SHADER_EXT_SHADER_BINDING_TABLE_READ = 66,
    SYNC_TASK_SHADER_EXT_SHADER_SAMPLED_READ = 67,
    SYNC_TASK_SHADER_EXT_SHADER_STORAGE_READ = 68,
    SYNC_TASK_SHADER_EXT_SHADER_STORAGE_WRITE = 69,
    SYNC_TASK_SHADER_EXT_UNIFORM_READ = 70,
    SYNC_MESH_SHADER_EXT_ACCELERATION_STRUCTURE_READ = 71,
    SYNC_MESH_SHADER_EXT_DESCRIPTOR_BUFFER_READ_EXT = 72,
    SYNC_MESH_SHADER_EXT_SHADER_BINDING_TABLE_READ = 73,
    SYNC_MESH_SHADER_EXT_SHADER_SAMPLED_READ = 74,
    SYNC_MESH_SHADER_EXT_SHADER_STORAGE_READ = 75,
    SYNC_MESH_SHADER_EXT_SHADER_STORAGE_WRITE = 76,
    SYNC_MESH_SHADER_EXT_UNIFORM_READ = 77,
    SYNC_RAY_TRACING_SHADER_ACCELERATION_STRUCTURE_READ = 78,
    SYNC_RAY_TRACING_SHADER_DESCRIPTOR_BUFFER_READ_EXT = 79,
    SYNC_RAY_TRACING_SHADER_SHADER_BINDING_TABLE_READ = 80,
    SYNC_RAY_TRACING_SHADER_SHADER_SAMPLED_READ = 81,
    SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_READ = 82,
    SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_WRITE = 83,
    SYNC_RAY_TRACING_SHADER_UNIFORM_READ = 84,
    SYNC_FRAGMENT_SHADING_RATE_ATTACHMENT_FRAGMENT_SHADING_RATE_ATTACHMENT_READ = 85,
    SYNC_FRAGMENT_DENSITY_PROCESS_EXT_FRAGMENT_DENSITY_MAP_READ_EXT = 86,
    SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_COUNTER_READ_EXT = 87,
    SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_COUNTER_WRITE_EXT = 88,
    SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_WRITE_EXT = 89,
    SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_READ = 90,
    SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_WRITE = 91,
    SYNC_ACCELERATION_STRUCTURE_BUILD_INDIRECT_COMMAND_READ = 92,
    SYNC_ACCELERATION_STRUCTURE_BUILD_MICROMAP_READ_EXT = 93,
    SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_READ = 94,
    SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_READ = 95,
    SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_WRITE = 96,
    SYNC_VIDEO_DECODE_VIDEO_DECODE_READ = 97,
    SYNC_VIDEO_DECODE_VIDEO_DECODE_WRITE = 98,
    SYNC_VIDEO_ENCODE_VIDEO_ENCODE_READ = 99,
    SYNC_VIDEO_ENCODE_VIDEO_ENCODE_WRITE = 100,
    SYNC_ACCELERATION_STRUCTURE_COPY_ACCELERATION_STRUCTURE_READ = 101,
    SYNC_ACCELERATION_STRUCTURE_COPY_ACCELERATION_STRUCTURE_WRITE = 102,
    SYNC_ACCELERATION_STRUCTURE_COPY_TRANSFER_READ = 103,
    SYNC_ACCELERATION_STRUCTURE_COPY_TRANSFER_WRITE = 104,
    SYNC_OPTICAL_FLOW_NV_OPTICAL_FLOW_READ_NV = 105,
    SYNC_OPTICAL_FLOW_NV_OPTICAL_FLOW_WRITE_NV = 106,
    SYNC_MICROMAP_BUILD_EXT_MICROMAP_READ_EXT = 107,
    SYNC_MICROMAP_BUILD_EXT_MICROMAP_WRITE_EXT = 108,
    SYNC_MICROMAP_BUILD_EXT_SHADER_READ = 109,
    SYNC_MICROMAP_BUILD_EXT_TRANSFER_READ = 110,
    SYNC_MICROMAP_BUILD_EXT_TRANSFER_WRITE = 111,
    SYNC_COPY_TRANSFER_READ = 112,
    SYNC_COPY_TRANSFER_WRITE = 113,
    SYNC_RESOLVE_TRANSFER_READ = 114,
    SYNC_RESOLVE_TRANSFER_WRITE = 115,
    SYNC_BLIT_TRANSFER_READ = 116,
    SYNC_BLIT_TRANSFER_WRITE = 117,
    SYNC_CLEAR_TRANSFER_WRITE = 118,
    SYNC_INDEX_INPUT_INDEX_READ = 119,
    SYNC_VERTEX_ATTRIBUTE_INPUT_VERTEX_ATTRIBUTE_READ = 120,
    SYNC_SUBPASS_SHADER_HUAWEI_ACCELERATION_STRUCTURE_READ = 121,
    SYNC_SUBPASS_SHADER_HUAWEI_DESCRIPTOR_BUFFER_READ_EXT = 122,
    SYNC_SUBPASS_SHADER_HUAWEI_INPUT_ATTACHMENT_READ = 123,
    SYNC_SUBPASS_SHADER_HUAWEI_SHADER_BINDING_TABLE_READ = 124,
    SYNC_SUBPASS_SHADER_HUAWEI_SHADER_SAMPLED_READ = 125,
    SYNC_SUBPASS_SHADER_HUAWEI_SHADER_STORAGE_READ = 126,
    SYNC_SUBPASS_SHADER_HUAWEI_SHADER_STORAGE_WRITE = 127,
    SYNC_SUBPASS_SHADER_HUAWEI_UNIFORM_READ = 128,
    SYNC_INVOCATION_MASK_HUAWEI_INVOCATION_MASK_READ_HUAWEI = 129,
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_ACCELERATION_STRUCTURE_READ = 130,
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_DESCRIPTOR_BUFFER_READ_EXT = 131,
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_BINDING_TABLE_READ = 132,
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_SAMPLED_READ = 133,
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_STORAGE_READ = 134,
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_STORAGE_WRITE = 135,
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_UNIFORM_READ = 136,
    SYNC_CONVERT_COOPERATIVE_VECTOR_MATRIX_NV_TRANSFER_READ = 137,
    SYNC_CONVERT_COOPERATIVE_VECTOR_MATRIX_NV_TRANSFER_WRITE = 138,
    SYNC_PRESENT_ENGINE_SYNCVAL_PRESENT_ACQUIRE_READ_SYNCVAL = 139,
    SYNC_PRESENT_ENGINE_SYNCVAL_PRESENT_PRESENTED_SYNCVAL = 140,
    SYNC_IMAGE_LAYOUT_TRANSITION = 141,
    SYNC_QUEUE_FAMILY_OWNERSHIP_TRANSFER = 142,
};

using SyncAccessFlags = std::bitset<192>;
// Unique bit for each stage/access combination
static const SyncAccessFlags SYNC_DRAW_INDIRECT_INDIRECT_COMMAND_READ_BIT = (SyncAccessFlags(1) << SYNC_DRAW_INDIRECT_INDIRECT_COMMAND_READ);
static const SyncAccessFlags SYNC_DRAW_INDIRECT_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_DRAW_INDIRECT_TRANSFORM_FEEDBACK_COUNTER_READ_EXT);
static const SyncAccessFlags SYNC_VERTEX_SHADER_ACCELERATION_STRUCTURE_READ_BIT = (SyncAccessFlags(1) << SYNC_VERTEX_SHADER_ACCELERATION_STRUCTURE_READ);
static const SyncAccessFlags SYNC_VERTEX_SHADER_DESCRIPTOR_BUFFER_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_VERTEX_SHADER_DESCRIPTOR_BUFFER_READ_EXT);
static const SyncAccessFlags SYNC_VERTEX_SHADER_SHADER_BINDING_TABLE_READ_BIT = (SyncAccessFlags(1) << SYNC_VERTEX_SHADER_SHADER_BINDING_TABLE_READ);
static const SyncAccessFlags SYNC_VERTEX_SHADER_SHADER_SAMPLED_READ_BIT = (SyncAccessFlags(1) << SYNC_VERTEX_SHADER_SHADER_SAMPLED_READ);
static const SyncAccessFlags SYNC_VERTEX_SHADER_SHADER_STORAGE_READ_BIT = (SyncAccessFlags(1) << SYNC_VERTEX_SHADER_SHADER_STORAGE_READ);
static const SyncAccessFlags SYNC_VERTEX_SHADER_SHADER_STORAGE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_VERTEX_SHADER_SHADER_STORAGE_WRITE);
static const SyncAccessFlags SYNC_VERTEX_SHADER_UNIFORM_READ_BIT = (SyncAccessFlags(1) << SYNC_VERTEX_SHADER_UNIFORM_READ);
static const SyncAccessFlags SYNC_TESSELLATION_CONTROL_SHADER_ACCELERATION_STRUCTURE_READ_BIT = (SyncAccessFlags(1) << SYNC_TESSELLATION_CONTROL_SHADER_ACCELERATION_STRUCTURE_READ);
static const SyncAccessFlags SYNC_TESSELLATION_CONTROL_SHADER_DESCRIPTOR_BUFFER_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_TESSELLATION_CONTROL_SHADER_DESCRIPTOR_BUFFER_READ_EXT);
static const SyncAccessFlags SYNC_TESSELLATION_CONTROL_SHADER_SHADER_BINDING_TABLE_READ_BIT = (SyncAccessFlags(1) << SYNC_TESSELLATION_CONTROL_SHADER_SHADER_BINDING_TABLE_READ);
static const SyncAccessFlags SYNC_TESSELLATION_CONTROL_SHADER_SHADER_SAMPLED_READ_BIT = (SyncAccessFlags(1) << SYNC_TESSELLATION_CONTROL_SHADER_SHADER_SAMPLED_READ);
static const SyncAccessFlags SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_READ_BIT = (SyncAccessFlags(1) << SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_READ);
static const SyncAccessFlags SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_WRITE);
static const SyncAccessFlags SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ_BIT = (SyncAccessFlags(1) << SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ);
static const SyncAccessFlags SYNC_TESSELLATION_EVALUATION_SHADER_ACCELERATION_STRUCTURE_READ_BIT = (SyncAccessFlags(1) << SYNC_TESSELLATION_EVALUATION_SHADER_ACCELERATION_STRUCTURE_READ);
static const SyncAccessFlags SYNC_TESSELLATION_EVALUATION_SHADER_DESCRIPTOR_BUFFER_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_TESSELLATION_EVALUATION_SHADER_DESCRIPTOR_BUFFER_READ_EXT);
static const SyncAccessFlags SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_BINDING_TABLE_READ_BIT = (SyncAccessFlags(1) << SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_BINDING_TABLE_READ);
static const SyncAccessFlags SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_SAMPLED_READ_BIT = (SyncAccessFlags(1) << SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_SAMPLED_READ);
static const SyncAccessFlags SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_READ_BIT = (SyncAccessFlags(1) << SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_READ);
static const SyncAccessFlags SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_WRITE);
static const SyncAccessFlags SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ_BIT = (SyncAccessFlags(1) << SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ);
static const SyncAccessFlags SYNC_GEOMETRY_SHADER_ACCELERATION_STRUCTURE_READ_BIT = (SyncAccessFlags(1) << SYNC_GEOMETRY_SHADER_ACCELERATION_STRUCTURE_READ);
static const SyncAccessFlags SYNC_GEOMETRY_SHADER_DESCRIPTOR_BUFFER_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_GEOMETRY_SHADER_DESCRIPTOR_BUFFER_READ_EXT);
static const SyncAccessFlags SYNC_GEOMETRY_SHADER_SHADER_BINDING_TABLE_READ_BIT = (SyncAccessFlags(1) << SYNC_GEOMETRY_SHADER_SHADER_BINDING_TABLE_READ);
static const SyncAccessFlags SYNC_GEOMETRY_SHADER_SHADER_SAMPLED_READ_BIT = (SyncAccessFlags(1) << SYNC_GEOMETRY_SHADER_SHADER_SAMPLED_READ);
static const SyncAccessFlags SYNC_GEOMETRY_SHADER_SHADER_STORAGE_READ_BIT = (SyncAccessFlags(1) << SYNC_GEOMETRY_SHADER_SHADER_STORAGE_READ);
static const SyncAccessFlags SYNC_GEOMETRY_SHADER_SHADER_STORAGE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_GEOMETRY_SHADER_SHADER_STORAGE_WRITE);
static const SyncAccessFlags SYNC_GEOMETRY_SHADER_UNIFORM_READ_BIT = (SyncAccessFlags(1) << SYNC_GEOMETRY_SHADER_UNIFORM_READ);
static const SyncAccessFlags SYNC_FRAGMENT_SHADER_ACCELERATION_STRUCTURE_READ_BIT = (SyncAccessFlags(1) << SYNC_FRAGMENT_SHADER_ACCELERATION_STRUCTURE_READ);
static const SyncAccessFlags SYNC_FRAGMENT_SHADER_COLOR_ATTACHMENT_READ_BIT = (SyncAccessFlags(1) << SYNC_FRAGMENT_SHADER_COLOR_ATTACHMENT_READ);
static const SyncAccessFlags SYNC_FRAGMENT_SHADER_DEPTH_STENCIL_ATTACHMENT_READ_BIT = (SyncAccessFlags(1) << SYNC_FRAGMENT_SHADER_DEPTH_STENCIL_ATTACHMENT_READ);
static const SyncAccessFlags SYNC_FRAGMENT_SHADER_DESCRIPTOR_BUFFER_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_FRAGMENT_SHADER_DESCRIPTOR_BUFFER_READ_EXT);
static const SyncAccessFlags SYNC_FRAGMENT_SHADER_INPUT_ATTACHMENT_READ_BIT = (SyncAccessFlags(1) << SYNC_FRAGMENT_SHADER_INPUT_ATTACHMENT_READ);
static const SyncAccessFlags SYNC_FRAGMENT_SHADER_SHADER_BINDING_TABLE_READ_BIT = (SyncAccessFlags(1) << SYNC_FRAGMENT_SHADER_SHADER_BINDING_TABLE_READ);
static const SyncAccessFlags SYNC_FRAGMENT_SHADER_SHADER_SAMPLED_READ_BIT = (SyncAccessFlags(1) << SYNC_FRAGMENT_SHADER_SHADER_SAMPLED_READ);
static const SyncAccessFlags SYNC_FRAGMENT_SHADER_SHADER_STORAGE_READ_BIT = (SyncAccessFlags(1) << SYNC_FRAGMENT_SHADER_SHADER_STORAGE_READ);
static const SyncAccessFlags SYNC_FRAGMENT_SHADER_SHADER_STORAGE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_FRAGMENT_SHADER_SHADER_STORAGE_WRITE);
static const SyncAccessFlags SYNC_FRAGMENT_SHADER_SHADER_TILE_ATTACHMENT_READ_QCOM_BIT = (SyncAccessFlags(1) << SYNC_FRAGMENT_SHADER_SHADER_TILE_ATTACHMENT_READ_QCOM);
static const SyncAccessFlags SYNC_FRAGMENT_SHADER_SHADER_TILE_ATTACHMENT_WRITE_QCOM_BIT = (SyncAccessFlags(1) << SYNC_FRAGMENT_SHADER_SHADER_TILE_ATTACHMENT_WRITE_QCOM);
static const SyncAccessFlags SYNC_FRAGMENT_SHADER_UNIFORM_READ_BIT = (SyncAccessFlags(1) << SYNC_FRAGMENT_SHADER_UNIFORM_READ);
static const SyncAccessFlags SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ_BIT = (SyncAccessFlags(1) << SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ);
static const SyncAccessFlags SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT = (SyncAccessFlags(1) << SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE);
static const SyncAccessFlags SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ_BIT = (SyncAccessFlags(1) << SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ);
static const SyncAccessFlags SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT = (SyncAccessFlags(1) << SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE);
static const SyncAccessFlags SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_BIT = (SyncAccessFlags(1) << SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ);
static const SyncAccessFlags SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT = (SyncAccessFlags(1) << SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_NONCOHERENT_EXT);
static const SyncAccessFlags SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_WRITE_BIT = (SyncAccessFlags(1) << SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_WRITE);
static const SyncAccessFlags SYNC_COMPUTE_SHADER_ACCELERATION_STRUCTURE_READ_BIT = (SyncAccessFlags(1) << SYNC_COMPUTE_SHADER_ACCELERATION_STRUCTURE_READ);
static const SyncAccessFlags SYNC_COMPUTE_SHADER_DESCRIPTOR_BUFFER_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_COMPUTE_SHADER_DESCRIPTOR_BUFFER_READ_EXT);
static const SyncAccessFlags SYNC_COMPUTE_SHADER_SHADER_BINDING_TABLE_READ_BIT = (SyncAccessFlags(1) << SYNC_COMPUTE_SHADER_SHADER_BINDING_TABLE_READ);
static const SyncAccessFlags SYNC_COMPUTE_SHADER_SHADER_SAMPLED_READ_BIT = (SyncAccessFlags(1) << SYNC_COMPUTE_SHADER_SHADER_SAMPLED_READ);
static const SyncAccessFlags SYNC_COMPUTE_SHADER_SHADER_STORAGE_READ_BIT = (SyncAccessFlags(1) << SYNC_COMPUTE_SHADER_SHADER_STORAGE_READ);
static const SyncAccessFlags SYNC_COMPUTE_SHADER_SHADER_STORAGE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_COMPUTE_SHADER_SHADER_STORAGE_WRITE);
static const SyncAccessFlags SYNC_COMPUTE_SHADER_SHADER_TILE_ATTACHMENT_READ_QCOM_BIT = (SyncAccessFlags(1) << SYNC_COMPUTE_SHADER_SHADER_TILE_ATTACHMENT_READ_QCOM);
static const SyncAccessFlags SYNC_COMPUTE_SHADER_SHADER_TILE_ATTACHMENT_WRITE_QCOM_BIT = (SyncAccessFlags(1) << SYNC_COMPUTE_SHADER_SHADER_TILE_ATTACHMENT_WRITE_QCOM);
static const SyncAccessFlags SYNC_COMPUTE_SHADER_UNIFORM_READ_BIT = (SyncAccessFlags(1) << SYNC_COMPUTE_SHADER_UNIFORM_READ);
static const SyncAccessFlags SYNC_HOST_HOST_READ_BIT = (SyncAccessFlags(1) << SYNC_HOST_HOST_READ);
static const SyncAccessFlags SYNC_HOST_HOST_WRITE_BIT = (SyncAccessFlags(1) << SYNC_HOST_HOST_WRITE);
static const SyncAccessFlags SYNC_COMMAND_PREPROCESS_BIT_EXT_COMMAND_PREPROCESS_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_COMMAND_PREPROCESS_EXT_COMMAND_PREPROCESS_READ_EXT);
static const SyncAccessFlags SYNC_COMMAND_PREPROCESS_BIT_EXT_COMMAND_PREPROCESS_WRITE_BIT_EXT = (SyncAccessFlags(1) << SYNC_COMMAND_PREPROCESS_EXT_COMMAND_PREPROCESS_WRITE_EXT);
static const SyncAccessFlags SYNC_CONDITIONAL_RENDERING_BIT_EXT_CONDITIONAL_RENDERING_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_CONDITIONAL_RENDERING_EXT_CONDITIONAL_RENDERING_READ_EXT);
static const SyncAccessFlags SYNC_TASK_SHADER_EXT_ACCELERATION_STRUCTURE_READ_BIT = (SyncAccessFlags(1) << SYNC_TASK_SHADER_EXT_ACCELERATION_STRUCTURE_READ);
static const SyncAccessFlags SYNC_TASK_SHADER_BIT_EXT_DESCRIPTOR_BUFFER_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_TASK_SHADER_EXT_DESCRIPTOR_BUFFER_READ_EXT);
static const SyncAccessFlags SYNC_TASK_SHADER_EXT_SHADER_BINDING_TABLE_READ_BIT = (SyncAccessFlags(1) << SYNC_TASK_SHADER_EXT_SHADER_BINDING_TABLE_READ);
static const SyncAccessFlags SYNC_TASK_SHADER_EXT_SHADER_SAMPLED_READ_BIT = (SyncAccessFlags(1) << SYNC_TASK_SHADER_EXT_SHADER_SAMPLED_READ);
static const SyncAccessFlags SYNC_TASK_SHADER_EXT_SHADER_STORAGE_READ_BIT = (SyncAccessFlags(1) << SYNC_TASK_SHADER_EXT_SHADER_STORAGE_READ);
static const SyncAccessFlags SYNC_TASK_SHADER_EXT_SHADER_STORAGE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_TASK_SHADER_EXT_SHADER_STORAGE_WRITE);
static const SyncAccessFlags SYNC_TASK_SHADER_EXT_UNIFORM_READ_BIT = (SyncAccessFlags(1) << SYNC_TASK_SHADER_EXT_UNIFORM_READ);
static const SyncAccessFlags SYNC_MESH_SHADER_EXT_ACCELERATION_STRUCTURE_READ_BIT = (SyncAccessFlags(1) << SYNC_MESH_SHADER_EXT_ACCELERATION_STRUCTURE_READ);
static const SyncAccessFlags SYNC_MESH_SHADER_BIT_EXT_DESCRIPTOR_BUFFER_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_MESH_SHADER_EXT_DESCRIPTOR_BUFFER_READ_EXT);
static const SyncAccessFlags SYNC_MESH_SHADER_EXT_SHADER_BINDING_TABLE_READ_BIT = (SyncAccessFlags(1) << SYNC_MESH_SHADER_EXT_SHADER_BINDING_TABLE_READ);
static const SyncAccessFlags SYNC_MESH_SHADER_EXT_SHADER_SAMPLED_READ_BIT = (SyncAccessFlags(1) << SYNC_MESH_SHADER_EXT_SHADER_SAMPLED_READ);
static const SyncAccessFlags SYNC_MESH_SHADER_EXT_SHADER_STORAGE_READ_BIT = (SyncAccessFlags(1) << SYNC_MESH_SHADER_EXT_SHADER_STORAGE_READ);
static const SyncAccessFlags SYNC_MESH_SHADER_EXT_SHADER_STORAGE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_MESH_SHADER_EXT_SHADER_STORAGE_WRITE);
static const SyncAccessFlags SYNC_MESH_SHADER_EXT_UNIFORM_READ_BIT = (SyncAccessFlags(1) << SYNC_MESH_SHADER_EXT_UNIFORM_READ);
static const SyncAccessFlags SYNC_RAY_TRACING_SHADER_ACCELERATION_STRUCTURE_READ_BIT = (SyncAccessFlags(1) << SYNC_RAY_TRACING_SHADER_ACCELERATION_STRUCTURE_READ);
static const SyncAccessFlags SYNC_RAY_TRACING_SHADER_DESCRIPTOR_BUFFER_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_RAY_TRACING_SHADER_DESCRIPTOR_BUFFER_READ_EXT);
static const SyncAccessFlags SYNC_RAY_TRACING_SHADER_SHADER_BINDING_TABLE_READ_BIT = (SyncAccessFlags(1) << SYNC_RAY_TRACING_SHADER_SHADER_BINDING_TABLE_READ);
static const SyncAccessFlags SYNC_RAY_TRACING_SHADER_SHADER_SAMPLED_READ_BIT = (SyncAccessFlags(1) << SYNC_RAY_TRACING_SHADER_SHADER_SAMPLED_READ);
static const SyncAccessFlags SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_READ_BIT = (SyncAccessFlags(1) << SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_READ);
static const SyncAccessFlags SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_WRITE);
static const SyncAccessFlags SYNC_RAY_TRACING_SHADER_UNIFORM_READ_BIT = (SyncAccessFlags(1) << SYNC_RAY_TRACING_SHADER_UNIFORM_READ);
static const SyncAccessFlags SYNC_FRAGMENT_SHADING_RATE_ATTACHMENT_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT = (SyncAccessFlags(1) << SYNC_FRAGMENT_SHADING_RATE_ATTACHMENT_FRAGMENT_SHADING_RATE_ATTACHMENT_READ);
static const SyncAccessFlags SYNC_FRAGMENT_DENSITY_PROCESS_BIT_EXT_FRAGMENT_DENSITY_MAP_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_FRAGMENT_DENSITY_PROCESS_EXT_FRAGMENT_DENSITY_MAP_READ_EXT);
static const SyncAccessFlags SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_COUNTER_READ_EXT);
static const SyncAccessFlags SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT = (SyncAccessFlags(1) << SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_COUNTER_WRITE_EXT);
static const SyncAccessFlags SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_WRITE_BIT_EXT = (SyncAccessFlags(1) << SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_WRITE_EXT);
static const SyncAccessFlags SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_READ_BIT = (SyncAccessFlags(1) << SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_READ);
static const SyncAccessFlags SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_WRITE);
static const SyncAccessFlags SYNC_ACCELERATION_STRUCTURE_BUILD_INDIRECT_COMMAND_READ_BIT = (SyncAccessFlags(1) << SYNC_ACCELERATION_STRUCTURE_BUILD_INDIRECT_COMMAND_READ);
static const SyncAccessFlags SYNC_ACCELERATION_STRUCTURE_BUILD_MICROMAP_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_ACCELERATION_STRUCTURE_BUILD_MICROMAP_READ_EXT);
static const SyncAccessFlags SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_READ_BIT = (SyncAccessFlags(1) << SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_READ);
static const SyncAccessFlags SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_READ_BIT = (SyncAccessFlags(1) << SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_READ);
static const SyncAccessFlags SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_WRITE_BIT = (SyncAccessFlags(1) << SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_WRITE);
static const SyncAccessFlags SYNC_VIDEO_DECODE_VIDEO_DECODE_READ_BIT = (SyncAccessFlags(1) << SYNC_VIDEO_DECODE_VIDEO_DECODE_READ);
static const SyncAccessFlags SYNC_VIDEO_DECODE_VIDEO_DECODE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_VIDEO_DECODE_VIDEO_DECODE_WRITE);
static const SyncAccessFlags SYNC_VIDEO_ENCODE_VIDEO_ENCODE_READ_BIT = (SyncAccessFlags(1) << SYNC_VIDEO_ENCODE_VIDEO_ENCODE_READ);
static const SyncAccessFlags SYNC_VIDEO_ENCODE_VIDEO_ENCODE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_VIDEO_ENCODE_VIDEO_ENCODE_WRITE);
static const SyncAccessFlags SYNC_ACCELERATION_STRUCTURE_COPY_ACCELERATION_STRUCTURE_READ_BIT = (SyncAccessFlags(1) << SYNC_ACCELERATION_STRUCTURE_COPY_ACCELERATION_STRUCTURE_READ);
static const SyncAccessFlags SYNC_ACCELERATION_STRUCTURE_COPY_ACCELERATION_STRUCTURE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_ACCELERATION_STRUCTURE_COPY_ACCELERATION_STRUCTURE_WRITE);
static const SyncAccessFlags SYNC_ACCELERATION_STRUCTURE_COPY_TRANSFER_READ_BIT = (SyncAccessFlags(1) << SYNC_ACCELERATION_STRUCTURE_COPY_TRANSFER_READ);
static const SyncAccessFlags SYNC_ACCELERATION_STRUCTURE_COPY_TRANSFER_WRITE_BIT = (SyncAccessFlags(1) << SYNC_ACCELERATION_STRUCTURE_COPY_TRANSFER_WRITE);
static const SyncAccessFlags SYNC_OPTICAL_FLOW_BIT_NV_OPTICAL_FLOW_READ_BIT_NV = (SyncAccessFlags(1) << SYNC_OPTICAL_FLOW_NV_OPTICAL_FLOW_READ_NV);
static const SyncAccessFlags SYNC_OPTICAL_FLOW_BIT_NV_OPTICAL_FLOW_WRITE_BIT_NV = (SyncAccessFlags(1) << SYNC_OPTICAL_FLOW_NV_OPTICAL_FLOW_WRITE_NV);
static const SyncAccessFlags SYNC_MICROMAP_BUILD_BIT_EXT_MICROMAP_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_MICROMAP_BUILD_EXT_MICROMAP_READ_EXT);
static const SyncAccessFlags SYNC_MICROMAP_BUILD_BIT_EXT_MICROMAP_WRITE_BIT_EXT = (SyncAccessFlags(1) << SYNC_MICROMAP_BUILD_EXT_MICROMAP_WRITE_EXT);
static const SyncAccessFlags SYNC_MICROMAP_BUILD_EXT_SHADER_READ_BIT = (SyncAccessFlags(1) << SYNC_MICROMAP_BUILD_EXT_SHADER_READ);
static const SyncAccessFlags SYNC_MICROMAP_BUILD_EXT_TRANSFER_READ_BIT = (SyncAccessFlags(1) << SYNC_MICROMAP_BUILD_EXT_TRANSFER_READ);
static const SyncAccessFlags SYNC_MICROMAP_BUILD_EXT_TRANSFER_WRITE_BIT = (SyncAccessFlags(1) << SYNC_MICROMAP_BUILD_EXT_TRANSFER_WRITE);
static const SyncAccessFlags SYNC_COPY_TRANSFER_READ_BIT = (SyncAccessFlags(1) << SYNC_COPY_TRANSFER_READ);
static const SyncAccessFlags SYNC_COPY_TRANSFER_WRITE_BIT = (SyncAccessFlags(1) << SYNC_COPY_TRANSFER_WRITE);
static const SyncAccessFlags SYNC_RESOLVE_TRANSFER_READ_BIT = (SyncAccessFlags(1) << SYNC_RESOLVE_TRANSFER_READ);
static const SyncAccessFlags SYNC_RESOLVE_TRANSFER_WRITE_BIT = (SyncAccessFlags(1) << SYNC_RESOLVE_TRANSFER_WRITE);
static const SyncAccessFlags SYNC_BLIT_TRANSFER_READ_BIT = (SyncAccessFlags(1) << SYNC_BLIT_TRANSFER_READ);
static const SyncAccessFlags SYNC_BLIT_TRANSFER_WRITE_BIT = (SyncAccessFlags(1) << SYNC_BLIT_TRANSFER_WRITE);
static const SyncAccessFlags SYNC_CLEAR_TRANSFER_WRITE_BIT = (SyncAccessFlags(1) << SYNC_CLEAR_TRANSFER_WRITE);
static const SyncAccessFlags SYNC_INDEX_INPUT_INDEX_READ_BIT = (SyncAccessFlags(1) << SYNC_INDEX_INPUT_INDEX_READ);
static const SyncAccessFlags SYNC_VERTEX_ATTRIBUTE_INPUT_VERTEX_ATTRIBUTE_READ_BIT = (SyncAccessFlags(1) << SYNC_VERTEX_ATTRIBUTE_INPUT_VERTEX_ATTRIBUTE_READ);
static const SyncAccessFlags SYNC_SUBPASS_SHADER_HUAWEI_ACCELERATION_STRUCTURE_READ_BIT = (SyncAccessFlags(1) << SYNC_SUBPASS_SHADER_HUAWEI_ACCELERATION_STRUCTURE_READ);
static const SyncAccessFlags SYNC_SUBPASS_SHADER_HUAWEI_DESCRIPTOR_BUFFER_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_SUBPASS_SHADER_HUAWEI_DESCRIPTOR_BUFFER_READ_EXT);
static const SyncAccessFlags SYNC_SUBPASS_SHADER_HUAWEI_INPUT_ATTACHMENT_READ_BIT = (SyncAccessFlags(1) << SYNC_SUBPASS_SHADER_HUAWEI_INPUT_ATTACHMENT_READ);
static const SyncAccessFlags SYNC_SUBPASS_SHADER_HUAWEI_SHADER_BINDING_TABLE_READ_BIT = (SyncAccessFlags(1) << SYNC_SUBPASS_SHADER_HUAWEI_SHADER_BINDING_TABLE_READ);
static const SyncAccessFlags SYNC_SUBPASS_SHADER_HUAWEI_SHADER_SAMPLED_READ_BIT = (SyncAccessFlags(1) << SYNC_SUBPASS_SHADER_HUAWEI_SHADER_SAMPLED_READ);
static const SyncAccessFlags SYNC_SUBPASS_SHADER_HUAWEI_SHADER_STORAGE_READ_BIT = (SyncAccessFlags(1) << SYNC_SUBPASS_SHADER_HUAWEI_SHADER_STORAGE_READ);
static const SyncAccessFlags SYNC_SUBPASS_SHADER_HUAWEI_SHADER_STORAGE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_SUBPASS_SHADER_HUAWEI_SHADER_STORAGE_WRITE);
static const SyncAccessFlags SYNC_SUBPASS_SHADER_HUAWEI_UNIFORM_READ_BIT = (SyncAccessFlags(1) << SYNC_SUBPASS_SHADER_HUAWEI_UNIFORM_READ);
static const SyncAccessFlags SYNC_INVOCATION_MASK_HUAWEI_INVOCATION_MASK_READ_HUAWEI_BIT = (SyncAccessFlags(1) << SYNC_INVOCATION_MASK_HUAWEI_INVOCATION_MASK_READ_HUAWEI);
static const SyncAccessFlags SYNC_CLUSTER_CULLING_SHADER_HUAWEI_ACCELERATION_STRUCTURE_READ_BIT = (SyncAccessFlags(1) << SYNC_CLUSTER_CULLING_SHADER_HUAWEI_ACCELERATION_STRUCTURE_READ);
static const SyncAccessFlags SYNC_CLUSTER_CULLING_SHADER_HUAWEI_DESCRIPTOR_BUFFER_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_CLUSTER_CULLING_SHADER_HUAWEI_DESCRIPTOR_BUFFER_READ_EXT);
static const SyncAccessFlags SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_BINDING_TABLE_READ_BIT = (SyncAccessFlags(1) << SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_BINDING_TABLE_READ);
static const SyncAccessFlags SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_SAMPLED_READ_BIT = (SyncAccessFlags(1) << SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_SAMPLED_READ);
static const SyncAccessFlags SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_STORAGE_READ_BIT = (SyncAccessFlags(1) << SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_STORAGE_READ);
static const SyncAccessFlags SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_STORAGE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_STORAGE_WRITE);
static const SyncAccessFlags SYNC_CLUSTER_CULLING_SHADER_HUAWEI_UNIFORM_READ_BIT = (SyncAccessFlags(1) << SYNC_CLUSTER_CULLING_SHADER_HUAWEI_UNIFORM_READ);
static const SyncAccessFlags SYNC_CONVERT_COOPERATIVE_VECTOR_MATRIX_NV_TRANSFER_READ_BIT = (SyncAccessFlags(1) << SYNC_CONVERT_COOPERATIVE_VECTOR_MATRIX_NV_TRANSFER_READ);
static const SyncAccessFlags SYNC_CONVERT_COOPERATIVE_VECTOR_MATRIX_NV_TRANSFER_WRITE_BIT = (SyncAccessFlags(1) << SYNC_CONVERT_COOPERATIVE_VECTOR_MATRIX_NV_TRANSFER_WRITE);
static const SyncAccessFlags SYNC_PRESENT_ENGINE_BIT_SYNCVAL_PRESENT_ACQUIRE_READ_BIT_SYNCVAL = (SyncAccessFlags(1) << SYNC_PRESENT_ENGINE_SYNCVAL_PRESENT_ACQUIRE_READ_SYNCVAL);
static const SyncAccessFlags SYNC_PRESENT_ENGINE_BIT_SYNCVAL_PRESENT_PRESENTED_BIT_SYNCVAL = (SyncAccessFlags(1) << SYNC_PRESENT_ENGINE_SYNCVAL_PRESENT_PRESENTED_SYNCVAL);
static const SyncAccessFlags SYNC_IMAGE_LAYOUT_TRANSITION_BIT = (SyncAccessFlags(1) << SYNC_IMAGE_LAYOUT_TRANSITION);
static const SyncAccessFlags SYNC_QUEUE_FAMILY_OWNERSHIP_TRANSFER_BIT = (SyncAccessFlags(1) << SYNC_QUEUE_FAMILY_OWNERSHIP_TRANSFER);

struct SyncAccessInfo {
    const char *name;
    VkPipelineStageFlagBits2 stage_mask;
    VkAccessFlagBits2 access_mask;
    SyncAccessIndex access_index;
    SyncAccessFlags access_bit;
};

// Array of text names and component masks for each stage/access index
const std::array<SyncAccessInfo, 143>& GetSyncAccessInfos();

// Constants defining the mask of all read and write access states
static const SyncAccessFlags syncAccessReadMask = ( //  Mask of all read accesses
    SYNC_DRAW_INDIRECT_INDIRECT_COMMAND_READ_BIT |
    SYNC_DRAW_INDIRECT_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT |
    SYNC_VERTEX_SHADER_ACCELERATION_STRUCTURE_READ_BIT |
    SYNC_VERTEX_SHADER_DESCRIPTOR_BUFFER_READ_BIT_EXT |
    SYNC_VERTEX_SHADER_SHADER_BINDING_TABLE_READ_BIT |
    SYNC_VERTEX_SHADER_SHADER_SAMPLED_READ_BIT |
    SYNC_VERTEX_SHADER_SHADER_STORAGE_READ_BIT |
    SYNC_VERTEX_SHADER_UNIFORM_READ_BIT |
    SYNC_TESSELLATION_CONTROL_SHADER_ACCELERATION_STRUCTURE_READ_BIT |
    SYNC_TESSELLATION_CONTROL_SHADER_DESCRIPTOR_BUFFER_READ_BIT_EXT |
    SYNC_TESSELLATION_CONTROL_SHADER_SHADER_BINDING_TABLE_READ_BIT |
    SYNC_TESSELLATION_CONTROL_SHADER_SHADER_SAMPLED_READ_BIT |
    SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_READ_BIT |
    SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ_BIT |
    SYNC_TESSELLATION_EVALUATION_SHADER_ACCELERATION_STRUCTURE_READ_BIT |
    SYNC_TESSELLATION_EVALUATION_SHADER_DESCRIPTOR_BUFFER_READ_BIT_EXT |
    SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_BINDING_TABLE_READ_BIT |
    SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_SAMPLED_READ_BIT |
    SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_READ_BIT |
    SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ_BIT |
    SYNC_GEOMETRY_SHADER_ACCELERATION_STRUCTURE_READ_BIT |
    SYNC_GEOMETRY_SHADER_DESCRIPTOR_BUFFER_READ_BIT_EXT |
    SYNC_GEOMETRY_SHADER_SHADER_BINDING_TABLE_READ_BIT |
    SYNC_GEOMETRY_SHADER_SHADER_SAMPLED_READ_BIT |
    SYNC_GEOMETRY_SHADER_SHADER_STORAGE_READ_BIT |
    SYNC_GEOMETRY_SHADER_UNIFORM_READ_BIT |
    SYNC_FRAGMENT_SHADER_ACCELERATION_STRUCTURE_READ_BIT |
    SYNC_FRAGMENT_SHADER_COLOR_ATTACHMENT_READ_BIT |
    SYNC_FRAGMENT_SHADER_DEPTH_STENCIL_ATTACHMENT_READ_BIT |
    SYNC_FRAGMENT_SHADER_DESCRIPTOR_BUFFER_READ_BIT_EXT |
    SYNC_FRAGMENT_SHADER_INPUT_ATTACHMENT_READ_BIT |
    SYNC_FRAGMENT_SHADER_SHADER_BINDING_TABLE_READ_BIT |
    SYNC_FRAGMENT_SHADER_SHADER_SAMPLED_READ_BIT |
    SYNC_FRAGMENT_SHADER_SHADER_STORAGE_READ_BIT |
    SYNC_FRAGMENT_SHADER_SHADER_TILE_ATTACHMENT_READ_QCOM_BIT |
    SYNC_FRAGMENT_SHADER_UNIFORM_READ_BIT |
    SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ_BIT |
    SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ_BIT |
    SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_BIT |
    SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT |
    SYNC_COMPUTE_SHADER_ACCELERATION_STRUCTURE_READ_BIT |
    SYNC_COMPUTE_SHADER_DESCRIPTOR_BUFFER_READ_BIT_EXT |
    SYNC_COMPUTE_SHADER_SHADER_BINDING_TABLE_READ_BIT |
    SYNC_COMPUTE_SHADER_SHADER_SAMPLED_READ_BIT |
    SYNC_COMPUTE_SHADER_SHADER_STORAGE_READ_BIT |
    SYNC_COMPUTE_SHADER_SHADER_TILE_ATTACHMENT_READ_QCOM_BIT |
    SYNC_COMPUTE_SHADER_UNIFORM_READ_BIT |
    SYNC_HOST_HOST_READ_BIT |
    SYNC_COMMAND_PREPROCESS_BIT_EXT_COMMAND_PREPROCESS_READ_BIT_EXT |
    SYNC_CONDITIONAL_RENDERING_BIT_EXT_CONDITIONAL_RENDERING_READ_BIT_EXT |
    SYNC_TASK_SHADER_EXT_ACCELERATION_STRUCTURE_READ_BIT |
    SYNC_TASK_SHADER_BIT_EXT_DESCRIPTOR_BUFFER_READ_BIT_EXT |
    SYNC_TASK_SHADER_EXT_SHADER_BINDING_TABLE_READ_BIT |
    SYNC_TASK_SHADER_EXT_SHADER_SAMPLED_READ_BIT |
    SYNC_TASK_SHADER_EXT_SHADER_STORAGE_READ_BIT |
    SYNC_TASK_SHADER_EXT_UNIFORM_READ_BIT |
    SYNC_MESH_SHADER_EXT_ACCELERATION_STRUCTURE_READ_BIT |
    SYNC_MESH_SHADER_BIT_EXT_DESCRIPTOR_BUFFER_READ_BIT_EXT |
    SYNC_MESH_SHADER_EXT_SHADER_BINDING_TABLE_READ_BIT |
    SYNC_MESH_SHADER_EXT_SHADER_SAMPLED_READ_BIT |
    SYNC_MESH_SHADER_EXT_SHADER_STORAGE_READ_BIT |
    SYNC_MESH_SHADER_EXT_UNIFORM_READ_BIT |
    SYNC_RAY_TRACING_SHADER_ACCELERATION_STRUCTURE_READ_BIT |
    SYNC_RAY_TRACING_SHADER_DESCRIPTOR_BUFFER_READ_BIT_EXT |
    SYNC_RAY_TRACING_SHADER_SHADER_BINDING_TABLE_READ_BIT |
    SYNC_RAY_TRACING_SHADER_SHADER_SAMPLED_READ_BIT |
    SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_READ_BIT |
    SYNC_RAY_TRACING_SHADER_UNIFORM_READ_BIT |
    SYNC_FRAGMENT_SHADING_RATE_ATTACHMENT_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT |
    SYNC_FRAGMENT_DENSITY_PROCESS_BIT_EXT_FRAGMENT_DENSITY_MAP_READ_BIT_EXT |
    SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT |
    SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_READ_BIT |
    SYNC_ACCELERATION_STRUCTURE_BUILD_INDIRECT_COMMAND_READ_BIT |
    SYNC_ACCELERATION_STRUCTURE_BUILD_MICROMAP_READ_BIT_EXT |
    SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_READ_BIT |
    SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_READ_BIT |
    SYNC_VIDEO_DECODE_VIDEO_DECODE_READ_BIT |
    SYNC_VIDEO_ENCODE_VIDEO_ENCODE_READ_BIT |
    SYNC_ACCELERATION_STRUCTURE_COPY_ACCELERATION_STRUCTURE_READ_BIT |
    SYNC_ACCELERATION_STRUCTURE_COPY_TRANSFER_READ_BIT |
    SYNC_OPTICAL_FLOW_BIT_NV_OPTICAL_FLOW_READ_BIT_NV |
    SYNC_MICROMAP_BUILD_BIT_EXT_MICROMAP_READ_BIT_EXT |
    SYNC_MICROMAP_BUILD_EXT_SHADER_READ_BIT |
    SYNC_MICROMAP_BUILD_EXT_TRANSFER_READ_BIT |
    SYNC_COPY_TRANSFER_READ_BIT |
    SYNC_RESOLVE_TRANSFER_READ_BIT |
    SYNC_BLIT_TRANSFER_READ_BIT |
    SYNC_INDEX_INPUT_INDEX_READ_BIT |
    SYNC_VERTEX_ATTRIBUTE_INPUT_VERTEX_ATTRIBUTE_READ_BIT |
    SYNC_SUBPASS_SHADER_HUAWEI_ACCELERATION_STRUCTURE_READ_BIT |
    SYNC_SUBPASS_SHADER_HUAWEI_DESCRIPTOR_BUFFER_READ_BIT_EXT |
    SYNC_SUBPASS_SHADER_HUAWEI_INPUT_ATTACHMENT_READ_BIT |
    SYNC_SUBPASS_SHADER_HUAWEI_SHADER_BINDING_TABLE_READ_BIT |
    SYNC_SUBPASS_SHADER_HUAWEI_SHADER_SAMPLED_READ_BIT |
    SYNC_SUBPASS_SHADER_HUAWEI_SHADER_STORAGE_READ_BIT |
    SYNC_SUBPASS_SHADER_HUAWEI_UNIFORM_READ_BIT |
    SYNC_INVOCATION_MASK_HUAWEI_INVOCATION_MASK_READ_HUAWEI_BIT |
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_ACCELERATION_STRUCTURE_READ_BIT |
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_DESCRIPTOR_BUFFER_READ_BIT_EXT |
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_BINDING_TABLE_READ_BIT |
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_SAMPLED_READ_BIT |
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_STORAGE_READ_BIT |
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_UNIFORM_READ_BIT |
    SYNC_CONVERT_COOPERATIVE_VECTOR_MATRIX_NV_TRANSFER_READ_BIT |
    SYNC_PRESENT_ENGINE_BIT_SYNCVAL_PRESENT_ACQUIRE_READ_BIT_SYNCVAL
);

static const SyncAccessFlags syncAccessWriteMask = ( //  Mask of all write accesses
    SYNC_VERTEX_SHADER_SHADER_STORAGE_WRITE_BIT |
    SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_WRITE_BIT |
    SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_WRITE_BIT |
    SYNC_GEOMETRY_SHADER_SHADER_STORAGE_WRITE_BIT |
    SYNC_FRAGMENT_SHADER_SHADER_STORAGE_WRITE_BIT |
    SYNC_FRAGMENT_SHADER_SHADER_TILE_ATTACHMENT_WRITE_QCOM_BIT |
    SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT |
    SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT |
    SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_WRITE_BIT |
    SYNC_COMPUTE_SHADER_SHADER_STORAGE_WRITE_BIT |
    SYNC_COMPUTE_SHADER_SHADER_TILE_ATTACHMENT_WRITE_QCOM_BIT |
    SYNC_HOST_HOST_WRITE_BIT |
    SYNC_COMMAND_PREPROCESS_BIT_EXT_COMMAND_PREPROCESS_WRITE_BIT_EXT |
    SYNC_TASK_SHADER_EXT_SHADER_STORAGE_WRITE_BIT |
    SYNC_MESH_SHADER_EXT_SHADER_STORAGE_WRITE_BIT |
    SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_WRITE_BIT |
    SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT |
    SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_WRITE_BIT_EXT |
    SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_WRITE_BIT |
    SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_WRITE_BIT |
    SYNC_VIDEO_DECODE_VIDEO_DECODE_WRITE_BIT |
    SYNC_VIDEO_ENCODE_VIDEO_ENCODE_WRITE_BIT |
    SYNC_ACCELERATION_STRUCTURE_COPY_ACCELERATION_STRUCTURE_WRITE_BIT |
    SYNC_ACCELERATION_STRUCTURE_COPY_TRANSFER_WRITE_BIT |
    SYNC_OPTICAL_FLOW_BIT_NV_OPTICAL_FLOW_WRITE_BIT_NV |
    SYNC_MICROMAP_BUILD_BIT_EXT_MICROMAP_WRITE_BIT_EXT |
    SYNC_MICROMAP_BUILD_EXT_TRANSFER_WRITE_BIT |
    SYNC_COPY_TRANSFER_WRITE_BIT |
    SYNC_RESOLVE_TRANSFER_WRITE_BIT |
    SYNC_BLIT_TRANSFER_WRITE_BIT |
    SYNC_CLEAR_TRANSFER_WRITE_BIT |
    SYNC_SUBPASS_SHADER_HUAWEI_SHADER_STORAGE_WRITE_BIT |
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_STORAGE_WRITE_BIT |
    SYNC_CONVERT_COOPERATIVE_VECTOR_MATRIX_NV_TRANSFER_WRITE_BIT |
    SYNC_PRESENT_ENGINE_BIT_SYNCVAL_PRESENT_PRESENTED_BIT_SYNCVAL |
    SYNC_IMAGE_LAYOUT_TRANSITION_BIT |
    SYNC_QUEUE_FAMILY_OWNERSHIP_TRANSFER_BIT
);

// Bit order mask of accesses for each stage. Order matters, don't try to use vvl::unordered_map
const std::map<VkPipelineStageFlagBits2, SyncAccessFlags>& syncAccessMaskByStageBit();

// Bit order mask of accesses for each VkAccess. Order matters, don't try to use vvl::unordered_map
const std::map<VkAccessFlagBits2, SyncAccessFlags>& syncAccessMaskByAccessBit();

// Direct VkPipelineStageFlags to valid VkAccessFlags lookup table
const vvl::unordered_map<VkPipelineStageFlagBits2, VkAccessFlags2>& syncDirectStageToAccessMask();

// Pipeline stages corresponding to VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT for each VkQueueFlagBits
const vvl::unordered_map<VkQueueFlagBits, VkPipelineStageFlags2>& syncAllCommandStagesByQueueFlags();

// Masks of logically earlier stage flags for a given stage flag
const vvl::unordered_map<VkPipelineStageFlagBits2, VkPipelineStageFlags2>& syncLogicallyEarlierStages();

// Masks of logically later stage flags for a given stage flag
const vvl::unordered_map<VkPipelineStageFlagBits2, VkPipelineStageFlags2>& syncLogicallyLaterStages();
// clang-format on

// NOLINTEND
