'\" t
.TH PLAYBACK 1 "30 December 2021"
.SH NAME
playback \-
.SM IBM
x3270 trace file playback tool
.SH SYNOPSIS
.B playback
[
.B \-b
] [
.B \-w
] [
.B \-p
.I port
]
.I trace_file
.SH DESCRIPTION
.B playback
opens a trace file (presumably created by the
.B x3270
.I "Trace Data Stream"
facility) and plays the host data it contains back over a socket to processes
that connect to it.
It also displays the data produced by the process in response.
.LP
It runs in one of two modes, bidirectional and interactive.
In bidirectional mode, selected by the
.B \-b
option,
.B playback
verfies that the emulator connected to it sends the correct stream of bytes
in response to the host stream.
This is useful for automated testing.
.LP
Otherwise,
.B playback
is used interactively.
The
.B \-w
command-line option prevents processing interactive commands until a process
connects; otherwise commands are processed immediately.
Keyboard commands control the flow of data from the file to the socket.
These commands are:
.TP
.B s
Send one line of data.
.TP
.B r
Send one record of data (send data until the TELNET EOR sequence is reached).
.TP
.B m
Send data util a mark (a line beginning with $) is encountered in the file.
.TP
.B e
Send the rest of the data in the file.
.TP
.B t
Send a TELNET DO TIMING MARK sequence.
.TP
.B c
Echo the command to stdout as a comment.
.TP
.B d
Disconnect the current socket and wait for another connection.
.TP
.B q
Exit
.B playback.
.SH EXIT STATUS
.TP
.B 0
Success.
.TP
.B 1
Set-up failure.
.TP
.B 2
Run-time failure, such as mismatched data.
.SH EXAMPLES
Suppose you wanted to interactively play back a trace file called
.B /tmp/x3trc.12345.
In one window, run:
.sp
	playback /tmp/x3trc.12345
.LP
In another window, start
.B x3270
with the command:
.sp
	x3270 localhost:4001
.LP
.B playback
will announce the connection.
.LP
Thereafter, the
.B s
and
.B r
commands will send data from the file to
.B x3270.
.LP
To automate a unit test to verify that
.B x3270
produces a known data stream, run:
.sp
	playback -b /tmp/x3trc.12345
.LP
In another window, start
.B x3270
as above.
.B playback
will exit with status 0 if the byte stream matches, and status 2
if it does not.
.SH "SEE ALSO"
.IR x3270 (1)
