/**
 * 
 * $Id: CSText.h,v 1.4 2000/09/23 14:51:42 amai Exp $
 *
 * Copyright (C) 1997 Free Software Foundation, Inc.
 * Copyright (C) 1997-2000 LessTif Development Team
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

/*
   These are all only stubs, etc.
   We don't really have CSText ...
*/

#ifndef _XM_CSTEXT_H
#define _XM_CSTEXT_H

#include <Xm/Xm.h>

#ifdef __cplusplus
extern "C" {
#endif

extern WidgetClass xmCSTextWidgetClass;

typedef struct _XmCSTextRec *XmCSTextWidget;
typedef struct _XmCSTextClassRec *XmCSTextWidgetClass;
typedef struct _XmCSTextSourceRec *XmCSTextSource;

#ifndef XmIsCSText
#define XmIsCSText(w) XtIsSubclass(w, xmCSTextWidgetClass)
#endif

Widget XmCreateCSText(Widget parent,
                      String name,
                      ArgList arglist,
                      Cardinal argcount);
Widget XmCreateScrolledCSText(Widget parent,
                              String name,
                              ArgList arglist,
                              Cardinal argcount);
XmString XmCSTextGetString(Widget widget);
void XmCSTextSetString(Widget w, XmString value);
void XmCSTextReplace(Widget w,
                     XmTextPosition from_pos,
                     XmTextPosition to_pos,
                     XmString value);
void XmCSTextRead(Widget w,
                  XmTextPosition frompos,
                  XmTextPosition topos,
                  XmString *value);
void XmCSTextInsert(Widget w,
                    XmTextPosition position,
                    XmString value);
Boolean XmCSTextGetEditable(Widget w);
void XmCSTextSetEditable(Widget w,
#if NeedWidePrototypes
                         int editable);
#else
                         Boolean editable);
#endif 
int XmCSTextGetMaxLength(Widget w);
void XmCSTextSetMaxLength(Widget w, int max_length);
XmStringDirection XmCSTextGetTextPath(Widget w);
void XmCSTextSetTextPath(Widget w, XmStringDirection path);
XmString XmCSTextGetSelection(Widget w);
Boolean XmCSTextGetSelectionPosition(Widget w, 
                                     XmTextPosition *left,
                                     XmTextPosition *right);
void XmCSTextSetSelection(Widget w,
                          XmTextPosition first,
                          XmTextPosition last,
                          Time time);
void XmCSTextClearSelection(Widget w, Time time);
Boolean XmCSTextCopy(Widget w, Time time);
Boolean XmCSTextCut(Widget w, Time time);
Boolean XmCSTextPaste(Widget w);
Boolean XmCSTextRemove(Widget w);
void XmCSTextShowPosition(Widget w, XmTextPosition position);
void XmCSTextScroll(Widget w, int lines);
void XmCSTextDisableRedisplay(Widget w);
void XmCSTextEnableRedisplay(Widget w);
void XmCSTextMarkRedraw(Widget w,
                        XmTextPosition  left,
                        XmTextPosition  right);
void XmCSTextSetHighlight(Widget w,
                          XmTextPosition left,
                          XmTextPosition right,
                          XmHighlightMode mode);
XmTextPosition XmCSTextGetTopCharacter(Widget w);
void XmCSTextSetTopCharacter(Widget w, XmTextPosition top_position);
XmTextPosition XmCSTextGetLastPosition(Widget w);
XmTextPosition XmCSTextGetCursorPosition(Widget w);
XmTextPosition XmCSTextGetInsertionPosition(Widget w);
void XmCSTextSetInsertionPosition(Widget w, XmTextPosition position);
XmTextPosition XmCSTextXYToPos(Widget w,
#if NeedWidePrototypes
                               int x,
                               int y);
#else
                               Position x,
                               Position y);
#endif
Boolean XmCSTextPosToXY(Widget w,
                        XmTextPosition position,
                        Position *x,
                        Position *y);
XmString XmCSTextGetStringWrapped(Widget w,
                        XmTextPosition start,
                        XmTextPosition end);
Boolean XmCSTextFindString(Widget w,
                           XmTextPosition start,
                           String string,
                           XmTextDirection direction,
                           XmTextPosition *position );
Boolean XmCSTextFindStringWcs(Widget w,
                              XmTextPosition start,
                              wchar_t *wcstring,
                              XmTextDirection direction,
                              XmTextPosition *position );

int XmCSTextGetSubstring(Widget w,
                         XmTextPosition start,
                         int num_chars,
                         int buffer_size,
                         String buffer);

int XmCSTextGetSubstringWcs(Widget w,
                            XmTextPosition start,
                            int num_chars,
                            int buffer_size,
                            wchar_t *buffer);

void XmCSTextSetAddMode(Widget w,
#if NeedWidePrototypes
                        int state);
#else
                        Boolean state);
#endif

void XmCSTextSetSource(Widget w,
                       XmCSTextSource source,
                       XmTextPosition top_character,
                       XmTextPosition cursor_position);
XmCSTextSource XmCSTextGetSource(Widget w);
int XmCSTextGetBaseline(Widget w);
Boolean XmCSTextPasteLink(Widget w);
Boolean XmCSTextCopyLink(Widget w, Time time);

typedef struct {
    int			reason;
    XEvent		*event;
    Boolean		doit;
    XmTextPosition	currInsert;
    XmTextPosition	newInsert;
    XmTextPosition      startPos;
    XmTextPosition	endPos;
    XmString            text;
} XmCSTextVerifyCallbackStruct, *XmCSTextVerifyPtr;

#ifdef __cplusplus
}
#endif

#endif /* _XM_CSTEXT_H */
