/***************************************************************************
                          circumference.cpp  -  description
                             -------------------
    begin                : Tue Jul 31 2001
    copyright            : (C) 2001 by Marc Bartsch
    email                : marc.bartsch@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "circumference.h"

Circumference::Circumference()
{
	ID = ID_circumference;
  identificator = "Circumference";

	int temp[] = { ID_circle, 1, -1, ID_fixedCircle, 1, -1 };
	convertParams( temp, sizeof( temp ) / sizeof( temp[0] ) );
	pic = QPixmap( UserIcon( "circumference" ) );
	picRect  = QRect( 2, 2, 20, 20 );
}

Circumference::~Circumference()
{
}

void Circumference::move()
{
	if ( textRect.height() == 0 )
	{
		textRect = QRect( 0, 0, 0, 22 );
  	textRect.moveCenter( coords.getQPoint() );
	}

	Coordinates coord1, coord2, coord3, coord4, coord5;

	if ( parents.at( 0 )->identify() == "Circle" )
	{
		coord1 = parents.at( 0 )->parents.at( 0 )->getCoordinates();
		coord2 = parents.at( 0 )->parents.at( 1 )->getCoordinates();

		coord3 = Coordinates( textRect.center() ) - coord1;
		coord3.setLength( coord1.getDistance( coord2 ) );
		coord3 += coord1;

		anchorPoint = coord3.getQPoint();

		MetricsCenter::mapCanvasToGrid( coord1 );
		MetricsCenter::mapCanvasToGrid( coord2 );

		double myValue = coord1.getDistance( coord2 );
		myValue *= 2 * PI;

	  value = QString().setNum( myValue,'f',4 );
	}

	if ( parents.at( 0 )->identify() == "FixedCircle" )
	{
		coord1 = parents.at( 0 )->parents.at( 0 )->getCoordinates();

		anchorPoint = coord1.getQPoint();

		float myValue = parents.at( 0 )->getRealRadius();

	  value = QString().setNum( myValue * 2 * PI,'f',4 );

		coord3 = Coordinates( textRect.center() ) - coord1;
		coord3.setLength( myValue );
		coord3 += coord1;
		anchorPoint = coord3.getQPoint();
	}

	coords = Coordinates( textRect.center() );
}
