#include "parse_logcfg.h"
#include "speed_conversion.h"
#include "tlf.h"
#include "write_tone.h"
#include "speedup.h"
#include "speeddown.h"
#include "set_keyer.h"
#include "curses.h"

extern int keyerport;
extern char tonestr[];
extern int speed, partials;
extern int use_part;
extern int contest;
extern int bigpartlist;

char inputbuffer[160];
FILE *fp;

int read_logcfg(void){

	contest=0;
	speed = 14;
	partials=0;
	use_part=0;
	bigpartlist=0;
	keyerport=0;

 if  ( (fp = fopen("logcfg.dat","r"))  == NULL){
		endwin();
		mvprintw(24,0,  "Error opening logcfg.dat file.\n");
		sleep(2);
		exit(1);
	}

	while(!feof(fp)){
	
		fgets (inputbuffer, 120,  fp);

        	if (inputbuffer[0] != '#') {         /* comments */
			parse_logcfg(inputbuffer);
		}	
	}
	
	fclose(fp);

 	write_tone();

 	
	return(0);
}


int parse_logcfg(char *inputbuffer){

	extern char message[15][80];
	extern char sp_return[];
	extern char cq_return[];
	extern char call[];
	extern char whichcontest[];
	extern char logfile[];
	extern int keyerport;
	extern int recall_mult;
	extern int one_point;
	extern int three_point;
	extern int two_eu_three_dx_points;
	extern int exchange_serial;
	extern int country_mult;
	extern int wysiwyg_multi;
	extern int wysiwyg_once;
	extern int fixedmult;
	extern int portable_x2;
	extern int trx_control;
	extern int rit;
	extern int shortqsonr;
	extern int cluster;
	extern int showscore_flag;
	extern int searchflg;
	extern int announcefilter;
	extern int demode;
	extern int contest;
	extern int speed;
	extern int weight;
	extern int txdelay;
	extern char tonestr[];
	extern int showfreq;
	extern int editor;
	extern int partials;
	extern int use_part;
	extern int bigpartlist;
	
	char commands[MAX_COMMANDS][20]= {
	 	"enable",
	 	"disable",
	 	"F1=",
	 	"F2=",
	 	"F3=",
	 	"F4=",
	 	"F5=",
	 	"F6=",
	 	"F7=",
	 	"F8=",
	 	"F9=",
	 	"F10=",
	 	"F11=",
	 	"F12=",
	 	"S&P_TU_MSG=",
	 	"CW_TU_MSG=",       /* 15 */
	 	"CALL=",
	 	"CONTEST=",
	 	"LOGFILE=",
	 	"LPT1",
	 	"COM1",                 /* 20 */
	 	"RECALL_MULTS",
	 	"ONE_POINT",
	 	"THREE_POINTS",
	 	"WYSIWYG_MULTIBAND",
	 	"WYSIWYG_ONCE",                 /* 25 */
	 	"RADIO_CONTROL",
	 	"RIT_CLEAR",
	 	"SHORT_SERIAL",
	 	"LONG_SERIAL",
	 	"CONTEST_MODE",                    /* 30 */
	    	"CLUSTER",
	    	"BANDMAP",
	    	"SPOTLIST",
	   	 "SCOREWINDOW",
	   	 "CHECKWINDOW",					/* 35 */
	    	"FILTER",
	   	 "SEND_DE",
	   	 "SPEED",
	   	 "TONE",
	  	  "WEIGHT",                           /* 40 */
	  	  "TXDELAY",
	   	 "SUNSPOTS",
	  	"SFI",
	  	  "SHOW_FREQUENCY",
	  	  "EDITOR",							/* 45 */
	  	  "PARTIALS",
	  	  "USEPARTIALS",
	   	 "POWERMULT_5",
	   	 "POWERMULT_2",
	   	 "POWERMULT_1",    							/* 50 */
	   	 "MANY_CALLS",
	   	 "SERIAL_EXCHANGE",
	    	"COUNTRY_MULT",
	    	"2EU3DX_POINTS",
		"PORTABLE_MULT_2", 								/* 55 */
		"",
		"",
		"",
		""
	};

	char teststring[20];
	char buff[16];
	char outputbuff[80];
	int  ii, enable;
	char *i, *j;

	FILE *fp;



	for (ii = 0; ii <= MAX_COMMANDS; ii++) {

		teststring[0] = '\0';
		strcat(teststring, commands[ii]);
		
		i = strstr(inputbuffer, teststring);
		
		if (i != NULL){
		
			switch (ii) {

			case 0 : {
				enable = 1;
				break;
			}
			case 1 : {
				enable = 0;
				break;
			}
			case 2 ... 10 : {                                       /* messages */
				strcpy(message[ii - 2], inputbuffer + 3);
			    break;
			}
			case 11 ... 13 : {
			    strcpy(message[ii - 2], inputbuffer + 4);
			    break;
			}
			case 14  : {
			    strcpy(message[ii - 2], inputbuffer + 11);
			    strcpy(sp_return, message[12]);
			    break;
			}
			case 15  : {
			    strcpy(message[ii - 2], inputbuffer + 10);
			    strcpy(cq_return, message[13]);
			    break;                                              /* end messages */
			}
			 case 16  : {
			    strcpy(call, inputbuffer + 5);
			    break;
			}
			case 17 : {
			    strcpy(whichcontest, inputbuffer + 8);
			    whichcontest[strlen(whichcontest)-1] = '\0';
			    setcontest();
			    break;
			}
			case 18 : {
			    logfile[0] = '\0';
			    strcat(logfile, inputbuffer + 8);
			    logfile[strlen(logfile)-1] = '\0';
			    break;
			}
			case 19 : {
			    keyerport = LPT_KEYER;

			    break;
			}
			case 20 : {
			    keyerport = COM1_KEYER;
			    break;
			}
			case 21 : {
			    recall_mult = 1;
			    break;
			}
			case 22 : {
			    one_point = 1;
			    break;
			}
			case 23 : {
			    three_point = 1;
			    break;
			}
			case 24 : {
			    wysiwyg_multi = 1;
			    break;
			}
			case 25 : {
			    wysiwyg_once = 1;
			    break;
			}
			case 26 : {
			    trx_control = 1;
			    break;
			}
			case 27 : {
			    rit = 1;
			    break;
			}
			case 28 : {
			    shortqsonr = 1;
			    break;
			}
			case 29 : {
			    shortqsonr = 0;
			    break;
			}
			case 30 : {
			    contest = 1;
			    break;
			}
			case 31 : {
			    cluster = 3;
			    break;
			}
			case 32 : {
			    cluster = 1;
			    break;
			}
			case 33 : {
			    cluster = 2;
			    break;
			}
			case 34 : {
			    showscore_flag = 1;
			    break;
			}
			case 35 : {
			    searchflg = 1;
			    break;
			}
			case 36 : {
			    announcefilter = 1;
			    break;
			}
			case 37 : {
			    demode = 1;
			    break;
			}
			case 38 : {
			    buff[0] = '\0';
			    strncat(buff, inputbuffer + 6, 2);
			    speed = speed_conversion(atoi(buff));
			    speed--;
			    speedup();
			    break;
			}
			case 39 : {
			    buff[0] = '\0';
			    strcat(buff, inputbuffer + 5);
			    if ((atoi(buff) > 199) && (atoi(buff) < 1000)){
			    	strcpy(tonestr, buff);
			    	tonestr[3] = '\0';
			    }
			    break;
			}
			case 40 : {
			    buff[0] = '\0';
			    strcat(buff, inputbuffer + 7);
			    weight = atoi(buff);
			    set_weight(weight);
			    break;
			}
			case 41 : {
			    buff[0] = '\0';
			    strcat(buff, inputbuffer + 8);
			    txdelay = atoi(buff);
			    set_txdelay(txdelay);
			    break;
			}
			case 42 : {
			    buff[0] = '\0';
			    strcat(buff, inputbuffer + 9);
			    outputbuff[0] = '\0';
			    sprintf(outputbuff, "WWV R=%d\n", atoi(buff));
			    if  ( (fp = fopen("clfile","a"))  != NULL){
			    	fputs(outputbuff, fp);
			    	fclose(fp);
			    }
			    break;
			}
			case 43 : {
			    buff[0] = '\0';
			    strcat(buff, inputbuffer + 4);
			    outputbuff[0] = '\0';
			    sprintf(outputbuff, "WWV SFI=%d\n", atoi(buff));
			    if  ( (fp = fopen("clfile","a"))  != NULL){
			    	fputs(outputbuff, fp);
			    	fclose(fp);
			    }
			    break;
			}
			case 44 : {
			    showfreq = 1;
			    break;
			}
			case 45 : {
			    buff[0] = '\0';
			    strcat(buff, inputbuffer + 4);

			    j = strstr(inputbuffer, "joe");
				if (j != NULL){
					editor = EDITOR_JOE;
					break;
				}
			    j = strstr(inputbuffer, "vi");
				if (j != NULL){
					editor = EDITOR_VI;
					break;
				} else {
					 editor = EDITOR_E3;
					break;
				}
			}
			case 46 : {
			    	partials = 1;
			    	break;
			}

			case 47 : {
			    	use_part = 1;
			    	break;
			}
			case 48 : {
			    	fixedmult = 5;
			    	break;
			}
			case 49 : {
			    	fixedmult = 2;
			    	break;
			}
			case 50 : {
			    	fixedmult = 1;
			    	break;
			}
			case 51 : {
				bigpartlist=1;
			    	break;
			}
			case 52 : {
				exchange_serial=1;
			    	break;
			}
			case 53 : {
				country_mult=1;
			    	break;
			}
			case 54 : {
				two_eu_three_dx_points=1;
			    	break;
			}
			case 55 : {
				portable_x2=1;
			    	break;
			}

			}

		}



	}



	return(0);
}

int speed_conversion(int cwspeed)
{

	int x;	

    switch (cwspeed) {
    	
    	case 0 ... 6 : {
    		x = 0;
    		break;
    	}
    	case 7 ... 8 : {
    		x = 1;
    		break;
    	}
    	case 9 ... 10 : {
    		x = 2;
    		break;
    	}
    	case 11 ... 12 : {
    		x = 3;
    		break;
    	}
    	case 13 ... 14 : {
    		x = 4;
    		break;
    	}
    	case 15 ... 16 : {
    		x = 5;
    		break;
    	}
    	case 17 ... 18 : {
    		x = 6;
    		break;
    	}
    	case 19 ... 20 : {
    		x = 7;
    		break;
    	}
    	case 21 ... 22 : {
    		x = 8;
    		break;
    	}
    	case 23 ... 24 : {
    		x = 9;
    		break;
    	}
    	case 25 ... 26 : {
    		x = 10;
    		break;
    	}
    	case 27 ... 28 : {
    		x = 11;
    		break;
    	}
    	case 29 ... 30 : {
    		x = 12;
    		break;
    	}
    	case 31 ... 32 : {
    		x = 13;
    		break;
    	}
    	case 33 ... 34 : {
    		x = 14;
    		break;
    	}
    	case 35 ... 36 : {
    		x = 15;
    		break;
    	}
    	case 37 ... 38 : {
    		x = 16;
    		break;
    	}
    	case 39 ... 40 : {
    		x = 17;
    		break;
    	}
    	case 41 ... 45 : {
    		x = 18;
    		break;
    	}
    	case 46 ... 50 : {
    		x = 19;
    		break;
    	}
    	case 51 ... 60 : {
    		x = 20;	
    		break;
    	}
        default :
        	x = 12;
    }


 return(x);
}

