/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>
                2001      by Stanislav Visnovsky <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#ifndef SETTINGS_H
#define SETTINGS_H

#include <qstring.h>
#include <qstringlist.h>
#include <qfont.h>
#include <qcolor.h>
#include <kurl.h>

#include "catalogsettings.h"


/** settings of the CatalogManager */
struct CatManSettings
{
   QString poBaseDir;
   QString potBaseDir;

   bool openWindow;

   QStringList dirCommands;
   QStringList dirCommandNames;
   QStringList fileCommands;
   QStringList fileCommandNames;

   bool killCmdOnExit;
   bool indexWords;
};


/**
* This namespace provides static methods and variables to get the default
* values of configuration values
*/
namespace Defaults
{

   class CatalogManager
   {
    public:
       static QString poBaseDir();
       static QString potBaseDir();
       static const bool openWindow=false;

       static QStringList dirCommands();
       static QStringList dirCommandNames();
       static QStringList fileCommands();
       static QStringList fileCommandNames();

       static const bool killCmdOnExit=true;
       static const bool indexWords=false;

    private:
       static QString _poBaseDir;
       static QString _potBaseDir;
   };
}


#endif // SETTINGS_H
