/* basic_row_i */
/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@xfce.org
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Static functions for basic_local.c */


static gint all_files=0;
static gint 
all_files_count(void)
{
    return all_files;
}

#ifndef HAVE_WORKING_READDIR
#error "HAVE_WORKING_READDIR != 1"
#endif
static
void 
set_type_local(		int branch_type,
			tree_entry_t *en)
{
    int type=0;
    INHERIT_TYPE(type,branch_type);
    if (!en ||!en->path) goto end;
    if (!en->st) {
	goto end;
    }
#if 0
    if (strstr(en->path,"..Wastebasket")){
	gchar *g=get_path_basename(en->path);
	if (strcmp(g,"..Wastebasket")==0)set wastebasket type 
    }
#endif
    if (g_file_test(en->path,G_FILE_TEST_IS_EXECUTABLE)) SET_EXE(type);
    if (g_file_test(en->path,G_FILE_TEST_IS_SYMLINK))	SET_XF_LNK(type);
    if(access(en->path, R_OK) < 0)	SET_NOACCESS(type);
    if (access(en->path,W_OK)!=0) {
	if (g_file_test(en->path,G_FILE_TEST_IS_DIR) ){
	 SET_NOWRITE(type);
	} else { 
	    /* if you can write to the directory you can
	     * write to the file. Let us check... */
	    gchar *g=g_path_get_dirname(en->path);
	    if (access(g,W_OK)!=0) {
		SET_NOWRITE(type);
	    }
	    g_free(g);
	}
    }
	    
    if(S_ISDIR(en->st->st_mode)) {
	SET_DIR(type);
	if (!IS_XF_LNK(type)) SET_XF_DIR(type);
    }
    else if(S_ISSOCK(en->st->st_mode)) SET_XF_SOCK(type);
    else if(S_ISBLK(en->st->st_mode)) SET_XF_BLK(type);
    else if(S_ISCHR(en->st->st_mode)) SET_XF_CHR(type);
    else if(S_ISFIFO(en->st->st_mode)) SET_XF_FIFO(type);
    else SET_XF_REG(type);
    

end:
    en->type = type;
    return;
}

static gint 
read_files_local(		const gchar *path, 
				gint type, 
				const regex_t * preg, 
				xfdir_t * xfdir)
{
    DIR *directory;
    gint count = 0;
    gint smallcount = 0;
    struct dirent *d;
    struct stat st;

    all_files = 0;

    directory = opendir(path);
    if(!directory) return -1;
    while((d = readdir(directory)) != NULL)
    {
	gchar *fullpath=NULL;
	gboolean broken=FALSE;
	if(strcmp(d->d_name, ".")==0 || strcmp(d->d_name, "..")==0)  continue;
	all_files++;
	if(!SHOWS_HIDDEN(type) && strcmp(d->d_name,"..Wastebasket") != 0 && d->d_name[0] == '.') continue;
	if(tree_details->preferences & HIDE_WASTE_B && strcmp(d->d_name, "..Wastebasket") == 0)
	    continue;
	
	if (preg) { /* filtering will be done */
	    fullpath = g_build_filename(path, d->d_name,NULL);
	    if (stat(fullpath, &st)<0) {
		if (lstat(fullpath, &st)<0) {
		    g_free(fullpath);
		    continue;
	       }	   
	       broken=TRUE;
	    }
	    if (!S_ISDIR(st.st_mode) && regexec(preg, d->d_name, 0, NULL, 0)){
	        g_free(fullpath);
	        continue;   
	    }
	}
	if(xfdir != NULL)
	{
	    if (!fullpath) {
	       fullpath = g_build_filename(path, d->d_name,NULL);
	       if (stat(fullpath, &st)<0){
		    if (lstat(fullpath, &st)<0) {
			g_free(fullpath);
			continue;
		    }	   
		    broken=TRUE;
	       }
	    }
	    xfdir->gl[count].pathv = g_strdup(d->d_name);
	    xfdir->gl[count].en = mk_entry(type);
	    xfdir->gl[count].en->path = fullpath;
	    xfdir->gl[count].en->st = (struct stat *)malloc(sizeof(struct stat));
	    memcpy(xfdir->gl[count].en->st, &st, sizeof(struct stat));
	    /* set the local file type specifics: */
	    if (broken) SET_BROKEN_LNK(xfdir->gl[count].en->type);
	    else set_type_local(type,xfdir->gl[count].en);
	} else {
	    g_free(fullpath);
	}
	count++;
	if (++smallcount & 0x100) {
	  smallcount=0;
	  /* this happens too fast to even be seen */
	  /* set_progress(-1,-1); */
	  /* but we need to give gtk some time slots so
	   * the application does not seem to hang 
	   * during long reads : */
	  process_pending_gtk();
	}
    }
    closedir(directory);
    return (count);
}


static 
const gchar *
get_local_cache_path(gchar *directory){
    gchar *xdg_dir;
    gchar *cache_dir;
    GString *gs;
    gchar key[11];
    static gchar *cache_path=NULL;
    
    xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
    cache_dir = g_build_filename(xdg_dir,"xfce4","xffm","cache",NULL);  
    g_free(xdg_dir);
    mkdir(cache_dir, 0770);
    
    if (!g_file_test(cache_dir,G_FILE_TEST_IS_DIR)) {
	g_free(cache_dir);
	return NULL;
    }

    gs = g_string_new(directory);
    sprintf(key, "%10u", g_string_hash(gs));
    g_string_free(gs, TRUE);
    g_free(cache_path);
    cache_path=g_build_filename(cache_dir,key,NULL);
    g_free(cache_dir);
    return (const gchar *)cache_path;
}


static
void
save_xfdir_cache(tree_entry_t *en,xfdir_t *xfdir_p){
    FILE *info;
    const gchar *cache_path;
    int j;
    
    if (!xfdir_p || !en ||!en->path || !strlen(en->path)) return;
    if ((cache_path=get_local_cache_path(en->path))==NULL) return;

    TRACE("writing local cache: %s for %s",cache_path,en->path);
    info=fopen(cache_path,"wb");
    if (!info) return;

    j=en->st->st_mtime + en->st->st_ctime 
	+ en->st->st_dev 
	+ SHOWS_HIDDEN(en->type) 
	+ (tree_details->preferences & HIDE_WASTE_B);
    fwrite(&j,sizeof(int),1,info);
    fwrite(&(xfdir_p->pathc),sizeof(int),1,info);
    
    for(j = 0; j < xfdir_p->pathc; j++) {
	int path_length=0;
	if (!xfdir_p->gl[j].pathv || !xfdir_p->gl[j].en){
	    continue;
	}
	path_length = strlen(xfdir_p->gl[j].en->path);
	fwrite(&path_length,sizeof(int),1,info);
	fwrite(xfdir_p->gl[j].en->path,path_length,1,info);
	
	fwrite(&(xfdir_p->gl[j].en->type),sizeof(int),1,info);
	fwrite(&(xfdir_p->gl[j].en->subtype),sizeof(int),1,info);
	fwrite(xfdir_p->gl[j].en->st,sizeof(struct stat),1,info);
    }

    fclose(info);
    return;
}

#define MAX_CACHE_LINE 255

static
gboolean
read_xfdir_cache(tree_entry_t *en,xfdir_t *xfdir_p){
    FILE *info;
    const gchar *cache_path;
    int j,k;
    char *line=NULL;
    
    if (!xfdir_p || !en || !en->path || !strlen(en->path)) return FALSE;
    if ((cache_path=get_local_cache_path(en->path))==NULL) return FALSE;

    TRACE("reading local cache: %s for %s",cache_path,en->path);
    info=fopen(cache_path,"rb");
    if (!info) {
	DBG("cannot open cache for read: %s for %s\n",cache_path,en->path);
	return FALSE;
    }
    xfdir_p->gl = NULL;
    if (fread(&j,sizeof(int),1,info) != 1) {
short_read:
	TRACE("Short read in %s. Deleting",cache_path);
	g_free(line);
	g_free(xfdir_p->gl);
	fclose(info);
	unlink(cache_path);
	return FALSE;
    }
    k=	en->st->st_mtime + en->st->st_ctime
	+ en->st->st_dev 
	+ SHOWS_HIDDEN(en->type) 
	+ (tree_details->preferences & HIDE_WASTE_B);

    if (j != k){
    /*
	g_message("cache outofdate: %s (%d != %d) \n",
		en->path,j,en->st->st_mtime + en->st->st_ctime);
		*/
	goto short_read;
    } 
    
    if (fread(&(xfdir_p->pathc),sizeof(int),1,info) != 1) goto short_read;
    if (!xfdir_p->pathc) {
	DBG("xfdir_p->pathc == 0\n");
	goto short_read;
    }
    
    xfdir_p->gl = (dir_t *) malloc(xfdir_p->pathc * sizeof(dir_t));
    if (!xfdir_p->gl) {
	DBG("cannot malloc xfdir_p->gl\n");
	goto short_read;
    }
    /* xfdir_p->gl is allocated... */
	    
    line=(gchar *)malloc(MAX_CACHE_LINE+1);  
    for(j = 0; j < xfdir_p->pathc && !feof(info); j++)
    {
	int path_length=0;
	if (fread(&path_length,sizeof(int),1,info)!=1) goto short_read;

	if (path_length > MAX_CACHE_LINE) {
	    g_free(line);
	    line = (gchar *)malloc(path_length+1);
	    if (!line) goto short_read;
	}
	    
	if (fread(line,path_length,1,info)!=1) goto short_read;

	line[path_length]=0;	
	xfdir_p->gl[j].en = mk_entry(en->type);
	if (!xfdir_p->gl[j].en) goto short_read;

	if (fread(&(xfdir_p->gl[j].en->type),sizeof(int),1,info)!=1) goto short_read;
	if (fread(&(xfdir_p->gl[j].en->subtype),sizeof(int),1,info)!=1) goto short_read;
	
	xfdir_p->gl[j].en->path = g_strdup(line);
	xfdir_p->gl[j].pathv = g_path_get_basename(line);
	xfdir_p->gl[j].en->st = (struct stat *)malloc(sizeof(struct stat));
	if (fread(xfdir_p->gl[j].en->st,sizeof(struct stat),1,info)!=1) goto short_read;
    }
    g_free(line);
    fclose(info);
    TRACE("cache read ok");
    return TRUE;
}

G_MODULE_EXPORT
gboolean 
get_xfdir_local(	xfdir_t *xfdir_p,
			tree_entry_t *en,
			gboolean use_filter)
{
    const regex_t *preg=NULL;
    gint j;
    off_t tama = 0;
     

    xfdir_p->gl=NULL;
    
    if(!en){
	g_warning("en != NULL");
	return FALSE;
    }
    
    if (use_filter) {
	g_free(en->filter);
	en->filter = g_strdup(get_filter(tree_details->window));
	if (strcmp(en->filter,"*")!=0) 
	    preg = compile_regex_filter(en->filter,SHOWS_HIDDEN(en->type));
    }
    
    /* cache short circuit (only if not using filter) */
    if (!preg && read_xfdir_cache(en,xfdir_p)){
	/* calculate checksums for the directory (for later use by monitor) 
	 * */
	if (!xfdir_p->pathc) return TRUE;
	for(j = 0; j < xfdir_p->pathc; j++) if (xfdir_p->gl[j].en && xfdir_p->gl[j].en->st)
	{
	    tama += xfdir_p->gl[j].en->st->st_size;	
	    en->checksum += (xfdir_p->gl[j].en->st->st_mtime + xfdir_p->gl[j].en->st->st_ctime);
	}
	set_entry_tag(en, tama);
	return TRUE;
    }
    
    /* read part */
    /* count step */
    xfdir_p->pathc = read_files_local(en->path, en->type, preg, NULL);
    if(xfdir_p->pathc < 0) {
	return FALSE;
    }
    
    if(xfdir_p->pathc)
    {
	xfdir_p->gl = (dir_t *) malloc(xfdir_p->pathc * sizeof(dir_t));
	if(!xfdir_p->gl)
	{
	    return FALSE;
	} else {
	    memset(xfdir_p->gl,0,xfdir_p->pathc * sizeof(dir_t));
	}

	if(read_files_local(en->path, en->type, preg, xfdir_p) < 0)
	{
	    return FALSE;
	}

	/* calculate checksums for the directory (for later use by monitor) 
	 * */
	for(j = 0; j < xfdir_p->pathc; j++) 
	    if (xfdir_p->gl[j].en && xfdir_p->gl[j].en->st)
	{
	    tama += xfdir_p->gl[j].en->st->st_size;	
	    en->checksum += (xfdir_p->gl[j].en->st->st_mtime + xfdir_p->gl[j].en->st->st_ctime);
	}
	set_entry_tag(en, tama);
	if (xfdir_p->pathc > 52) save_xfdir_cache(en,xfdir_p);
	
    }
    return TRUE;
}

static
gboolean 
add_folder_local(	GtkTreeView * treeview, 
			GtkTreeIter * iter,
			tree_entry_t *en)
{
    xfdir_t xfdir;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    time_t inicio = time(NULL);

#ifdef USE_FILTER_BAR
    if (!get_xfdir_local(&xfdir, en,TRUE))
#else
    if (!get_xfdir_local(&xfdir, en,FALSE))
#endif	    	    
    {
	if (xfdir.gl) g_free(xfdir.gl);
	reset_dummy_row(treemodel, iter,NULL,en,"xfce/error_icon",_("Load failed"));
	print_diagnostics("xfce/error_icon", en->path, " :\n", strerror(errno), "\n", NULL);
	return FALSE;
    }
	
    add_contents_row(treemodel, iter, &xfdir);
    xfdirfree(&xfdir);
    if (!IS_ROOT_TYPE(en->type)){
        erase_dummy_row(treemodel,iter,NULL);
    }

    SET_LOADED(en->type);

    /* XXX: is en->tag really necessary? */
    if(tree_details->stop)
    {
	SET_INCOMPLETE(en->type);
	tree_details->stop = FALSE;
 	if (en->tag) g_free(en->tag);	
	en->tag = g_strconcat(FILENAME(en)," : ", strerror(ECANCELLED), NULL);
	print_diagnostics("xfce/warning_icon",strerror(ECANCELLED),":\n", en->tag, "\n",NULL);
	TRACE("DBG: stopped!\n");
    }
    else
    {
	UNSET_INCOMPLETE(en->type);
	hide_stop();
	if (en->tag && strchr(en->tag,'%'))
		print_status_tmp(resolve_icon_small(en), FILENAME(en), NULL);
	else if (en->tag) print_status(resolve_folder_icon(en), en->tag, NULL);
	process_pending_gtk();
    }
    en->load_time = time(NULL) - inicio;

    return TRUE;

}

