/*  Copyright (C) 2001-2003 Edscott Wilson Garcia under GNU GPL
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#ifdef USE_SMB_BRANCH

#include <unistd.h>
#include <stdarg.h>
#include <signal.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/stat.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>



#include "glade_support.h"

#include "constants.h"
#include "types.h"
#include "smb_module.h"

#include "basic_row.h"

#include "smb_download.h"

#include "cpy.h"
#include "uri.h"
#include "entry.h"
#include "remove.h"
#include "monitor.h"
#include "misc.h"
#include "smb_list.h"
#include "smb_misc.h"
#include "smb_open.h"
#include "smblookup.h"
#include "tubo.h"
#include "password_dialog.h"



extern GtkTreeView *smb_treeview;
extern char *smb_errors[];
extern void *smb_object;


static int SMBResult;
static GtkWidget *countW=NULL,*count_label, *count_progress;


static void
SMBFork (void *data)
{
  char *the_command,*the_user,*the_netbios;
  FILE *tmpfile;
  struct stat s;
  gchar *SMBtmpfile=(gchar *)data;

  
  if (stat(SMBtmpfile,&s)<0)  _exit(123); /*forgetit("unable to stat temp file");*/
  if ((the_command = (char *)malloc(s.st_size+1))==NULL) _exit(123); 
  tmpfile=fopen(SMBtmpfile,"rb");
  if (tmpfile) {
   if (fread(the_command,1,s.st_size,tmpfile)<s.st_size) _exit(123);
   fclose(tmpfile);
   unlink(SMBtmpfile);
   the_command[s.st_size]=0;
   the_netbios=strtok(the_command,"\n");
   if (!the_netbios) _exit(123); /* error processing */
   the_user=strtok(NULL,"\n");
   if (!the_user) _exit(123); /* error processing */
   the_command=the_user+strlen(the_user)+1;
   DBG("smbclient %s -U %s\n",the_netbios,the_user);
   DBG("%s\n",the_command); fflush(NULL);sleep(1);
     /*read data from tmpfile */  
   execlp ("smbclient", "smbclient", the_netbios,"-U",the_user, "-c", the_command, (char *) 0);
  _exit(123); /* error processing */
  }
}


static int
SMBStdout (int n, void *data)
{
  char *line;
  int i;
  if (n) return TRUE;		/* this would mean binary data */
  line = (char *) data;
  /* this should be nonverbose until there is a progress dialog for
   * uploading and deleted similar to the download dialog.
   * This new dialog may be entirely unnecessary... */
  print_diagnostics ("nonverbose",line,NULL);
  
  for (i=0;smb_errors[i]!=NULL;i++){
      if (strstr (line, smb_errors[i]))  {
	  print_diagnostics("xfce/error", strerror(EPERM),NULL);
      }	
  }
  return TRUE;
}


static void
SMBForkOver (pid_t pid)
{
   
  if (countW) {
     gtk_widget_destroy(countW);
     countW=NULL;
  }
  
  switch (SMBResult)
  {
  case CHALLENGED:
    /*printf("dbg:%s\n",_("File download failed."));*/
    print_status("xfce/error",_("File download failed."),NULL);
    break;
  default:
    /* upload was successful: */
    /*printf("dbg:%s\n",_("Download done."));*/
    /*xfce/dlg_error(SMBparent,"smbclient",_("Download done."));*/
    break;

  }
  smb_object = NULL;
  cursor_reset ();
  local_monitor(TRUE);
}



#define TIMERVAL 250

static int download_timer;
static int download_count;
static GList *download_list=NULL;

static void cb_count_destroy(GtkWidget *widget,gpointer data){
    GList *tmp;
    for (tmp=download_list; tmp; tmp=tmp->next){
	g_free(tmp->data);
    }
    g_list_free(download_list);
    download_list=NULL;
    countW=NULL;
}

static
gint download_watch(GtkTreeView * treeview){
    gchar *s="-\\|/";
    static int s_pos=0;
    struct stat st;
    long size=0;
    int n=download_count-g_list_length(download_list)+1;
    static gchar *str=NULL;
    static gchar *str_n=NULL;
    gfloat fraction;
    TRACE("at timer");
    if (!download_list) return FALSE;

    if (!g_file_test((gchar *) download_list->data,G_FILE_TEST_IS_DIR) 
	    && stat( (gchar *) download_list->data, &st)==0){
	size=st.st_size;
    }
    g_free(str);
    g_free(str_n);

    if (download_count==0) fraction=1.0; else fraction=(float)n/(float)download_count;
    str_n=g_strdup_printf("%d/%d",n,download_count);
    if (size) str=g_strdup_printf("%s (%ld)",(gchar *) download_list->data,(long)size);
    else {
	str=g_strdup_printf("%s (%c)",(gchar *) download_list->data,s[s_pos++]);
	if (s_pos >= strlen(s)) s_pos=0;
    }
	
    gtk_label_set_text ((GtkLabel *)count_label,(const gchar *)str);
    gtk_progress_bar_set_fraction((GtkProgressBar *) count_progress, fraction);
    gtk_progress_bar_set_text((GtkProgressBar *) count_progress, (const gchar *)str_n);

    TRACE("%s (fraction=%f): %s",str_n,fraction,str);
    /* if next file has appeared, this one is done. 
     * )this will give false readings if the next file happens to be a directory
     * which will be overwritten, this is a not fixable buglet).*/
    if (download_list->next && g_file_test( (gchar *) download_list->next->data, G_FILE_TEST_EXISTS)){
	gconstpointer g = download_list->data;
	download_list=g_list_remove(download_list,g);
    }	
    return TRUE;
}


static void download_window(GtkWidget *parent,char *host){
 	
  countW=gtk_dialog_new ();
  
  gtk_window_set_position (GTK_WINDOW (countW), GTK_WIN_POS_MOUSE);
  gtk_window_set_modal (GTK_WINDOW (countW), TRUE);
  count_label = gtk_label_new ( _("Downloading files from "));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (countW)->vbox), count_label, TRUE, TRUE, 3);
  count_label = gtk_label_new (host);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (countW)->vbox), count_label, TRUE, TRUE, 3);
  count_label = gtk_label_new (".............................................................");
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (countW)->vbox), count_label, TRUE, TRUE, 3);
//  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (countW)->action_area), count_label, TRUE, TRUE, 3);
  count_progress=gtk_progress_bar_new ();
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (countW)->action_area), count_progress, TRUE, TRUE, 3);
  

  gtk_widget_realize (countW);
  if (parent) gtk_window_set_transient_for (GTK_WINDOW (countW), GTK_WINDOW (parent)); 
  g_signal_connect (G_OBJECT (countW), "destroy", GTK_SIGNAL_FUNC (cb_count_destroy), NULL);
  gtk_widget_show_all(countW);
  gdk_flush();
  download_timer = g_timeout_add_full(0, TIMERVAL, 
			(GtkFunction) download_watch, NULL, NULL);
  return ;
}


G_MODULE_EXPORT
void
SMBGetFile (GtkTreeView *treeview, char *target,GList *list)
{
  char *dndS,*host=NULL,*user,*orig_share=NULL,*share,*file,*filename=NULL;
  uri *u;
  gchar *s;
  gchar *fname;
  FILE *tmpfile=NULL;
  char *w;
  int i;
  static gchar *SMBtmpfile=NULL;
  gboolean first=TRUE,isdir;
  gboolean samba_server=FALSE;
    

  smb_treeview=treeview;
  s=g_find_program_in_path("smbclient");
  if (!s){
	  print_status("xfce/error",strerror(ENOENT),":","smbclient",NULL);
	  return;
  }

  if ((fname=randomTmpName(NULL))==NULL) return;
    if ((tmpfile=fopen(fname,"w"))==NULL) {
	print_status("xfce/error",strerror(EPERM),":",(fname)?fname:"?",NULL);
	g_free(fname);
	return;
  }
 download_count=0;
  
 for (;list!=NULL;list=list->next){
  u = list->data;
  if (strchr(u->url,'\n')) u->url=strtok(u->url,"\n");
  if (strchr(u->url,'\r')) u->url=strtok(u->url,"\r");
  dndS=u->url;
  /*fprintf(stderr,"dbg: processing %s\n",dndS);*/
/*
 * 1- parse file into NMBcommand
 * 2- open modal dialog with animation
 * 3- download via tubo. 
 * 4- on forkover, close modal animation dialog
 * 5- process errors
 * */
	
/* * 1- parse file into NMBcommand */
/* format smb://user@host:share/file */

  /*printf("dbg:dnd=%s\n",dndS);*/

  if (strncmp("smb://",dndS,strlen("smb://")!=0)&&
      strncmp("SMB://",dndS,strlen("SMB://")!=0)		  ) {
	incorrect_DND:
	print_status("xfce/error",strerror(EINVAL), NULL);
	return;
  }
  if (strncmp("SMB://",dndS,strlen("SMB://"))==0) samba_server=TRUE;
  user=dndS+strlen("smb://");
  user=strtok(user,"@");  if (!user) goto incorrect_DND;
  host=strtok(NULL,":");  if (!host) goto incorrect_DND;
  share=strtok(NULL,"/"); if (!share) goto incorrect_DND;
  file=share+strlen(share)+1;
 
  w=strrchr(file,'/');
  if (w) {
	  if (w[1]==0) {
	    isdir=TRUE;
	    w[0]=0;
            w=strrchr(file,'/');
	    if (!w) w=file;
	    else w++; 
	  } else {
	    isdir=FALSE;
	    w++;
	  }
	  if (!strlen(w)) continue;
	  else filename=g_strdup(w);	  
  }
  else {
	  isdir=FALSE;
	  filename=g_strdup(file);
  }

  for (i=0;i<strlen(file);i++) if (file[i]=='/') file[i]='\\'; 
/* 2.5- get drop target */  
  
/* 3- download via tubo */ 
  if (first){
    first=FALSE;
    orig_share=g_strdup(share);
    fprintf(tmpfile,"//%s/%s\n",host,share);
    fprintf(tmpfile,"%s\n",user);
  }
  /* only process files from first drop */
  if (orig_share && strcmp(share,orig_share)!=0) {
	  print_diagnostics("xfce/error", _("Only drops from a single share are allowed"), NULL);
	  g_free(orig_share);orig_share=NULL;
	  return;
  }
  {
    gchar *local_file=g_strdup(filename);
    gchar *tgt=g_build_filename(target,local_file,NULL);
    if (!samba_server) ascii_readable(local_file);
   print_diagnostics(NULL,"get ", file," ",local_file,";\n",NULL);
   if (isdir){
      fprintf(tmpfile,
	"lcd \"%s\";cd \"/%s\";cd ..;prompt;recurse; mget \"%s\";recurse;prompt;cd /;",
	target,file,local_file);
    } else {
      struct stat st;
      stat (tgt,&st);
      fprintf(tmpfile,"lcd \"%s\";get \"%s\" \"%s\";",
			    target,file,local_file); 
      /* trash whatever exists so that download monitoring can work. */
      /* I exclude fifo's for double click mechanics. */
#ifdef USE_NPIPE
      if (!S_ISFIFO(st.st_mode))
#endif
      {
	if (getenv("XFFM_DEFAULT_UNLINK") && strcmp(getenv("XFFM_DEFAULT_UNLINK"),"unlink")==0){
	    DBG("unlinking %s",tgt);
	    unlinkit(tgt);
	} else {
	    DBG("trashing %s",tgt);
	    wasteit(tgt);
	}
      }
    }
    download_list = g_list_append(download_list, tgt);
    download_count++;
    g_free(local_file);local_file=NULL;
  }
 } /* end for list elements */
 
  fclose(tmpfile);
  if (SMBtmpfile) g_free(SMBtmpfile);
  SMBtmpfile=fname; 
  if (filename) {
	  g_free(filename);
  }
  filename=NULL;
  /* wait until OK to proceed */
  cursor_wait ();
  smb_wait(FALSE);
  download_window(tree_details->window,host);
  SMBResult=0;
  smb_object = Tubo (SMBFork,
		  (void *)SMBtmpfile,
		  SMBForkOver, 
		  NULL, 
		  SMBStdout, 
		  smb_stderr,0,FALSE);
  if (orig_share) {
	  g_free(orig_share);
	  orig_share=NULL;
  }

  return;
}

/*****************************  upload section  *******************************/

static void
SMBDropForkOver (pid_t pid)
{
  while (gtk_events_pending()) gtk_main_iteration();
  gdk_flush();
  cursor_reset ();
  switch (SMBResult)
  {
  case CHALLENGED:
    print_status ("xfce/error", strerror(EPERM), NULL);
    break;
  default:
    /* upload was successful: */
    print_status ("xfce/info",_("Command done"),NULL);
    break;

  }
  smb_object = NULL;
}

static void forgetit(char *why,char *who){
          fprintf (stderr, "xfsamba: %s %s\n",(why)?why:" ",(who)?who:" ");
	  fflush(NULL);
	  usleep(50000);
          _exit(123);
}

/* function executed after all pipes
*  timeouts and inputs have been set up */
static void
SMBDropFork (void *data)
{
  FILE *file;
  char **argv=(char **)data;
 
  char line[256];
  struct stat s;
  gchar *tmpfile;
  
  tmpfile=g_strdup(argv[5]);
  /*argv[5]=tmpfile;*/

  if (stat(tmpfile,&s)<0)   
	  forgetit("unable to stat temp file",tmpfile);
  if ((argv[5] = (char *)malloc(s.st_size+1))==NULL) 
	  forgetit("unable allocate memory for",tmpfile);
  if ((file=fopen(tmpfile,"r"))==NULL) 
	  forgetit("unable to open",tmpfile);
  strcpy(argv[5],"");
  while (!feof(file) && fgets(line,255,file)){
	  char *w;
	  line[255]=0;
	  if (!strstr(line,"\n")) continue;
	  w=strtok(line,"\n");
          /*fprintf (stderr, "DBG:child->%s\n", w);fflush(NULL);*/
	  strcat(argv[5],w);	  
  }
 
   DBG("%s %s %s %s %s %s\n",argv[0],argv[1],argv[2],argv[3],argv[4],argv[5]); fflush(NULL);sleep(1);
  execvp (argv[0],argv);
}


G_MODULE_EXPORT
void
SMBDropFile (GtkTreeView *treeview,tree_entry_t *t_en, 
		GtkTreeIter *iter,char *tmpfile)
{
  char *argv[12];
  gchar *g;
  
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
  if (!IS_XF_NETSHARE(t_en->subtype) && !IS_NETFILE(t_en->subtype) && !IS_NETDIR(t_en->subtype))
	  return;
  init_smb_list(treeview,t_en->path,SHOWS_HIDDEN(t_en->type));
  
  argv[0]="smbclient";
  
  /*argv[1]=netbios...; */
  if (IS_XF_NETSHARE(t_en->subtype)){
    g=g_strdup(t_en->path); 	  
  } else {
    gchar *p;
    g=g_strdup(t_en->path);
    p=strchr(g+2,'/')+1;
    *strchr(p,'/')=0;
  } 
  argv[1]=g;
  argv[2]="-U";
  argv[3]=t_en->tag; /* user%pass */
  argv[4]="-c";
  argv[5]=tmpfile;
  argv[6]=0;
  
  print_diagnostics ("nonverbose",_("Copying"),"...","\n",NULL);
  print_status (NULL,_("Copying"),"...",NULL);
  
  
  /* wait until OK to proceed */
  cursor_wait ();
  smb_wait(FALSE);
  
  smb_object = Tubo (SMBDropFork, 
		  (void *)argv,
		  SMBDropForkOver, 
		  NULL, 
		  SMBListStdout,
		  smb_stderr,0,FALSE);

  smb_wait(TRUE);
  g_free(g);g=NULL;

  prune_row(treemodel, iter,NULL,t_en);
  /*insert_dummy_row(treemodel, iter,NULL,en,NULL,NULL);*/
  add_smb_stuff(treeview,iter,t_en->tag);
  SET_LOADED(t_en->type);
  UNSET_EXPANDED(t_en->type);
  unlink(tmpfile);
  cursor_reset ();
  return;
}

/************  rm stuff **********************/
static GList *local_remove_list;


static int
SMBrmStdout (int n, void *data)
{
  char *line;
  int i;
  if (n)
    return TRUE;		/* this would mean binary data */
  line = (char *) data;
  /* this should be nonverbose until there is a progress dialog for
   * uploading and deleted similar to the download dialog.
   * This new dialog may be entirely unnecessary... */
  print_diagnostics ("nonverbose",line,NULL);
  for (i=0;smb_errors[i]!=NULL;i++){
      if (strstr (line, smb_errors[i]))  {
	    gchar *f,*g;
	    GList *tmp;
	    if (!strchr(line,'\\')) assert_not_reached();
	    f=g_strdup(strchr(line,'\\')+1);
	    for (g=f;*g;g++) if (*g=='\\') *g='/';
	    for (tmp=local_remove_list;tmp;tmp = tmp->next)
	    {
	      tree_entry_t *en;
	      GtkTreeIter iter;
	      GtkTreeRowReference *reference = (GtkTreeRowReference *) tmp->data;
	      get_entry_from_reference(smb_treeview,reference, &iter, &en);
	      if (strstr(en->path,g)){
	      	 local_remove_list = g_list_remove(local_remove_list, tmp->data);
	    	 gtk_tree_row_reference_free(reference);
	   	 print_diagnostics("xfce/error", strerror(EPERM),": rm ",en->path,NULL);
		 break;
	      }
	    }
      }	
  }

  return TRUE;
}


G_MODULE_EXPORT
GList *
SMBrmFile (GtkTreeView *treeview,char *remote_location,
	       char *remote_pass,char *tmpfile,GList *reference_list)
{
  char *argv[12];
  /* remote_location == remote_server / remote_share */

  smb_treeview=treeview;  
  local_remove_list=reference_list;
  argv[0]="smbclient";
  
  argv[1]=remote_location;
  argv[2]="-U";
  argv[3]=remote_pass; /* user%pass */
  argv[4]="-c";
  argv[5]=tmpfile;
  argv[6]=0;
  
  print_diagnostics ("nonverbose",_("Removing"),"...","\n",NULL);
  print_status ("xfce/warning",_("Removing"),"...",NULL);
  
  
  /* wait until OK to proceed */
  cursor_wait ();
  smb_wait(FALSE);
  
  smb_object = Tubo (SMBDropFork, 
		  (void *)argv,
		  SMBDropForkOver, 
		  NULL, 
		  SMBrmStdout,
		  smb_stderr,0,FALSE);

  smb_wait(TRUE);
  cursor_reset ();

  return local_remove_list;
}


G_MODULE_EXPORT
void
SMBmkdir (GtkTreeView *treeview,tree_entry_t *t_en,
	       GtkTreeIter *iter,gchar *name)
{
  char *argv[12];
  gchar *g=NULL,*target=NULL;
  gchar *command=NULL;

  GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);

  if (!IS_XF_NETSHARE(t_en->subtype) && 
	!IS_NETDIR(t_en->subtype))  return;
  init_smb_list(treeview,t_en->path,SHOWS_HIDDEN(t_en->type));
  
  argv[0]="smbclient";
  
  /*argv[1]=netbios...; */
  if (IS_XF_NETSHARE(t_en->subtype)){
    target=g_strdup("/"); 	    
    g=g_strdup(t_en->path); 	  
  } else {
    char *p;
    g=g_strdup(t_en->path);
    p=strchr(g+2,'/')+1;
    *strchr(p,'/')=0;
     p=strstr(t_en->path+2,"/")+1;
     target=g_strdup(strstr(p,"/"));
   
  } 

  if (!IS_SAMBA_SERVER(t_en->subtype)) ascii_unreadable(name);
  command=g_strconcat("cd /;cd \"",target,"\";mkdir \"",name,"\";ls;\n",NULL);
  g_free(target);
  target=NULL;
  
  argv[1]=g;
  argv[2]="-U";
  argv[3]=t_en->tag; /* user%pass */
  argv[4]="-c";
  argv[5]=command;
  argv[6]=0;
  
   
  print_diagnostics ("nonverbose", "mkdir",t_en->path,"/",name,"\n",NULL);
  print_status ("xfce/warning","mkdir...",NULL);

#ifdef DEBUG  
   print_diagnostics ("nonverbose",
		  argv[0]," ",argv[1]," ",argv[2]," ",argv[3]," ",
		  argv[4]," ",argv[5],"\n",NULL); 
  
#endif
  
  /* wait until OK to proceed */
  cursor_wait ();
  smb_wait(FALSE);
  reset_dummy_row(treemodel,iter,NULL,NULL,"xfce/warning",_("Loading..."));
  
  smb_object = Tubo (fork_function, 
		  (void *)argv,
		  SMBDropForkOver, 
		  NULL, 
		  SMBListStdout,
		  smb_stderr,0,FALSE);

  smb_wait(TRUE);
  g_free(g);g=NULL;
  g_free(command);command=NULL;
  prune_row(treemodel,iter,NULL,t_en);
  /* insert_dummy_row(treemodel,iter,NULL,t_en,NULL,NULL);*/
  add_smb_stuff(treeview,iter,t_en->tag);
  SET_LOADED(t_en->type);
  UNSET_EXPANDED(t_en->type);
  cursor_reset ();
  return;
}

G_MODULE_EXPORT
const gchar *get_netfile_cache_dir(void){
    gchar *xdg_dir;
    static gchar *cache_dir=NULL;
    if (cache_dir) return (const gchar *)cache_dir;

    xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
    cache_dir = g_build_filename(xdg_dir,"xfce4","xffm","smb",NULL);  
    g_free(xdg_dir);
    mkdir(cache_dir, 0770);
    if (!g_file_test(cache_dir,G_FILE_TEST_IS_DIR)) {
	g_free(cache_dir);
	cache_dir=NULL;
	return NULL;
    }
    
    return (const gchar *)cache_dir;
}


G_MODULE_EXPORT
const gchar *SMBget_cache_file(GtkTreeView *treeview, tree_entry_t *en){
	gchar *server,*remote_file;
	static gchar *file=NULL;
	GList *list=NULL;
	DBG("%s is netfile",en->path);
	
	/* download */
	server=g_strdup(en->path+2);
	strtok(server,"/");
	remote_file=server+strlen(server)+1;
	TRACE("%s is netfile",remote_file);
	g_free(file);
	file = g_strdup_printf ("%s://%s@%s:%s\n",
		  IS_SAMBA_SERVER(en->subtype)?"SMB":"smb",
		  (en->tag)?en->tag:"GUEST%%",
		  server,remote_file);
	remote_file=g_path_get_basename(remote_file);
	g_free(server);
	uri_parse_list(file, &list);
	g_free(file);
	file=g_build_filename(get_netfile_cache_dir(),remote_file,NULL);
	g_free(remote_file);
#ifdef USE_NPIPE
#undef USE_NPIPE
#endif
#ifdef USE_NPIPE
	/* using named pipes does not work too well, because read/write
	 * is blocking. Thus the application may block depending on
	 * unpredictable user response...
	 * thus it is avoided for 4.2.x*/
	mkfifo(file,0660);
	SMBGetFile(treeview, (gchar *)get_netfile_cache_dir(), list);
#else
	SMBGetFile(treeview, (gchar *)get_netfile_cache_dir(), list);
	smb_wait(TRUE);
#endif
	DBG("got file... (probably)");
        list = uri_free_list(list);

	return (const gchar *)file;
}


#endif

