.TH scanimage 1 "22 Feb 2004" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX scanimage
.SH NAME
scanimage \- scan an image
.SH SYNOPSIS
.B scanimage
.RB [ \-d | \-\-device-name
.IR dev ]
.RB [ \-\-format
.IR format ]
.RB [ \-i | \-\-icc-profile
.IR profile ]
.RB [ \-L | \-\-list-devices ]
.RB [ \-f | \-\-formatted-device-list 
.IR format ]
.RB [ \-\-batch 
.RI [= format ]]
.RB [ \-\-batch-start
.IR start ]
.RB [ \-\-batch-count
.IR count ]
.RB [ \-\-batch-increment
.IR increment ]
.RB [ \-\-batch-double ]
.RB [ \-\-accept-md5-only ]
.RB [ \-n | \-\-dont-scan ]
.RB [ \-T | \-\-test ]
.RB [ \-h | \-\-help ]
.RB [ \-v | \-\-verbose ]
.RB [ \-V | \-\-version ]
.RI [ device-specific-options ]
.SH DESCRIPTION
.B scanimage
is a command-line interface to control image acquisition devices such
as flatbed scanners or cameras.  The device is controlled via
command-line options.  After command-line processing,
.B scanimage
normally proceeds to acquire an image.  The image data is written to
standard output in one of the PNM (portable aNyMaP) formats (PBM for
black-and-white images, PGM for grayscale images, and PPM for color
images) or in TIFF (black-and-white, grayscale or color).
.B scanimage
accesses image acquisition devices through the
.B SANE
(Scanner Access Now Easy) interface and can thus support any device for which
there exists a
.B SANE
backend (try
.B apropos
.I sane-
to get a list of available backends).

.SH EXAMPLES
To get a list of devices:

  scanimage \-L

To scan with default settings to the file image.pnm:

  scanimage >image.pnm

To print all available options:

  scanimage \-h

.SH OPTIONS
.PP
The
.B \-d
or
.B \-\-device-name
options must be followed by a
.B SANE
device-name like 
.RI ` epson:/dev/sg0 '
or 
.RI ` hp:/dev/usbscanner0 '.
A (partial) list of available devices can be obtained with the
.B \-\-list-devices
option (see below).  If no device-name is specified explicitly,
.B scanimage
reads a device-name from the environment variable
.BR SANE_DEFAULT_DEVICE .
If this variable is not set, 
.B scanimage
will attempt to open the first available device.
.PP
The
.B \-\-format 
.I format
option selects how image data is written to standard output.
.I format
can be
.B pnm
or
.BR tiff.
If
.B \-\-format
is not used, PNM is written.
.PP
The
.B \-i
or
.B \-\-icc-profile
option is used to include an ICC profile into a TIFF file.
.PP
The
.B \-L
or
.B \-\-list-devices
option requests a (partial) list of devices that are available.  The
list is not complete since some devices may be available, but are not
listed in any of the configuration files (which are typically stored
in directory 
.IR @CONFIGDIR@ ).
This is particularly the case when accessing scanners through the network.  If
a device is not listed in a configuration file, the only way to access it is
by its full device name.  You may need to consult your system administrator to
find out the names of such devices.
.PP
The
.B \-f
or
.B \-\-formatted-device-list
option works similar to
.BR \-\-list-devices ,
but requires a format string.
.B scanimage
replaces the placeholders
.B %d %v %m %t %i
with the device name, vendor name, model name, scanner type and an index
number respectively. The command
.PP
.RS
.B scanimage \-f
.I \*(lq scanner number %i device %d is a %t, model %m, produced by %v \*(rq
.PP
.RE
will produce something like:
.PP
.RS
scanner number 0  device sharp:/dev/sg1 is  a  flatbed scanner, model JX250
SCSI, produced by SHARP
.RE
.PP
The
.B \-\-batch*
options provide the features for scanning documents using document
feeders.  
.BR \-\-batch
.RI [ format ]
is used to specify the format of the filename that each page will be written
to.  Each page is written out to a single file.  If
.I format
is not specified, the default of out%d.pnm (or out%d.tif for \-\-format tiff)
will be used.  
.I format
is given as a printf style string with one integer parameter.
.B \-\-batch-start
.I start
selects the page number to start naming files with. If this option is not
given, the counter will start at 0.
.B \-\-batch-count
.I count
specifies the number of pages to attempt to scan.  If not given, 
scanimage will continue scanning until the scanner returns a state
other than OK.  Not all scanners with document feeders signal when the
ADF is empty, use this command to work around them.
With 
.B \-\-batch-increment
.I increment
you can change the amount that the number in the filename is incremented
by.  Generally this is used when you are scanning double-sided documents
on a single-sided document feeder.  A specific command is provided to
aid this:
.B \-\-batch-double
will automatically set the increment to 2.
.B \-\-batch-prompt
will ask for pressing RETURN before scanning a page. This can be used for
scanning multiple pages without an automatic document feeder.
.PP
The
.B \-\-accept-md5-only
option only accepts user authorization requests that support MD5 security. The
.B SANE
network daemon
.RB ( saned )
is capable of doing such requests. See
.BR saned (8).
.PP
The
.B \-n
or
.B \-\-dont-scan
option requests that
.B scanimage
only sets the options provided by the user but doesn't actually perform a
scan. This option can be used to e.g. turn off the scanner's lamp (if
supported by the backend).
.PP
The
.B \-T
or
.B \-\-test
option requests that
.B scanimage
performs a few simple sanity tests to make sure the backend works as
defined by the
.B SANE
API (in particular the
.B sane_read
function is excercised by this test).
.PP
The
.B \-h
or
.B \-\-help
options request help information.  The information is printed on
standard output and in this case, no attempt will be made to acquire
an image.
.PP
The
.B \-v
or
.B \-\-verbose
options increase the verbosity of the operation of
.B scanimage.
The option may be specified repeatedly, each time increasing the verbosity
level.
.PP
The
.B \-V
or
.B \-\-version
option requests that
.B scanimage
prints the program and package name, the version number of
the
.B SANE
distribution that it came with and the version of the backend that it
loads. Usually that's the dll backend. If more information about the version
numbers of the backends are necessary, the
.B DEBUG
variable for the dll backend can be used. Example: SANE_DEBUG_DLL=3 scanimage
\-L.
.PP
As you might imagine, much of the power of
.B scanimage
comes from the fact that it can control any
.B SANE
backend.  Thus, the exact set of command-line options depends on the
capabilities of the selected device.  To see the options for a device named
.IR dev ,
invoke
.B scanimage
via a command-line of the form:
.PP
.RS
.B scanimage \-\-help \-\-device-name
.I dev
.RE
.PP
The documentation for the device-specific options printed by
.B \-\-help
is best explained with a few examples:

 \-\-brightness -100..100% [0]
.br
    Controls the brightness of the acquired image.
.PP
.RS
The description above shows that option
.B \-\-brightness
expects an option value in the range from -100 to 100 percent.  The
value in square brackets indicates that the current option value is 0
percent.
.RE

 \-\-default-enhancements
.br
    Set default values for enhancement controls.
.PP
.RS
The description above shows that option
.B \-\-default-enhancements
has no option value.  It should be thought of as having an immediate
effect at the point of the command-line at which it appears.  For
example, since this option resets the
.B \-\-brightness
option, the option-pair
.B \-\-brightness 50 \-\-default-enhancements
would effectively be a no-op.
.RE

 \-\-mode Lineart|Gray|Color [Gray]
.br
    Selects the scan mode (e.g., lineart or color).
.PP
.RS
The description above shows that option
.B \-\-mode
accepts an argument that must be one of the strings
.BR Lineart ,
.BR Gray ,
or
.BR Color .
The value in the square bracket indicates that the option is currently
set to
.BR Gray .
For convenience, it is legal to abbreviate the string values as long as
they remain unique.  Also, the case of the spelling doesn't matter.  For
example, option setting
.B \-\-mode col
is identical to
.BR "\-\-mode Color" .
.RE

 \-\-custom-gamma[=(yes|no)] [inactive]
.br
    Determines whether a builtin or a custom gamma-table
.br
    should be used.
.PP
.RS
The description above shows that option
.B \-\-custom-gamma
expects either no option value, a "yes" string, or a "no" string.
Specifying the option with no value is equivalent to specifying "yes".
The value in square-brackets indicates that the option is not
currently active.  That is, attempting to set the option would result
in an error message.  The set of available options typically depends
on the settings of other options.  For example, the
.B \-\-custom-gamma
table might be active only when a grayscale or color scan-mode has
been requested.

Note that the
.B \-\-help
option is processed only after all other options have been processed.
This makes it possible to see the option settings for a particular
mode by specifying the appropriate mode-options along
with the
.B \-\-help
option.  For example, the command-line:
.PP
.B  scanimage \-\-help \-\-mode
.I color
.PP
would print the option settings that are in effect when the color-mode
is selected.
.RE

 \-\-gamma-table 0..255,...
.br
    Gamma-correction table.  In color mode this option
.br
    equally affects the red, green, and blue channels
.br
    simultaneously (i.e., it is an intensity gamma table).
.PP
.RS
The description above shows that option
.B \-\-gamma-table
expects zero or more values in the range 0 to 255.  For example, a
legal value for this option would be "3,4,5,6,7,8,9,10,11,12".  Since
it's cumbersome to specify long vectors in this form, the same can be
expressed by the abbreviated form "[0]3-[9]12".  What this means is
that the first vector element is set to 3, the 9-th element is set to
12 and the values inbetween are interpolated linearly.  Of course, it
is possible to specify multiple such linear segments.  For example,
"[0]3-[2]3-[6]7,[7]10-[9]6" is equivalent to "3,3,3,4,5,6,7,10,8,6".
The program
.B gamma4scanimage
can be used to generate such gamma tables (see 
.BR gamma4scanimage (1)
for details).
.RE

.br
 \-\-filename <string> [/tmp/input.ppm]
.br
    The filename of the image to be loaded.
.PP
.RS
The descriptoin above is an example of an option that takes an
arbitrary string value (which happens to be a filename).  Again,
the value in brackets show that the option is current set to the
filename 
.BR /tmp/input.ppm .
.RE

.SH ENVIRONMENT
.TP
.B SANE_DEFAULT_DEVICE
The default device-name.
.SH FILES
.TP
.I @CONFIGDIR@
This directory holds various configuration files.  For details, please
refer to the manual pages listed below.
.TP
.I ~/.sane/pass
This file contains lines of the form
.PP
.RS
user:password:resource
.PP
scanimage uses this information to answer user authorization requests
automatically. The file must have 0600 permissions or stricter. You should
use this file in conjunction with the \-\-accept-md5-only option to avoid
server-side attacks. The resource may contain any character but is limited
to 127 characters.
.SH "SEE ALSO"
.BR sane (7),
.BR gamma4scanimage (1),
.BR xscanimage (1),
.BR xcam(1) ,
.BR xsane(1) ,
.BR scanadf (1),
.BR sane-dll (5),
.BR sane-net (5),
.BR sane-"backendname" (5)
.SH AUTHOR
David Mosberger, Andreas Beck, Gordon Matzigkeit and Caskey Dickson
.SH BUGS
For vector options, the help output currently has no indication as to
how many elements a vector-value should have.
