#!/usr/bin/python
# -*- coding: utf-8 -*-
# auto detect encoding => äöü
"""
   ====================================
   =     restore-local-ntfsimage      =
   ====================================
   
   @copyright:	uib - http://www.uib.de - <info@uib.de>
   @author: Detlef Oertel <d.oertel@uib.de>
   @license: GNU GPL, see COPYING for details.
"""

__version__ = "0.2"

# Constants
LOG_FILE = '/tmp/restore-local-ntfsimage.log'

# Imports
import sys, os, getopt

# OPSI imports
from OPSI.Logger import *
from OPSI.System import *
from OPSI.UI import *

# Get Logger instance
logger = Logger()
logLevel = LOG_WARNING
logger.setConsoleLevel(logLevel)
logger.setLogFile(LOG_FILE)
logger.setFileLevel(LOG_DEBUG)
logger.setLogFormat('%D [%L] %M')
logger.setConsoleFormat('%M')


ui = None
NEW_PARTION_TABLE = False
WRITE_MBR = False
REBOOT = False
DEVICE = None
PARTITION = 1
IMGFILE = ''

def usage():
	print ""
	print "Usage: %s [options] <image-file> [partition]" % os.path.basename(sys.argv[0])
	print "Copies image-file to the partition of the specified harddisk."
	print "If partition not given we use partition 1."
	print "This partition should have type NTFS and have a 'boot' flag"
	print ""
	print "Options:"
	print "    -h    Print this help and exit"
	print "    -v    Verbose (can be used multiple times)"
	print "    -V    Print Version and exit"
	print "    -d    Device to use"
	print "    -b    Write master boot record"
	print "    -r    Reboot machine after writing the image"
	print "    --new_partition_table"
	print "          Create a new parition table containing"
	print "          a NTFS-Parition with bootable flag set"
	print "          100% disk usage"
	print ""

try:	
	# checking the command line
	try:
		(options, arguments) = getopt.getopt(sys.argv[1:],"Vvhbrd:", [ "new_partition_table" ])
	except getopt.GetoptError:
		usage()
		sys.exit(1)
	
	for (opt, arg) in options:
		if opt == "-h" :
			usage()
			sys.exit(0)
		elif opt == "-v" : 
			logLevel += 1
			logger.setConsoleLevel(logLevel)
		elif opt == "-V" :
			print "%s Version %s" % (os.path.basename(sys.argv[0]), __version__)
			sys.exit(0)
		elif opt == "-d" : 
			DEVICE = arg
		elif opt == "-b" : 
			WRITE_MBR = True
		elif opt == "-r" : 
			REBOOT = True
		elif opt == "--new_partition_table":
			NEW_PARTION_TABLE = True
	
	logger.notice("Options: %s" % options)
	logger.notice("Arguments: %s" % arguments)
	
	if (len(arguments) == 0):
		raise Exception("Image-file argument required!")
	
	IMGFILE = arguments[0]
	if (len(arguments) > 1):
		PARTITION = arguments[1]
        if NEW_PARTION_TABLE:
		PARTITION = 1
	
	logger.info("Image-file: %s" % IMGFILE)
	
	# starting work
	logger.notice("Starting.....")
	
	# Get harddisks
	disk = None
	disks = getHarddisks()
	if not disks:
		raise Exception("No harddisks found!")
	
	if DEVICE:
		for d in disks:
			logger.debug("Found disk '%s'" % d.device)
			if (d.device == DEVICE):
				disk = d
		if not disk:
			raise Exception("Harddisk '%s' not found!" % DEVICE)
	else:
		disk = disks[0]
	
	logger.notice("Using disk '%s'" % disk.device)
	
	logger.setConsoleLevel(LOG_NONE)
	ui = UIFactory()
	setUI(ui)
	
	if NEW_PARTION_TABLE:
		# Delete partitiontable
		disk.deletePartitionTable()
		
		# Create ntfs partition
		disk.createPartition("0%", "100%", "ntfs", boot = True)
	
	# Display partition information
	partitions = disk.getPartitions()
	for p in partitions:
		fs = p.get('fs', 'unbekannt')
		type = p.get('type', 'unbekannt')
		ui.getMessageBox().addText( "Partition %s: Start %s MB, Ende %s MB, Dateisystem %s , Typ %s.\n" \
                	% (	p['number'],
                       		p['start']/(1000*1000),
				p['end']/(1000*1000),
				fs,
				type) )
	
	# Restore fs image
	disk.restoreImage(  	partition = int(PARTITION),
				imageFile = IMGFILE )
	
	if WRITE_MBR:
		# Write mbr
		disk.writeMasterBootRecord(system="winxp")
	
	if REBOOT:
		# Reboot
		reboot()
	
	ui.exit()
	logger.setConsoleLevel(logLevel)
	sys.exit(0)

except SystemExit:
	pass
	
except Exception, e:
	if ui:
		ui.showError(str(e))
		ui.exit()
		logger.setConsoleLevel(logLevel)
	print ""
	#logger.logException(e)
	print >> sys.stderr, "ERROR: %s" % e
	print "See logfile '%s' for details." % LOG_FILE
	print ""
	sys.exit(1)

