/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.tree;

import de.uib.utilities.logging.logging;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class XTree
extends JTree {
    public XTree() {
        this.init();
    }

    public XTree(TreeModel treeModel) {
        super(treeModel);
        this.init();
    }

    protected void init() {
        MouseAdapter mouseAdapter = new MouseAdapter(){
            Cursor infoCursor = new Cursor(12);
            Cursor defaultCursor = XTree.this.getCursor();

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                TreePath treePath = XTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath == null || XTree.this.getModel() == null) {
                    XTree.this.setCursor(this.defaultCursor);
                    return;
                }
                if (XTree.this.getModel().isLeaf(treePath.getLastPathComponent())) {
                    XTree.this.setCursor(this.infoCursor);
                    XTree.this.setSelectionPath(treePath);
                } else {
                    XTree.this.setCursor(this.defaultCursor);
                }
            }
        };
        this.addMouseMotionListener(mouseAdapter);
    }

    public Vector<Integer> getToggledRows(TreePath treePath) {
        Vector<Integer> vector = new Vector<Integer>();
        Enumeration<TreePath> enumeration = super.getDescendantToggledPaths(treePath);
        while (enumeration.hasMoreElements()) {
            vector.add(this.getRowForPath(enumeration.nextElement()));
        }
        return vector;
    }

    public void expandRows(Vector<Integer> vector) {
        logging.debug(this, "expandRows " + vector.size());
        for (Integer n : vector) {
            this.expandRow(n);
        }
    }

    public void expandAll() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }
}

