/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.table;

import de.uib.utilities.logging.logging;
import de.uib.utilities.table.TableModelFilterCondition;
import de.uib.utilities.table.provider.TableProvider;
import de.uib.utilities.table.updates.TableUpdateCollection;
import de.uib.utilities.table.updates.TableUpdateItemFactory;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class GenTableModel
extends AbstractTableModel {
    protected int rowsLength;
    protected int colsLength;
    protected Vector<String> columnNames;
    protected Vector<String> classNames;
    protected Vector<Vector> rows;
    protected Vector<Integer> addedRows;
    protected Vector<Integer> updatedRows;
    protected Vector<Integer> finalCols;
    protected boolean[] colEditable;
    protected int keyCol = -1;
    protected TableUpdateCollection updates;
    protected String tableName;
    protected boolean modelDataValid;
    protected TableProvider tableProvider;
    protected TableUpdateItemFactory itemFactory;
    protected int saveUpdatesSize;
    protected TableModelFilterCondition filterCondition;
    protected TreeSet<Object> filter = null;
    protected boolean invertedFilter = false;
    protected boolean usingFilter = false;

    public GenTableModel(TableUpdateItemFactory tableUpdateItemFactory, TableProvider tableProvider, int n, int[] nArray, TableModelListener tableModelListener, TableUpdateCollection tableUpdateCollection) {
        this.keyCol = n;
        this.updates = tableUpdateCollection;
        this.tableProvider = tableProvider;
        this.itemFactory = tableUpdateItemFactory;
        this.columnNames = tableProvider.getColumnNames();
        this.classNames = tableProvider.getClassNames();
        this.rows = tableProvider.getRows();
        this.addedRows = new Vector();
        this.updatedRows = new Vector();
        this.finalCols = new Vector();
        if (nArray == null) {
            if (n > -1) {
                this.finalCols.add(n);
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                this.finalCols.add(nArray[i]);
            }
        }
        this.modelDataValid = false;
        this.colsLength = this.columnNames.size();
        this.colEditable = new boolean[this.colsLength];
        this.rowsLength = this.rows.size();
        if (tableModelListener != null) {
            this.addTableModelListener(tableModelListener);
        }
        this.createDefaultFilterCondition();
    }

    public GenTableModel(TableUpdateItemFactory tableUpdateItemFactory, TableProvider tableProvider, int n, TableModelListener tableModelListener, TableUpdateCollection tableUpdateCollection) {
        this(tableUpdateItemFactory, tableProvider, n, null, tableModelListener, tableUpdateCollection);
    }

    public int getKeyCol() {
        return this.keyCol;
    }

    public Vector<Integer> getFinalCols() {
        return this.finalCols;
    }

    public void invalidate() {
        this.tableProvider.requestReturnToOriginal();
        this.modelDataValid = false;
    }

    public void requestReload() {
        this.tableProvider.requestReloadRows();
        this.invalidate();
    }

    public void startWithCurrentData() {
        this.tableProvider.setWorkingCopyAsNewOriginalRows();
        this.invalidate();
    }

    public void removeUpdates() {
        int n = this.updates.size();
        for (int i = n - 1; i >= this.saveUpdatesSize; --i) {
            this.updates.remove(i);
        }
        this.updatedRows.clear();
        this.invalidate();
    }

    private void createDefaultFilterCondition() {
        this.filterCondition = new TableModelFilterCondition(){

            @Override
            public void setFilter(TreeSet<Object> treeSet) {
                GenTableModel.this.filter = treeSet;
            }

            @Override
            public boolean test(Vector vector) {
                if (GenTableModel.this.filter == null) {
                    return true;
                }
                if (GenTableModel.this.keyCol == -1) {
                    return true;
                }
                return GenTableModel.this.filter.contains(vector.get(GenTableModel.this.keyCol));
            }
        };
    }

    public void setFilterCondition(TableModelFilterCondition tableModelFilterCondition) {
        this.filterCondition = tableModelFilterCondition;
    }

    protected void produceRows() {
        this.rows = this.tableProvider.getRows();
        if (!this.usingFilter) {
            return;
        }
        Iterator<Vector> iterator = this.rows.iterator();
        Vector<Vector> vector = new Vector<Vector>();
        while (iterator.hasNext()) {
            Vector vector2 = iterator.next();
            if (this.invertedFilter) {
                if (this.filterCondition.test(vector2)) continue;
                vector.add(vector2);
                continue;
            }
            if (!this.filterCondition.test(vector2)) continue;
            vector.add(vector2);
        }
        this.rows = vector;
    }

    protected void refresh() {
        logging.info(this, "reset() modelDataValid : " + this.modelDataValid);
        this.produceRows();
        this.rowsLength = this.rows.size();
        this.fireTableDataChanged();
        this.modelDataValid = true;
    }

    public void setInvertedFilter(Set set) {
        this.setFilter(set);
        this.invertedFilter = true;
        this.refresh();
    }

    public void setFilter(Set set) {
        this.invertedFilter = false;
        this.invalidate();
        if (set == null) {
            this.filter = null;
        } else {
            this.filter = new TreeSet(set);
            this.usingFilter = true;
        }
        this.filterCondition.setFilter(this.filter);
        this.refresh();
    }

    public boolean isUsingFilter() {
        return this.usingFilter;
    }

    public void toggleFilter() {
        this.setUsingFilter(!this.usingFilter);
    }

    public void setUsingFilter(boolean bl) {
        if (this.usingFilter != bl) {
            this.usingFilter = bl;
            this.invalidate();
            this.refresh();
        }
    }

    public void reset() {
        this.refresh();
        this.addedRows.clear();
        this.updatedRows.clear();
        this.saveUpdatesSize = this.updates.size();
    }

    public void setEditableColumns(int[] nArray) {
        int n;
        for (n = 0; n < this.colsLength; ++n) {
            this.colEditable[n] = false;
        }
        if (nArray == null) {
            return;
        }
        for (n = 0; n < nArray.length; ++n) {
            this.colEditable[nArray[n]] = true;
        }
    }

    public Vector<String> getColumnNames() {
        this.columnNames = this.tableProvider.getColumnNames();
        this.colsLength = this.columnNames.size();
        return this.columnNames;
    }

    public Vector<String> getClassNames() {
        this.classNames = this.tableProvider.getClassNames();
        return this.classNames;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames.get(n);
    }

    @Override
    public int getColumnCount() {
        return this.colsLength;
    }

    @Override
    public int getRowCount() {
        return this.rowsLength;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.rows.get(n).get(n2);
    }

    public Vector<Object> getColumn(int n) {
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < this.rowsLength; ++i) {
            vector.add(this.getValueAt(i, n));
        }
        return vector;
    }

    public Vector<String> getOrderedColumn(int n) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < this.rowsLength; ++i) {
            treeSet.add((String)this.getValueAt(i, n));
        }
        Vector<String> vector = new Vector<String>(treeSet);
        return vector;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.addedRows.indexOf(n) == -1 && this.finalCols.indexOf(n2) > -1) {
            return false;
        }
        return this.colEditable[n2];
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        String string = "" + this.rows.get(n).get(n2);
        if (!string.equals("" + object)) {
            if (this.addedRows.indexOf(n) == -1 && this.updatedRows.indexOf(n) == -1) {
                Vector vector = (Vector)this.rows.get(n).clone();
                System.out.println(" old values in GenTableModel " + vector);
                this.rows.get(n).setElementAt(object, n2);
                System.out.println(" new values in GenTableModel " + this.rows.get(n));
                this.updates.add(this.itemFactory.produceUpdateItem(vector, this.rows.get(n)));
                this.updatedRows.add(n);
            }
            if (this.addedRows.indexOf(n) == -1 && this.finalCols.indexOf(n2) > -1) {
                logging.debugOut(2, "key column cannot be edited after saving the data");
                JOptionPane.showMessageDialog(null, "values in this column are fixed after saving the data", "Information", 0);
                return;
            }
            this.rows.get(n).setElementAt(object, n2);
            this.fireTableCellUpdated(n, n2);
        }
    }

    public void addRow(Object[] objectArray) {
        int n;
        Vector<Object> vector = new Vector<Object>();
        for (n = 0; n < this.colsLength; ++n) {
            vector.add(null);
        }
        for (n = 0; n < objectArray.length; ++n) {
            vector.set(n, objectArray[n]);
        }
        this.rows.add(vector);
        this.addedRows.add(this.rowsLength);
        this.updates.add(this.itemFactory.produceInsertItem(vector));
        this.requestReload();
        ++this.rowsLength;
        this.fireTableRowsInserted(this.rowsLength - 1, this.rowsLength - 1);
    }

    public void deleteRow(int n) {
        if (this.rows.get(n) == null) {
            return;
        }
        this.updates.add(this.itemFactory.produceDeleteItem(this.rows.get(n)));
        this.rows.remove(n);
        if (this.addedRows.indexOf(n) > -1) {
            this.addedRows.remove(this.addedRows.indexOf(n));
        }
        if (this.updatedRows.indexOf(n) > -1) {
            this.updatedRows.remove(this.updatedRows.indexOf(n));
        }
        --this.rowsLength;
        this.fireTableRowsDeleted(n, n);
    }
}

