/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.swing.timeedit;

import de.uib.utilities.logging.logging;
import de.uib.utilities.swing.FEdit;
import de.uib.utilities.swing.timeedit.DateTimeEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.jdesktop.swingx.event.DateSelectionEvent;
import org.jdesktop.swingx.event.DateSelectionListener;

public class FEditDate
extends FEdit
implements DateSelectionListener,
MouseListener,
KeyListener {
    public static final Dimension AREA_DIMENSION = new Dimension(210, 198);
    private DateTimeEditor dateEditor;
    protected DateFormat dateFormat;

    public FEditDate(String string, boolean bl) {
        super(string);
        this.areaDimension = AREA_DIMENSION;
        this.dateFormat = DateFormat.getDateInstance(1);
        this.dateEditor = new DateTimeEditor(bl);
        this.editingArea.add((Component)this.dateEditor, "Center");
        this.dateEditor.setEditable(true);
        this.dateEditor.addDateSelectionListener(this);
        this.dateEditor.addKeyListener(this);
        this.dateEditor.addMonthViewMouseListener(this);
        this.setStartText(this.initialText);
    }

    @Override
    protected void createComponents() {
        super.createComponents();
    }

    @Override
    public void setStartText(String string) {
        super.setStartText(string);
        this.setDataChanged(false);
        if (string == null || string.equals("")) {
            this.dateEditor.setDate(false);
        } else {
            String string2 = null;
            Date date = null;
            try {
                date = this.dateFormat.parse(string);
                this.dateEditor.setSelectionDate(date);
                this.setDataChanged(false);
            }
            catch (ParseException parseException) {
                try {
                    string2 = string;
                    if (string2.indexOf(32) == -1) {
                        string2 = string2 + " 00:00:00";
                    }
                    date = Timestamp.valueOf(string2);
                    this.dateEditor.setSelectionDate(date);
                    this.setDataChanged(false);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    logging.warning("not valid date: " + string2);
                    this.dateEditor.setDate();
                    this.setDataChanged(true);
                }
            }
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.dateEditor.requestFocus();
        }
        super.setVisible(bl);
    }

    private String getSelectedDate() {
        if (this.dateEditor.getSelectedSqlTime() == null) {
            return "";
        }
        String string = this.dateEditor.getSelectedSqlTime().toString();
        return string.substring(0, string.indexOf(32));
    }

    private String getSelectedDateTime() {
        logging.debug(this, " getSelectedDateTime() : " + this.dateEditor.getSelectedSqlTime());
        if (this.dateEditor.getSelectedSqlTime() == null) {
            return "";
        }
        return this.dateEditor.getSelectedSqlTime().toString();
    }

    protected String getSelectedDateString() {
        return this.getSelectedDateTime();
    }

    @Override
    public String getText() {
        this.initialText = this.getSelectedDateString();
        return this.initialText;
    }

    @Override
    public void valueChanged(DateSelectionEvent dateSelectionEvent) {
        this.setDataChanged(true);
        this.updateCaller(this.getSelectedDateString());
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        System.out.println(" key event " + keyEvent);
        super.keyPressed(keyEvent);
        if (keyEvent.getKeyCode() == 27) {
            this.cancel();
        } else if (keyEvent.getKeyCode() == 10) {
            this.commit();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        super.keyTyped(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        super.keyReleased(keyEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() >= 2) {
            this.commit();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

