/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.swing;

import de.uib.configed.configed;
import de.uib.configed.gui.IconButton;
import de.uib.utilities.Globals;
import de.uib.utilities.logging.logging;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

public class FEdit
extends JDialog
implements ActionListener,
KeyListener {
    protected Dimension areaDimension = new Dimension(100, 40);
    protected String initialText = "";
    protected String hint = null;
    protected JPanel framingPanel;
    protected JPanel editingArea;
    protected JLabel labelHint;
    protected IconButton buttonCommit;
    protected IconButton buttonCancel;
    protected boolean dataChanged = false;
    protected boolean cancelled = false;
    protected boolean starting = true;
    protected JTextComponent caller;
    protected Font callerFont;

    public FEdit(String string) {
        this(string, null);
    }

    public FEdit(String string, String string2) {
        this.setIconImage(Globals.mainIcon);
        if (string != null) {
            this.initialText = string;
        }
        this.hint = string2;
        this.createComponents();
    }

    public void setHint(String string) {
        this.labelHint.setVisible(string != null);
        this.labelHint.setText(string);
    }

    protected void createComponents() {
        this.framingPanel = new JPanel();
        this.editingArea = new JPanel(new BorderLayout());
        this.labelHint = new JLabel();
        this.labelHint.setFont(Globals.defaultFontStandardBold);
        this.buttonCommit = new IconButton(configed.getResourceValue("PanelGenEditTable.SaveButtonTooltip"), "images/apply.png", "images/apply_over.png", "images/apply_disabled.png", true);
        this.buttonCommit.setPreferredSize(new Dimension(40, 24));
        this.buttonCancel = new IconButton(configed.getResourceValue("PanelGenEditTable.CancelButtonTooltip"), "images/cancel.png", "images/cancel_over.png", "images/cancel_disabled.png", true);
        this.buttonCancel.setPreferredSize(new Dimension(40, 24));
    }

    protected void initComponents() {
        this.framingPanel.setBackground(Globals.backgroundWhite);
        this.setDefaultCloseOperation(1);
        this.setHint(this.hint);
        this.buttonCommit.addActionListener(this);
        this.buttonCancel.addActionListener(this);
        this.buttonCommit.addKeyListener(this);
        this.buttonCancel.addKeyListener(this);
        GroupLayout groupLayout = new GroupLayout(this.framingPanel);
        this.framingPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelHint, -2, -2, Short.MAX_VALUE).addComponent(this.editingArea, -2, -2, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.buttonCommit, -2, -2, -2).addComponent(this.buttonCancel, -2, -2, -2))).addGap(5, 5, 5)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(5, 10, 10).addComponent(this.labelHint, -2, -2, -2).addGap(5, 5, 5).addComponent(this.editingArea, -2, -2, Short.MAX_VALUE).addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCommit, -2, -2, -2).addComponent(this.buttonCancel, -2, -2, -2)).addGap(5, 5, 5)));
        GroupLayout groupLayout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.framingPanel, -2, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.framingPanel, -2, -2, Short.MAX_VALUE).addContainerGap(20, 20)));
        this.pack();
    }

    protected void setDataChanged(boolean bl) {
        logging.debug(this, " FEdit setDataChanged " + bl);
        this.dataChanged = bl;
        this.buttonCommit.setEnabled(bl);
    }

    public void setAreaDimension(Dimension dimension) {
        this.areaDimension = dimension;
    }

    public void addToArea(JComponent jComponent) {
        this.editingArea.add(jComponent);
    }

    public void setCaller(JTextComponent jTextComponent) {
        this.caller = jTextComponent;
    }

    public void updateCaller(String string) {
        if (this.caller != null) {
            this.caller.setText(string);
        }
    }

    public void setStartText(String string) {
        this.initialText = string;
        this.setDataChanged(false);
        this.cancelled = false;
    }

    public String getText() {
        return this.initialText;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.starting && bl) {
            this.starting = false;
            this.setDataChanged(false);
        }
        super.setVisible(bl);
    }

    public boolean init(Dimension dimension) {
        if (this.editingArea.getComponentCount() != 1) {
            logging.debugOut(1, " editing area not filled with component");
            return false;
        }
        this.editingArea.getComponent(0).setPreferredSize(dimension);
        this.initComponents();
        return true;
    }

    public boolean init() {
        return this.init(this.areaDimension);
    }

    private int intHalf(double d) {
        return (int)(d / 2.0);
    }

    public void associateTo(Point point, int n, int n2) {
        int n3 = (int)point.getX() + n;
        int n4 = (int)point.getY() + n2;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (n3 + this.getSize().width > dimension.width) {
            n3 = dimension.width - this.getSize().width;
        }
        if (n4 + this.getSize().height > dimension.height) {
            n4 = dimension.height - this.getSize().height;
        }
        this.setLocation(n3, n4);
    }

    public void centerOn(Component component) {
        boolean bl;
        int n = 0;
        int n2 = 0;
        Point point = null;
        boolean bl2 = bl = component != null;
        if (bl) {
            try {
                point = component.getLocationOnScreen();
            }
            catch (Exception exception) {
                logging.debug(this, "centerOn " + component + " ex: " + exception);
                bl = false;
            }
        }
        if (!bl) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            n = (dimension.width - this.getSize().width) / 2;
            n2 = (dimension.height - this.getSize().height) / 2;
        } else {
            n = (int)point.getX() + this.intHalf(component.getWidth()) - this.intHalf(this.getSize().getWidth());
            n2 = (int)point.getY() + this.intHalf(component.getHeight()) - this.intHalf(this.getSize().getHeight());
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            if (n + this.getSize().width > dimension.width) {
                n = dimension.width - this.getSize().width;
            }
            if (n2 + this.getSize().height > dimension.height) {
                n2 = dimension.height - this.getSize().height;
            }
        }
        this.setLocation(n, n2);
    }

    protected void enter() {
        if (this.caller != null) {
            this.callerFont = this.caller.getFont();
            this.caller.setFont(this.callerFont.deriveFont(2));
        }
    }

    public void deactivate() {
        if (this.caller != null) {
            System.out.println(" reset font ");
            this.caller.setFont(this.callerFont);
            this.caller.validate();
        }
    }

    protected void leave() {
        this.updateCaller(this.initialText);
        this.setVisible(false);
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.cancel();
        } else if (windowEvent.getID() == 205) {
            this.enter();
        } else if (windowEvent.getID() == 206) {
            // empty if block
        }
        super.processWindowEvent(windowEvent);
    }

    protected void commit() {
        this.setStartText(this.getText());
        this.leave();
    }

    protected void cancel() {
        this.setStartText(this.initialText);
        this.cancelled = true;
        this.leave();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.buttonCommit) {
            this.commit();
        } else if (actionEvent.getSource() == this.buttonCancel) {
            this.cancel();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        logging.debug(this, " key event " + keyEvent);
        if (keyEvent.getSource() == this.buttonCommit) {
            this.commit();
        } else if (keyEvent.getKeyCode() == 27) {
            this.cancel();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }
}

