/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.swing;

import de.uib.configed.Globals;
import de.uib.utilities.swing.ImagePlusTextLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class CellRendererByIndex
extends ImagePlusTextLabel
implements ListCellRenderer {
    private Font uhOhFont;
    protected Map<String, String> mapOfStrings;
    protected Map<String, String> mapOfTooltips;
    protected Map<String, ImageIcon> mapOfImages;
    static final int imageDefaultWidth = 30;

    public CellRendererByIndex(Map<String, String> map, String string) {
        this(map, string, 30);
    }

    public CellRendererByIndex(Set<String> set, String string, int n) {
        super(n);
        this.setOpaque(true);
        this.mapOfImages = new HashMap<String, ImageIcon>();
        this.mapOfStrings = new HashMap<String, String>();
        if (string == null) {
            super.setIconVisible(false);
        } else {
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2;
                String string3;
                String string4 = string3 = iterator.next();
                this.mapOfStrings.put(string3, string3);
                ImageIcon imageIcon = null;
                if (string == null || (imageIcon = Globals.createImageIcon(string2 = string + "/" + string4 + ".png", string4)) == null) continue;
                this.mapOfImages.put(string3, imageIcon);
            }
        }
        this.mapOfTooltips = this.mapOfStrings;
    }

    public CellRendererByIndex(Map<String, String> map, String string, int n) {
        this(map, map, string, n);
    }

    public CellRendererByIndex(Map<String, String> map, Map<String, String> map2) {
        this(map, map2, null, 0);
    }

    public CellRendererByIndex(Map<String, String> map, Map<String, String> map2, String string, int n) {
        super(n);
        this.setOpaque(true);
        this.mapOfStrings = map;
        this.mapOfTooltips = map2;
        this.mapOfImages = new HashMap<String, ImageIcon>();
        if (string == null) {
            super.setIconVisible(false);
        } else {
            for (Map.Entry<String, String> entry : this.mapOfStrings.entrySet()) {
                String string2;
                String string3 = entry.getKey();
                String string4 = entry.getValue();
                ImageIcon imageIcon = null;
                if (string3 == null || string4 == null || (imageIcon = Globals.createImageIcon(string2 = string + "/" + string4 + ".png", string4)) == null) continue;
                this.mapOfImages.put(string3, imageIcon);
            }
        }
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        Color color;
        Color color2;
        if (bl) {
            color2 = Globals.nimbusSelectionBackground;
            color = Color.WHITE;
        } else {
            color2 = Globals.nimbusBackground;
            color = Globals.nimbusSelectionBackground;
        }
        this.setBackground(color2);
        this.setForeground(color);
        String string = "";
        ImageIcon imageIcon = null;
        String string2 = "";
        if (this.uhOhFont == null) {
            this.uhOhFont = jList.getFont().deriveFont(10.0f);
        }
        this.setFont(this.uhOhFont);
        if (object != null) {
            if (this.mapOfStrings != null) {
                string = this.mapOfStrings.get(object);
            }
            if (this.mapOfImages != null) {
                imageIcon = this.mapOfImages.get(object);
            }
            if (this.mapOfTooltips != null) {
                string2 = this.mapOfTooltips.get(object);
            }
        }
        if (string == null) {
            string = "" + object;
        }
        this.setIcon(imageIcon);
        this.setText(string);
        this.setToolTipText(string2);
        this.setFont(Globals.defaultFont);
        return this;
    }
}

