/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.swing;

import de.uib.utilities.Globals;
import de.uib.utilities.logging.logging;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public class ActivityPanel
extends JPanel
implements Runnable {
    Color[] colors;
    Thread colorSwitching;
    public static int w = 30;
    public static int h = 10;
    private final int noOfParts = 4;
    ArrayList<JPanel> partPanels = new ArrayList();
    public static int sleepingMS = 750;
    public static int inactive = -1;
    public static LineBorder lineBorderActive;
    public static LineBorder lineBorderInactive;
    private static boolean acting;

    public ActivityPanel() {
        this.initGui();
    }

    private void setState(int n) {
        for (int i = 0; i < this.partPanels.size(); ++i) {
            this.setBorder(lineBorderActive);
            this.partPanels.get(i).setBackground(this.colors[0]);
            if (n == inactive) {
                this.setBorder(lineBorderInactive);
                this.partPanels.get(i).setBackground(Globals.backLightBlue);
            } else {
                this.setBorder(lineBorderActive);
                this.partPanels.get(i).setBackground(Globals.backNimbus);
            }
            if (i != n) continue;
            this.partPanels.get(i).setBackground(this.colors[1]);
        }
        try {
            this.paintImmediately(0, 0, w, h);
        }
        catch (Exception exception) {
            logging.warning(this, "strange exception " + exception);
            this.setState(inactive);
        }
    }

    public static void setActing(boolean bl) {
        acting = bl;
    }

    @Override
    public void run() {
        int n = 0;
        boolean bl = false;
        boolean bl2 = true;
        while (true) {
            try {
                Thread.sleep(sleepingMS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (acting) {
                bl = true;
                if (n == 3) {
                    bl2 = false;
                } else if (n == 0) {
                    bl2 = true;
                }
                this.setState(n);
                if (bl2) {
                    ++n;
                    continue;
                }
                --n;
                continue;
            }
            if (!bl) continue;
            bl = false;
            bl2 = true;
            n = inactive;
            this.setState(n);
            n = 0;
            try {
                Thread.sleep(2 * sleepingMS);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    protected void initGui() {
        lineBorderInactive = new LineBorder(Globals.backLightBlue, 1, true);
        lineBorderActive = new LineBorder(Globals.blueGrey, 1, true);
        logging.debug(this, "starting");
        this.setOpaque(true);
        this.setBorder(lineBorderInactive);
        this.colors = new Color[2];
        this.colors[1] = Globals.opsiLogoBlue;
        this.colors[0] = Globals.opsiLogoLightBlue;
        this.setPreferredSize(new Dimension(w, h));
        this.partPanels = new ArrayList();
        for (int i = 0; i < 4; ++i) {
            this.partPanels.add(new JPanel(){

                @Override
                public void paint(Graphics graphics) {
                    try {
                        super.paint(graphics);
                    }
                    catch (ClassCastException classCastException) {
                        logging.info(this, "the ugly well known exception " + classCastException);
                    }
                }
            });
            this.partPanels.get(i).setOpaque(true);
        }
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        GroupLayout.SequentialGroup sequentialGroup = groupLayout.createSequentialGroup();
        for (int i = 0; i < 4; ++i) {
            sequentialGroup.addComponent(this.partPanels.get(i), w / 4, w / 4, w / 4);
        }
        groupLayout.setHorizontalGroup(sequentialGroup);
        GroupLayout.ParallelGroup parallelGroup = groupLayout.createParallelGroup();
        for (int i = 0; i < 4; ++i) {
            parallelGroup.addComponent(this.partPanels.get(i), h - 2, h - 2, h - 2);
        }
        groupLayout.setVerticalGroup(parallelGroup);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setSize(new Dimension(100, 40));
        ActivityPanel activityPanel = new ActivityPanel();
        jFrame.getContentPane().add(activityPanel);
        jFrame.setVisible(true);
        activityPanel.run();
    }

    static {
        acting = false;
    }
}

