/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.logging;

import de.uib.utilities.WaitCursor;
import de.uib.utilities.logging.logging;

public class UncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static String lastException = "";

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        WaitCursor.stopAll();
        Integer n = logging.getInjectedLogLevel();
        if (n != null) {
            logging.injectLogLevel(3);
        }
        if (throwable instanceof Exception) {
            logging.warning("Error in thread " + thread);
            logging.logTrace((Exception)throwable);
            logging.error("Not foreseen error: " + ((Exception)throwable).getMessage() + "\nplease check logfile");
        } else {
            logging.warning("Thread " + thread + " (RunTime Error)  " + throwable);
            if (throwable instanceof OutOfMemoryError && !lastException.equals(throwable.toString())) {
                lastException = throwable.toString();
                logging.error("Error: out of memory");
            }
        }
        if (n != null) {
            logging.injectLogLevel(n);
        }
    }
}

