/*
 * Decompiled with CFR 0.152.
 */
package de.uib.opsidatamodel.datachanges;

import de.uib.opsidatamodel.datachanges.CountedCollection;
import de.uib.opsidatamodel.datachanges.UpdateCommand;
import de.uib.utilities.logging.logging;
import java.util.Collection;
import java.util.Iterator;

public class UpdateCollection
implements UpdateCommand,
CountedCollection {
    protected Collection<Object> implementor;

    public UpdateCollection(Collection<Object> collection) {
        this.implementor = collection;
    }

    public boolean addAll(Collection collection) {
        boolean bl = true;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && bl) {
            Object e = iterator.next();
            logging.debug(this, "addAll, element of Collection: " + e);
            if (this.add(e)) continue;
            bl = false;
        }
        return bl;
    }

    @Override
    public void clear() {
        logging.debug(this, "clear()");
        for (Object object : this.implementor) {
            if (object == null || !(object instanceof Collection)) continue;
            try {
                logging.debug(this, "by recursion, we will clear " + object);
                ((Collection)object).clear();
            }
            catch (Exception exception) {}
        }
        logging.debug(this, "to clear elements of implementor " + this.implementor);
        this.implementor.clear();
        logging.debug(this, "cleared: elements of implementor " + this.implementor.size());
    }

    public void clearElements() {
        for (Object object : this.implementor) {
            if (object == null || !(object instanceof UpdateCollection)) continue;
            try {
                ((UpdateCollection)object).clearElements();
            }
            catch (Exception exception) {}
        }
    }

    public void revert() {
        logging.info(this, "revert()");
        for (Object object : this.implementor) {
            if (object == null || !(object instanceof UpdateCollection)) continue;
            try {
                ((UpdateCollection)object).revert();
            }
            catch (Exception exception) {}
        }
    }

    public void cancel() {
        this.revert();
        this.clearElements();
    }

    @Override
    public boolean contains(Object object) {
        return this.implementor.contains(object);
    }

    public boolean containsAll(Collection collection) {
        return this.implementor.containsAll(collection);
    }

    @Override
    public boolean equals(Object object) {
        return this.implementor.equals(object);
    }

    @Override
    public int hashCode() {
        return this.implementor.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.implementor.isEmpty();
    }

    @Override
    public Iterator iterator() {
        return this.implementor.iterator();
    }

    @Override
    public boolean remove(Object object) {
        return this.implementor.remove(object);
    }

    public boolean removeAll(Collection collection) {
        return this.implementor.removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.implementor.retainAll(collection);
    }

    @Override
    public int size() {
        return this.implementor.size();
    }

    @Override
    public Object[] toArray() {
        return this.implementor.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.implementor.toArray(objectArray);
    }

    public boolean add(Object object) {
        logging.debug(this, "###### UpdateCollection add Object  " + object);
        if (!(object instanceof UpdateCommand)) {
            logging.debugOut(1, "wrong element type, found" + object.getClass().getName() + ", expected an    + UpdateCommand");
            return false;
        }
        if (object == null) {
            return true;
        }
        return this.implementor.add(object);
    }

    @Override
    public int accumulatedSize() {
        if (this.size() == 0) {
            return 0;
        }
        int n = 0;
        for (Object object : this.implementor) {
            if (object == null) continue;
            if (object instanceof CountedCollection) {
                n += ((CountedCollection)object).accumulatedSize();
                continue;
            }
            ++n;
        }
        return n;
    }

    @Override
    public Object getController() {
        return null;
    }

    @Override
    public void setController(Object object) {
    }

    @Override
    public void doCall() {
        logging.debug(this, "doCall, element count: " + this.size());
        if (this.size() == 0) {
            return;
        }
        for (UpdateCommand updateCommand : this.implementor) {
            if (updateCommand == null) continue;
            updateCommand.doCall();
        }
    }
}

