/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.productaction;

import de.uib.configed.ConfigedMain;
import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.opsidatamodel.PersistenceController;
import de.uib.utilities.NameProducer;
import de.uib.utilities.logging.logging;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PanelMountShare
extends JPanel {
    static ArrayList<PanelMountShare> instances = new ArrayList();
    final int firstLabelWidth = Globals.firstLabelWidth;
    PersistenceController persist;
    ConfigedMain main;
    JFrame rootFrame;
    JButton buttonMountShare;
    JLabel mountShareLabel;
    JLabel mountShareDescriptionLabel;
    final boolean isWindows;
    boolean smbMounted;
    int leftBound = -1;
    NameProducer np;

    public PanelMountShare(NameProducer nameProducer, ConfigedMain configedMain, JFrame jFrame) {
        this(nameProducer, configedMain, jFrame, -1);
    }

    public PanelMountShare(NameProducer nameProducer, ConfigedMain configedMain, JFrame jFrame, int n) {
        instances.add(this);
        this.main = configedMain;
        this.rootFrame = jFrame;
        this.np = nameProducer;
        this.leftBound = n;
        this.isWindows = de.uib.utilities.Globals.isWindows();
        this.smbMounted = false;
        this.initComponents();
        this.defineLayout();
    }

    private void initComponents() {
        this.buttonMountShare = new JButton("", Globals.createImageIcon("images/windows16.png", ""));
        this.buttonMountShare.setSelectedIcon(Globals.createImageIcon("images/windows16.png", ""));
        this.buttonMountShare.setPreferredSize(Globals.graphicButtonDimension);
        if (this.isWindows) {
            this.buttonMountShare.setToolTipText(configed.getResourceValue("PanelMountShare.mountShareDescription") + " " + this.np.produceName());
        }
        this.buttonMountShare.setEnabled(this.isWindows);
        this.buttonMountShare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PanelMountShare.this.callMountShare();
            }
        });
    }

    private void defineLayout() {
        this.mountShareLabel = new JLabel("");
        this.mountShareDescriptionLabel = new JLabel(configed.getResourceValue("PanelMountShare.mountShareResult0") + " " + this.np.getDefaultName());
        this.checkConnectionToShare();
        PanelMountShare panelMountShare = this;
        GroupLayout groupLayout = new GroupLayout(panelMountShare);
        panelMountShare.setLayout(groupLayout);
        int n = Globals.hFirstGap;
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.mountShareLabel, 28, 28, 28).addComponent(this.buttonMountShare, 28, 28, 28).addComponent(this.mountShareDescriptionLabel, 28, 28, 28)));
        if (this.leftBound >= 0) {
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addGroup(groupLayout.createSequentialGroup().addComponent(this.mountShareLabel, 0, 0, 0).addGap(this.leftBound, this.leftBound, this.leftBound).addComponent(this.buttonMountShare, Globals.graphicButtonWidth, Globals.graphicButtonWidth, Globals.graphicButtonWidth).addGap(n, n, n).addComponent(this.mountShareDescriptionLabel, 280, 280, 420).addGap(10, 10, 10)));
        } else {
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addGroup(groupLayout.createSequentialGroup().addGap(n, n, n).addComponent(this.mountShareLabel, this.firstLabelWidth, this.firstLabelWidth, this.firstLabelWidth).addGap(10, 10, 10).addComponent(this.buttonMountShare, -2, -2, -2).addGap(n, n, n).addComponent(this.mountShareDescriptionLabel, 280, 280, Short.MAX_VALUE).addGap(5, 5, 5).addGap(10, 30, Short.MAX_VALUE)));
        }
    }

    public void mount(boolean bl) {
        this.smbMounted = bl;
        if (!bl) {
            this.callMountShare();
        }
        this.setShareMountedInfo(this.smbMounted);
    }

    private void callMountShare() {
        if (!this.isWindows) {
            return;
        }
        String string = "explorer.exe  \"" + this.np.produceName() + "\"";
        logging.info(this, "windows call: " + string);
        try {
            Runtime.getRuntime().exec(string);
        }
        catch (IOException iOException) {
            logging.error("io-Error: " + iOException, iOException);
        }
        catch (Exception exception) {
            logging.error("general error on starting net mount " + exception, exception);
        }
        this.mountShareDescriptionLabel.setText(configed.getResourceValue("PanelMountShare.mountShareResult1") + " " + this.np.produceName());
        this.checkConnectionToShare(240);
    }

    private static void checkAllConnections() {
        for (PanelMountShare panelMountShare : instances) {
            panelMountShare.checkConnectionToShare();
        }
    }

    private void setShareMountedInfo(boolean bl) {
        if (bl) {
            this.mountShareDescriptionLabel.setText(configed.getResourceValue("PanelMountShare.mountShareResult2") + " " + this.np.produceName());
        } else {
            this.mountShareDescriptionLabel.setText(configed.getResourceValue("PanelMountShare.mountShareResult0"));
        }
    }

    protected boolean checkConnectionToShare() {
        boolean bl = false;
        if (this.np.produceName() == null || this.np.produceName().equals("")) {
            logging.info(this, "checkConnectionToShare no filename " + this.np.produceName());
        } else {
            File file = new File(this.np.produceName());
            if (!file.exists()) {
                logging.info(this, "checkConnectionToShare no existing filename " + this.np.produceName());
            } else {
                bl = file.isDirectory();
                if (!bl) {
                    logging.info(this, "checkConnectionToShare no directory " + this.np.produceName());
                }
            }
        }
        this.setShareMountedInfo(bl);
        if (!this.smbMounted && bl) {
            this.initialMount();
        }
        this.smbMounted = bl;
        return this.smbMounted;
    }

    protected void initialMount() {
    }

    protected void checkConnectionToShare(final int n) {
        new Thread(){

            @Override
            public void run() {
                int n2 = 0;
                while (!PanelMountShare.this.smbMounted && n2 < n) {
                    try {
                        logging.debug(this, "trying to find dir, count " + n2);
                        2.sleep(1000L);
                        ++n2;
                        PanelMountShare.this.checkConnectionToShare();
                        PanelMountShare.this.rootFrame.toFront();
                    }
                    catch (Exception exception) {
                        logging.debug(this, "Exception " + exception);
                    }
                }
                if (PanelMountShare.this.smbMounted) {
                    PanelMountShare.checkAllConnections();
                }
            }
        }.start();
    }
}

