/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.guidata;

import de.uib.configed.ConfigedMain;
import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.configed.guidata.IFInstallationStateTableModel;
import de.uib.opsidatamodel.PersistenceController;
import de.uib.opsidatamodel.productstate.ActionRequest;
import de.uib.opsidatamodel.productstate.ActionResult;
import de.uib.opsidatamodel.productstate.Config;
import de.uib.opsidatamodel.productstate.InstallationInfo;
import de.uib.opsidatamodel.productstate.InstallationStatus;
import de.uib.opsidatamodel.productstate.LastAction;
import de.uib.opsidatamodel.productstate.ProductState;
import de.uib.opsidatamodel.productstate.TargetConfiguration;
import de.uib.utilities.ComboBoxModeller;
import de.uib.utilities.logging.logging;
import java.awt.Color;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.table.AbstractTableModel;

public class InstallationStateTableModel
extends AbstractTableModel
implements ComboBoxModeller,
IFInstallationStateTableModel {
    public static final String EMPTYFIELD = "_";
    public static final String CONFLICTstring = "mixed";
    public static final Color backgroundGrey;
    public static final Color conflictBackColor;
    public static final Color conflictTextColor;
    public static final Color defaultBackColor;
    public static final Color defaultTextColor;
    public static final Color notUpdatedTextColor;
    final String initString = "";
    protected static Map<String, String> columnDict;
    protected static List<String> columnsLocalized;
    protected String actualProduct = "";
    protected ConfigedMain main;
    protected Vector productsV = null;
    protected Map<String, Map<String, String>> combinedVisualValues;
    protected Map stateChanges;
    protected Map<String, Set<String>> product2setOfClientsWithNewAction;
    protected Map<String, ActionRequest> productActions;
    protected Map<String, Map<String, Map<String, String>>> allClientsProductStates;
    protected PersistenceController persist;
    protected Map<String, Map<String, Map<String, String>>> collectChangedStates;
    protected final String[] selectedClients;
    protected Map possibleActions;
    protected Map<String, Map<String, Object>> globalProductInfos;
    protected String theClient;
    protected TreeSet tsProductNames;
    protected Vector<String> productNamesInDeliveryOrder;
    protected ActionRequest actionInTreatment;
    protected boolean changeActionIsSet = false;
    protected List<String> displayColumns;
    protected int numberOfColumns;
    protected List<String> preparedColumns;
    protected List<String> columnTitles;
    protected int[] indexPreparedColumns;
    protected boolean[] editablePreparedColumns;

    public static void restartColumnDict() {
        columnDict = null;
    }

    public static String getColumnTitle(String string) {
        if (columnDict == null) {
            columnDict = new HashMap<String, String>();
            columnDict.put("productId", configed.getResourceValue("InstallationStateTableModel.productId"));
            columnDict.put("productName", configed.getResourceValue("InstallationStateTableModel.productName"));
            columnDict.put("targetConfiguration", configed.getResourceValue("InstallationStateTableModel.targetConfiguration"));
            columnDict.put("installationStatus", configed.getResourceValue("InstallationStateTableModel.installationStatus"));
            columnDict.put("installationInfo", "Report");
            columnDict.put("actionProgress", configed.getResourceValue("InstallationStateTableModel.actionProgress"));
            columnDict.put("actionResult", configed.getResourceValue("InstallationStateTableModel.actionResult"));
            columnDict.put("lastAction", configed.getResourceValue("InstallationStateTableModel.lastAction"));
            columnDict.put("actionRequest", configed.getResourceValue("InstallationStateTableModel.actionRequest"));
            columnDict.put("priority", configed.getResourceValue("InstallationStateTableModel.priority"));
            columnDict.put("actionSequence", "actionSequence");
            columnDict.put("position", configed.getResourceValue("InstallationStateTableModel.position"));
            columnDict.put("versionInfo", "Version");
            columnDict.put("productVersion", configed.getResourceValue("InstallationStateTableModel.productVersion"));
            columnDict.put("packageVersion", configed.getResourceValue("InstallationStateTableModel.packageVersion"));
            columnDict.put("stateChange", configed.getResourceValue("InstallationStateTableModel.lastStateChange"));
        }
        if (columnDict.get(string) == null) {
            return "";
        }
        return columnDict.get(string);
    }

    public static List<String> localizeColumns(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (columnDict != null) {
            for (String string : list) {
                if (columnDict.get(string) == null) continue;
                arrayList.add(columnDict.get(string));
            }
        }
        return arrayList;
    }

    public InstallationStateTableModel(String[] stringArray, ConfigedMain configedMain, Map<String, Map<String, Map<String, String>>> map, List list, Map<String, List<Map<String, String>>> map2, Map map3, Map<String, Map<String, Object>> map4, List<String> list2) {
        Object object;
        logging.debug(this, "creating an InstallationStateTableModel ");
        this.main = configedMain;
        this.collectChangedStates = map;
        this.selectedClients = stringArray;
        this.possibleActions = map3;
        this.globalProductInfos = map4;
        this.initColumnNames(list2);
        this.initChangedStates();
        Iterator<String> iterator = ProductState.KEYS.iterator();
        this.combinedVisualValues = new HashMap<String, Map<String, String>>();
        while (iterator.hasNext()) {
            object = iterator.next();
            HashMap hashMap = new HashMap();
            this.combinedVisualValues.put((String)object, hashMap);
        }
        this.persist = configedMain.getPersistenceController();
        object = Collator.getInstance();
        ((Collator)object).setStrength(1);
        this.productNamesInDeliveryOrder = new Vector();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                this.productNamesInDeliveryOrder.add(string);
            }
        }
        this.tsProductNames = new TreeSet(object);
        this.tsProductNames.addAll(this.productNamesInDeliveryOrder);
        this.productsV = new Vector(this.tsProductNames);
        logging.debug(this, "tsProductNames " + this.tsProductNames);
        this.allClientsProductStates = new HashMap<String, Map<String, Map<String, String>>>();
        this.produceVisualStatesFromExistingEntries(map2);
        this.completeVisualStatesByDefaults();
    }

    private void produceVisualStatesFromExistingEntries(Map<String, List<Map<String, String>>> map) {
        if (map == null) {
            return;
        }
        for (String string : map.keySet()) {
            HashMap<String, Map<String, String>> hashMap = new HashMap<String, Map<String, String>>();
            this.allClientsProductStates.put(string, hashMap);
            List<Map<String, String>> list = map.get(string);
            for (int i = 0; i < list.size(); ++i) {
                Map<String, String> map2 = list.get(i);
                String string2 = map2.get("productId");
                hashMap.put(string2, map2);
                String string3 = map2.get("targetConfiguration");
                if (string3.equals("")) {
                    string3 = TargetConfiguration.getLabel(0);
                }
                map2.put("targetConfiguration", string3);
                String string4 = "";
                if (this.globalProductInfos != null && this.globalProductInfos.get(string2) != null) {
                    string4 = "" + this.globalProductInfos.get(string2).get("priority");
                }
                map2.put("priority", string4);
                map2.put("actionSequence", string4);
                for (String string5 : ProductState.KEYS) {
                    this.mixToVisualState(this.combinedVisualValues.get(string5), string2, map2.get(string5));
                }
            }
        }
    }

    private void completeVisualStatesByDefaults() {
        for (int i = 0; i < this.selectedClients.length; ++i) {
            Map<String, Map<String, String>> map = this.allClientsProductStates.get(this.selectedClients[i]);
            if (map == null) {
                map = new HashMap<String, Map<String, String>>();
                this.allClientsProductStates.put(this.selectedClients[i], map);
            }
            for (int j = 0; j < this.productsV.size(); ++j) {
                String string = (String)this.productsV.get(j);
                Map<String, String> map2 = map.get(string);
                if (map2 != null) continue;
                Iterator<String> iterator = ProductState.KEYS.iterator();
                String string2 = "";
                if (this.globalProductInfos != null && this.globalProductInfos.get(string) != null) {
                    string2 = "" + this.globalProductInfos.get(string).get("priority");
                }
                while (iterator.hasNext()) {
                    String string3 = iterator.next();
                    if (string3 == "priority" || string3 == "actionSequence") {
                        this.mixToVisualState(this.combinedVisualValues.get(string3), string, string2);
                        continue;
                    }
                    this.mixToVisualState(this.combinedVisualValues.get(string3), string, (String)ProductState.getDEFAULT().get(string3));
                }
            }
        }
    }

    protected void mixToVisualState(Map map, String string, String string2) {
        String string3 = (String)map.get(string);
        if (string3 == null) {
            map.put(string, string2);
        } else if (!string3.equalsIgnoreCase(string2)) {
            map.put(string, CONFLICTstring);
        }
    }

    private Boolean preparedColumnIsEditable(int n) {
        if (this.editablePreparedColumns == null || n < 0 || n >= this.editablePreparedColumns.length) {
            return null;
        }
        if (Globals.isReadOnly()) {
            return false;
        }
        return this.editablePreparedColumns[n];
    }

    private void initColumnNames(List<String> list) {
        this.preparedColumns = new ArrayList<String>();
        this.editablePreparedColumns = new boolean[16];
        this.preparedColumns.add(0, "productId");
        this.editablePreparedColumns[0] = false;
        this.preparedColumns.add(1, "productName");
        this.editablePreparedColumns[1] = false;
        this.preparedColumns.add(2, "targetConfiguration");
        this.editablePreparedColumns[2] = true;
        this.preparedColumns.add(3, "installationStatus");
        this.editablePreparedColumns[3] = true;
        this.preparedColumns.add(4, "installationInfo");
        this.editablePreparedColumns[4] = true;
        this.preparedColumns.add(5, "actionProgress");
        this.editablePreparedColumns[5] = false;
        this.preparedColumns.add(6, "actionResult");
        this.editablePreparedColumns[6] = false;
        this.preparedColumns.add(7, "lastAction");
        this.editablePreparedColumns[7] = false;
        this.preparedColumns.add(8, "actionRequest");
        this.editablePreparedColumns[8] = true;
        this.preparedColumns.add(9, "priority");
        this.editablePreparedColumns[9] = false;
        this.preparedColumns.add(10, "actionSequence");
        this.editablePreparedColumns[10] = false;
        this.preparedColumns.add(11, "position");
        this.editablePreparedColumns[11] = false;
        this.preparedColumns.add(12, "versionInfo");
        this.editablePreparedColumns[12] = false;
        this.preparedColumns.add(13, "productVersion");
        this.editablePreparedColumns[13] = false;
        this.preparedColumns.add(14, "packageVersion");
        this.editablePreparedColumns[14] = false;
        this.preparedColumns.add(15, "stateChange");
        this.editablePreparedColumns[15] = false;
        if (list == null) {
            logging.error(this, "columnsToDisplay are null");
            return;
        }
        this.displayColumns = list;
        logging.info(this, "preparedColumns:  " + this.preparedColumns);
        logging.info(this, "columnsToDisplay: " + list);
        this.indexPreparedColumns = new int[list.size()];
        this.columnTitles = new ArrayList<String>();
        Iterator<String> iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = iterator.next();
            logging.debug(this, " ------- treat column " + string);
            int n2 = this.preparedColumns.indexOf(string);
            if (n2 >= 0) {
                this.indexPreparedColumns[n] = n2;
                logging.debug(this, "indexPreparedColumns of displayColumn " + n + " is " + n2);
                this.columnTitles.add(InstallationStateTableModel.getColumnTitle(string));
            } else {
                logging.info(this, "column " + string + " is not prepared");
                this.columnTitles.add(string);
            }
            ++n;
        }
        this.numberOfColumns = this.displayColumns.size();
        logging.info(this, " -------- numberOfColumns " + this.numberOfColumns);
    }

    @Override
    public int getColumnIndex(String string) {
        return this.displayColumns.indexOf(string);
    }

    private void initChangedStates() {
        for (int i = 0; i < this.selectedClients.length; ++i) {
            HashMap hashMap = new HashMap();
            this.collectChangedStates.put(this.selectedClients[i], hashMap);
        }
    }

    @Override
    public void clearCollectChangedStates() {
        this.collectChangedStates.clear();
        this.changeActionIsSet = false;
    }

    protected void setInstallationInfo(String string, String string2) {
        this.combinedVisualValues.get("installationInfo").put(string, string2);
        for (int i = 0; i < this.selectedClients.length; ++i) {
            this.setInstallationInfo(this.selectedClients[i], string, string2);
        }
    }

    private void setInstallationInfo(String string, String string2, String string3) {
        Map<String, String> map;
        logging.debug(this, "setInstallationInfo for product, client, value " + string2 + ", " + string + ", " + string3);
        Map<String, Map<String, String>> map2 = this.collectChangedStates.get(string);
        if (map2 == null) {
            map2 = new HashMap<String, Map<String, String>>();
            this.collectChangedStates.put(string, map2);
        }
        if ((map = map2.get(string2)) == null) {
            map = new HashMap<String, String>();
            map2.put(string2, map);
        }
        if (string3.equals("") || string3.equals("none")) {
            map.put("lastAction", LastAction.getLabel(0));
            map.put("actionResult", LastAction.getLabel(0));
            map.put("actionProgress", "");
        } else if (string3.equals("failed")) {
            map.put("lastAction", LastAction.getLabel(0));
            map.put("actionResult", ActionResult.getLabel(2));
            map.put("actionProgress", "manually set");
        } else if (string3.equals("success")) {
            map.put("lastAction", LastAction.getLabel(0));
            map.put("actionResult", ActionResult.getLabel(4));
            map.put("actionProgress", "manually set");
        } else {
            map.put("lastAction", ActionResult.getLabel(0));
            map.put("actionResult", LastAction.getLabel(0));
            map.put("actionProgress", string3);
        }
    }

    private void setChangedState(String string, String string2, String string3, String string4) {
        Map<String, String> map;
        Map<String, Map<String, String>> map2 = this.collectChangedStates.get(string);
        if (map2 == null) {
            map2 = new HashMap<String, Map<String, String>>();
            this.collectChangedStates.put(string, map2);
        }
        if ((map = map2.get(string2)) == null) {
            map = new HashMap<String, String>();
            map2.put(string2, map);
        }
        map.put(string3, string4);
    }

    private String getChangedState(String string, String string2, String string3) {
        Map<String, Map<String, String>> map = this.collectChangedStates.get(string);
        if (map == null) {
            return null;
        }
        Map<String, String> map2 = map.get(string2);
        if (map2 == null) {
            return null;
        }
        return map2.get(string3);
    }

    protected void registerStateChange(String string, String string2, String string3) {
        for (int i = 0; i < this.selectedClients.length; ++i) {
            this.setChangedState(this.selectedClients[i], string, string2, string3);
        }
    }

    protected void changeActionRequest(String string, String string2) {
        ActionRequest actionRequest = ActionRequest.produceFromDisplayLabel(string2);
        this.changeActionIsSet = true;
        this.product2setOfClientsWithNewAction = new HashMap<String, Set<String>>();
        this.productActions = new HashMap<String, ActionRequest>();
        for (int i = 0; i < this.selectedClients.length; ++i) {
            this.recursiveChangeActionRequest(this.selectedClients[i], string, actionRequest);
        }
        for (String string3 : this.product2setOfClientsWithNewAction.keySet()) {
            if (this.product2setOfClientsWithNewAction.get(string3).size() < this.selectedClients.length) {
                this.mixToVisualState(this.combinedVisualValues.get("actionRequest"), string3, this.productActions.get(string3).toString());
                continue;
            }
            this.combinedVisualValues.get("actionRequest").put(string3, this.productActions.get(string3).toString());
        }
    }

    protected void recursiveChangeActionRequest(String string, String string2, ActionRequest actionRequest) {
        this.setChangedState(string, string2, "actionRequest", actionRequest.toString());
        Set<String> set = this.product2setOfClientsWithNewAction.get(string2);
        if (set == null) {
            set = new HashSet<String>();
            this.product2setOfClientsWithNewAction.put(string2, set);
        }
        set.add(string);
        this.productActions.put(string2, actionRequest);
        int n = this.getRowFromID(string2);
        logging.debug(this, "recursiveChangeActionRequest product " + string2 + " modelRow " + n);
        if (n > -1) {
            logging.info(this, "recursiveChangeActionRequest fire update  " + n);
            this.fireTableRowsUpdated(n, n);
        }
        logging.debug(this, " change action request for client " + string + ",  product " + string2 + " to " + actionRequest.toString());
        if (actionRequest.getVal() == 5) {
            this.followRequirements(string, this.persist.getProductDeinstallRequirements(null, string2));
        } else {
            this.followRequirements(string, this.persist.getProductPreRequirements(null, string2));
            this.followRequirements(string, this.persist.getProductRequirements(null, string2));
            this.followRequirements(string, this.persist.getProductPostRequirements(null, string2));
        }
    }

    private void followRequirements(String string, Map<String, String> map) {
        logging.debug(this, "-- followRequirements for client " + string);
        for (String string2 : map.keySet()) {
            logging.debug(this, "requiredProduct: " + string2);
            String string3 = map.get(string2);
            String string4 = ActionRequest.getLabel(0);
            String string5 = InstallationStatus.getLabel(-1);
            int n = string3.indexOf(":");
            if (n >= 0) {
                string5 = string3.substring(0, n);
                string4 = string3.substring(n + 1);
            }
            logging.debug(this, "followRequirements, required product: " + string2);
            logging.debug(this, "followRequirements, required action: " + string4);
            logging.debug(this, "followRequirements, required state: " + string5);
            if (!this.tsProductNames.contains(string2)) {
                logging.warning("followRequirements: required product: '" + string2 + "' not installable");
                continue;
            }
            if (this.getChangedState(string, string2, "actionRequest") != null) {
                logging.debug(this, "required product: '" + string2 + "'  has already been treated - stop recursion ");
                continue;
            }
            Map<String, Map<String, String>> map2 = this.allClientsProductStates.get(string);
            if (map2 == null) continue;
            ProductState productState = map2.get(string2);
            logging.debug(this, "---- stateAndAction " + productState);
            if (productState == null) {
                productState = new ProductState(null);
            }
            if (productState == null) continue;
            String string6 = (String)productState.get("actionRequest");
            logging.debug(this, "---- stateAndAction: ActionRequest for requiredProduct " + string6);
            String string7 = (String)productState.get("installationStatus");
            logging.debug(this, "---- stateAndAction: InstallationStatus for requiredProduct " + string7);
            logging.debug(this, "requiredAction " + string4);
            logging.debug(this, "ActionRequest.getVal(requiredAction) " + ActionRequest.getVal(string4));
            int n2 = ActionRequest.getVal(string4);
            int n3 = InstallationStatus.getVal(string5);
            logging.debug(this, " requiredInstallationsStatus " + InstallationStatus.getDisplayLabel(n3));
            if ((n3 == 1 || n3 == 0) && InstallationStatus.getVal(string7) != n3) {
                String string8 = InstallationStatus.getLabel(n3);
                String string9 = Config.getInstance().requiredActionForStatus.get(string8);
                n2 = ActionRequest.getVal(string9);
            }
            if (n2 <= 0) continue;
            if (ActionRequest.getVal(string6) == n2) {
                logging.debug(this, "followRequirements:   no change of action request necessary for " + string2);
                continue;
            }
            logging.info(this, "followRequirements:   ===== recursion into " + string2);
            this.recursiveChangeActionRequest(string, string2, new ActionRequest(n2));
        }
    }

    public int getRowFromID(String string) {
        return this.productsV.indexOf(string);
    }

    @Override
    public Map<String, Map<String, Object>> getGlobalProductInfos() {
        return this.globalProductInfos;
    }

    @Override
    public ComboBoxModel getComboBoxModel(int n, int n2) {
        this.actualProduct = (String)this.productsV.get(n);
        if (n2 == this.displayColumns.indexOf("actionRequest")) {
            logging.debug(this, " possible actions  " + this.possibleActions);
            Object[] objectArray = null;
            if (this.possibleActions != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string : (List)this.possibleActions.get(this.actualProduct)) {
                    ActionRequest actionRequest = ActionRequest.produceFromLabel(string);
                    arrayList.add(ActionRequest.getDisplayLabel(actionRequest.getVal()));
                }
                objectArray = arrayList.toArray();
                logging.debugOut(6, " possible actions as array  " + objectArray);
            }
            if (objectArray == null) {
                objectArray = new String[]{"null"};
            }
            return new DefaultComboBoxModel(objectArray);
        }
        if (n2 == this.displayColumns.indexOf("installationStatus")) {
            if (this.possibleActions.get(this.actualProduct) == null) {
                String string = this.combinedVisualValues.get("installationStatus").get(this.actualProduct);
                if (string == null) {
                    return new DefaultComboBoxModel<String>(new String[]{"null"});
                }
                return new DefaultComboBoxModel<String>(new String[0]);
            }
            return new DefaultComboBoxModel<String>(InstallationStatus.getDisplayLabelsForChoice());
        }
        if (n2 == this.displayColumns.indexOf("targetConfiguration")) {
            if (this.possibleActions.get(this.actualProduct) == null) {
                String string = this.combinedVisualValues.get("installationStatus").get(this.actualProduct);
                if (string == null) {
                    return new DefaultComboBoxModel<String>(new String[]{"null"});
                }
                return new DefaultComboBoxModel<String>(new String[0]);
            }
            return new DefaultComboBoxModel<String>(TargetConfiguration.getDisplayLabelsForChoice());
        }
        if (n2 == this.displayColumns.indexOf("installationInfo")) {
            String string = (String)this.getValueAt(n, n2);
            if (string == null) {
                string = "";
            }
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            if (!InstallationInfo.defaultDisplayValues.contains(string)) {
                linkedHashSet.add(string);
            }
            linkedHashSet.addAll(InstallationInfo.defaultDisplayValues);
            return new DefaultComboBoxModel(new Vector(linkedHashSet));
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return this.numberOfColumns;
    }

    @Override
    public int getRowCount() {
        return this.productsV.size();
    }

    @Override
    public String getColumnName(int n) {
        return this.columnTitles.get(n);
    }

    @Override
    public String getLastStateChange(int n) {
        String string = (String)this.productsV.get(n);
        return this.combinedVisualValues.get("stateChange").get(string);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.retrieveValueAt(n, n2);
    }

    private Object retrieveValueAt(int n, int n2) {
        Object object = null;
        this.actualProduct = (String)this.productsV.get(n);
        if (n2 >= this.indexPreparedColumns.length) {
            return "";
        }
        int n3 = this.indexPreparedColumns[n2];
        switch (n3) {
            case 0: {
                object = this.actualProduct;
                break;
            }
            case 1: {
                object = this.globalProductInfos.get(this.actualProduct).get("productName");
                break;
            }
            case 2: {
                object = this.combinedVisualValues.get("targetConfiguration").get(this.actualProduct);
                break;
            }
            case 3: {
                InstallationStatus installationStatus = InstallationStatus.produceFromLabel(this.combinedVisualValues.get("installationStatus").get(this.actualProduct));
                object = InstallationStatus.getDisplayLabel(installationStatus.getVal());
                break;
            }
            case 4: {
                object = this.combinedVisualValues.get("installationInfo").get(this.actualProduct);
                break;
            }
            case 5: {
                object = this.combinedVisualValues.get("actionProgress").get(this.actualProduct);
                break;
            }
            case 6: {
                object = this.combinedVisualValues.get("actionResult").get(this.actualProduct);
                break;
            }
            case 7: {
                object = this.combinedVisualValues.get("lastAction").get(this.actualProduct);
                break;
            }
            case 8: {
                ActionRequest actionRequest = ActionRequest.produceFromLabel(this.combinedVisualValues.get("actionRequest").get(this.actualProduct));
                object = ActionRequest.getDisplayLabel(actionRequest.getVal());
                break;
            }
            case 9: {
                object = this.combinedVisualValues.get("priority").get(this.actualProduct);
                break;
            }
            case 10: {
                object = this.combinedVisualValues.get("actionSequence").get(this.actualProduct);
                break;
            }
            case 11: {
                object = this.productNamesInDeliveryOrder.indexOf(this.actualProduct);
                break;
            }
            case 12: {
                object = this.combinedVisualValues.get("versionInfo").get(this.actualProduct);
                break;
            }
            case 13: {
                object = this.combinedVisualValues.get("productVersion").get(this.actualProduct);
                break;
            }
            case 14: {
                object = this.combinedVisualValues.get("packageVersion").get(this.actualProduct);
                break;
            }
            case 15: {
                object = this.combinedVisualValues.get("stateChange").get(this.actualProduct);
            }
        }
        return object;
    }

    public Class getColumnClass(int n) {
        Object object = this.retrieveValueAt(0, n);
        if (object == null) {
            return null;
        }
        return object.getClass();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.preparedColumnIsEditable(this.indexPreparedColumns[n2]) != false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.changeValueAt(object, n, n2);
        this.fireTableCellUpdated(n, n2);
    }

    protected void changeValueAt(Object object, int n, int n2) {
        String string = "nul";
        if (object != null) {
            string = object.getClass().toString();
        }
        logging.debug(this, "Setting value at " + n + "," + n2 + " to " + object + " (an instance of " + string + ")");
        this.actualProduct = (String)this.productsV.get(n);
        if (this.combinedVisualValues.get("installationStatus").get(this.actualProduct) == null) {
            return;
        }
        if (!((String)this.retrieveValueAt(n, n2)).equals((String)object)) {
            if (this.indexPreparedColumns[n2] == this.preparedColumns.indexOf("installationStatus")) {
                this.combinedVisualValues.get("installationStatus").put(this.actualProduct, (String)object);
                this.registerStateChange(this.actualProduct, "installationStatus", (String)object);
            } else if (this.indexPreparedColumns[n2] == this.preparedColumns.indexOf("targetConfiguration")) {
                this.combinedVisualValues.get("targetConfiguration").put(this.actualProduct, (String)object);
                this.registerStateChange(this.actualProduct, "targetConfiguration", (String)object);
            } else if (this.indexPreparedColumns[n2] == this.preparedColumns.indexOf("actionRequest")) {
                this.changeActionRequest(this.actualProduct, (String)object);
            } else if (this.indexPreparedColumns[n2] == this.preparedColumns.indexOf("installationInfo")) {
                if (object.equals("none")) {
                    object = "";
                }
                this.setInstallationInfo(this.actualProduct, (String)object);
            }
            this.main.getGeneralDataChangedKeeper().dataHaveChanged(this);
        }
    }

    static {
        conflictBackColor = backgroundGrey = new Color(220, 220, 220);
        conflictTextColor = backgroundGrey;
        defaultBackColor = Color.white;
        notUpdatedTextColor = defaultTextColor = Color.black;
    }
}

