/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.table.updates;

import de.uib.utilities.WaitCursor;
import de.uib.utilities.logging.logging;
import de.uib.utilities.table.GenTableModel;
import de.uib.utilities.table.gui.PanelGenEditTable;
import de.uib.utilities.table.updates.MapBasedTableEditItem;
import de.uib.utilities.table.updates.MapBasedUpdater;
import de.uib.utilities.table.updates.MapDeleteItem;
import de.uib.utilities.table.updates.MapDeliveryItem;
import de.uib.utilities.table.updates.TableUpdateCollection;
import de.uib.utilities.table.updates.UpdateController;
import java.util.Iterator;
import java.util.Vector;

public class MapItemsUpdateController
implements UpdateController {
    GenTableModel tablemodel;
    PanelGenEditTable panel;
    MapBasedUpdater updater;
    TableUpdateCollection updateCollection;

    public MapItemsUpdateController(PanelGenEditTable panelGenEditTable, GenTableModel genTableModel, MapBasedUpdater mapBasedUpdater, TableUpdateCollection tableUpdateCollection) {
        this.panel = panelGenEditTable;
        this.tablemodel = genTableModel;
        this.updater = mapBasedUpdater;
        this.updateCollection = tableUpdateCollection;
    }

    @Override
    public boolean saveChanges() {
        MapBasedTableEditItem mapBasedTableEditItem;
        WaitCursor waitCursor = new WaitCursor();
        boolean bl = true;
        Vector<MapBasedTableEditItem> vector = new Vector<MapBasedTableEditItem>();
        Iterator iterator = this.updateCollection.iterator();
        String string = new String("");
        boolean bl2 = true;
        while (iterator.hasNext() && bl) {
            mapBasedTableEditItem = (MapBasedTableEditItem)iterator.next();
            if (mapBasedTableEditItem.getSource() != this.tablemodel) continue;
            logging.debug(this, " handling updateItem " + mapBasedTableEditItem);
            if (mapBasedTableEditItem instanceof MapDeliveryItem) {
                String string2 = this.updater.sendUpdate(mapBasedTableEditItem.getRowAsMap());
                bl = string2 != null;
                if (!bl || !mapBasedTableEditItem.keyChanged()) continue;
                vector.add(mapBasedTableEditItem);
                string = string2;
                continue;
            }
            if (mapBasedTableEditItem instanceof MapDeleteItem) {
                bl = this.updater.sendDelete(mapBasedTableEditItem.getRowAsMap());
                continue;
            }
            logging.debugOut(1, "update item type not supported");
            bl = false;
        }
        if (bl) {
            iterator = this.updateCollection.iterator();
            while (iterator.hasNext()) {
                mapBasedTableEditItem = (MapBasedTableEditItem)iterator.next();
                if (mapBasedTableEditItem.getSource() != this.tablemodel) continue;
                iterator.remove();
            }
            this.tablemodel.startWithCurrentData();
            this.tablemodel.reset();
            logging.info(this, "saveChanges lastKeyValue " + string);
            this.panel.moveToKeyValue(string);
            waitCursor.stop();
        } else {
            if (vector.size() > 0) {
                while (iterator.hasNext()) {
                    mapBasedTableEditItem = (MapBasedTableEditItem)iterator.next();
                    if (mapBasedTableEditItem.getSource() != this.tablemodel) continue;
                    iterator.remove();
                }
                this.tablemodel.requestReload();
                this.tablemodel.reset();
                bl = true;
            }
            waitCursor.stop();
            logging.checkErrorList(null);
        }
        return bl;
    }

    @Override
    public boolean cancelChanges() {
        Iterator iterator = this.updateCollection.iterator();
        while (iterator.hasNext()) {
            MapBasedTableEditItem mapBasedTableEditItem = (MapBasedTableEditItem)iterator.next();
            if (mapBasedTableEditItem.getSource() != this.tablemodel) continue;
            iterator.remove();
        }
        this.tablemodel.invalidate();
        this.tablemodel.reset();
        return true;
    }
}

