/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.table.gui;

import de.uib.configed.Globals;
import de.uib.utilities.table.gui.StandardTableCellRenderer;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;

public class TableCellRendererByIndex
extends StandardTableCellRenderer {
    Map<String, String> mapOfStrings;
    Map<String, ImageIcon> mapOfImages;
    boolean showOnlyIcon = true;

    public TableCellRendererByIndex(Map<String, String> map, String string) {
        this(map, string, false, "");
    }

    public TableCellRendererByIndex(Map<String, String> map, String string, boolean bl, String string2) {
        super(string2);
        this.showOnlyIcon = bl;
        this.mapOfStrings = map;
        this.mapOfImages = new HashMap<String, ImageIcon>();
        for (Map.Entry<String, String> entry : this.mapOfStrings.entrySet()) {
            String string3 = entry.getKey();
            String string4 = entry.getValue();
            ImageIcon imageIcon = null;
            if (string == null || string3 == null || string4 == null) continue;
            String string5 = string + "/" + string3 + ".png";
            imageIcon = Globals.createImageIcon(string5, string4);
            if (imageIcon == null) {
                string5 = string + "/" + string4 + ".gif";
                imageIcon = Globals.createImageIcon(string5, string4);
            }
            if (imageIcon == null) continue;
            this.mapOfImages.put(string3, imageIcon);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        String string = "";
        ImageIcon imageIcon = null;
        if (object != null) {
            if (this.mapOfStrings != null) {
                string = this.mapOfStrings.get("" + object);
            }
            if (this.mapOfImages != null) {
                imageIcon = this.mapOfImages.get("" + object);
            }
        }
        if (component instanceof JLabel) {
            if (this.showOnlyIcon) {
                ((JLabel)component).setText(null);
                ((JLabel)component).setHorizontalAlignment(0);
            } else {
                ((JLabel)component).setText(string);
            }
            ((JLabel)component).setIcon(imageIcon);
            ((JLabel)component).setToolTipText(Globals.fillStringToLength(this.tooltipPrefix + " " + string + " ", this.FILL_LENGTH));
        }
        return component;
    }
}

