/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.swing.timeedit;

import de.uib.utilities.logging.logging;
import de.uib.utilities.swing.timeedit.TimeEditor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.border.EmptyBorder;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.event.DateSelectionEvent;
import org.jdesktop.swingx.event.DateSelectionListener;
import utils.PopupMouseListener;

public class DateTimeEditor
extends JPanel
implements DateSelectionListener {
    protected JXMonthView monthView;
    protected TimeEditor timeSetter;
    protected Calendar calendar;
    protected DateFormat hourDateFormat;
    protected JSpinner monthSpinner;
    protected SpinnerModel monthSpinnerModel;
    protected JButton buttonBack;
    protected JButton buttonForward;
    protected JButton buttonYearBack;
    protected JButton buttonYearForward;
    protected final int buttonH = 25;
    protected final int buttonW = 20;
    private Date now;
    protected boolean editable = true;
    protected boolean withMovingSelectionDate = true;
    protected boolean withTime = true;

    public DateTimeEditor() {
        this(true);
    }

    public DateTimeEditor(boolean bl) {
        this.withTime = bl;
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Jetzt");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateTimeEditor.this.setDate();
            }
        });
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Kein Datum");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateTimeEditor.this.monthView.getSelectionModel().clearSelection();
                DateTimeEditor.this.monthView.commitSelection();
            }
        });
        jPopupMenu.add(jMenuItem2);
        this.addMouseListener(new PopupMouseListener(jPopupMenu));
        this.calendar = Calendar.getInstance();
        if (!bl) {
            this.setToMidnight();
        }
        this.hourDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm");
        this.monthView = new JXMonthView();
        this.monthView.setSelectionMode(DateSelectionModel.SelectionMode.SINGLE_SELECTION);
        this.addDateSelectionListener(this);
        this.timeSetter = new TimeEditor(this.calendar.get(11), this.calendar.get(12));
        if (!bl) {
            this.timeSetter.setVisible(false);
        }
        this.setDate(false);
        this.monthView.addMouseListener(new PopupMouseListener(jPopupMenu));
        this.monthSpinnerModel = new SpinnerListModel();
        this.monthSpinner = new JSpinner(this.monthSpinnerModel);
        this.monthSpinner.setPreferredSize(new Dimension(17, 27));
        this.buttonBack = new JButton("<");
        this.buttonBack.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.buttonBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateTimeEditor.this.switchMonth(-1);
            }
        });
        this.buttonForward = new JButton(">");
        this.buttonForward.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.buttonForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateTimeEditor.this.switchMonth(1);
            }
        });
        this.buttonYearBack = new JButton("<<");
        this.buttonYearBack.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.buttonYearBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateTimeEditor.this.switchYear(-1);
            }
        });
        this.buttonYearForward = new JButton(">>");
        this.buttonYearForward.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.buttonYearForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateTimeEditor.this.switchYear(1);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(1, 1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.buttonBack, 20, 20, 20).addComponent(this.buttonYearBack, 20, 20, 20)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.timeSetter, GroupLayout.Alignment.LEADING, 0, 0, Short.MAX_VALUE).addComponent(this.monthView, -2, -2, -2)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.buttonForward, 20, 20, 20).addComponent(this.buttonYearForward, 20, 20, 20)).addGap(1, 1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.buttonBack, 25, 25, 25).addComponent(this.buttonYearBack, 25, 25, 25)).addComponent(this.monthView, -2, -2, -2).addGroup(groupLayout.createSequentialGroup().addComponent(this.buttonForward, 25, 25, 25).addComponent(this.buttonYearForward, 25, 25, 25)).addComponent(this.timeSetter, -2, -2, -2))));
    }

    protected void setToMidnight() {
        this.calendar.set(11, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
    }

    protected void switchMonth(int n) {
        this.calendar.add(2, n);
        Date date = this.calendar.getTime();
        this.monthView.ensureDateVisible(date);
        if (this.withMovingSelectionDate) {
            this.setSelectionDate(date);
        }
    }

    protected void switchYear(int n) {
        this.calendar.add(1, n);
        Date date = this.calendar.getTime();
        this.monthView.ensureDateVisible(date);
        if (this.withMovingSelectionDate) {
            this.setSelectionDate(date);
        }
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    @Override
    public void requestFocus() {
        logging.debug(this, "requestFocus");
        this.monthView.requestFocus();
    }

    public void setDate() {
        this.setDate(true);
    }

    public void setDate(boolean bl) {
        this.now = new Date();
        this.calendar.setTime(this.now);
        if (!this.withTime) {
            this.setToMidnight();
        }
        this.monthView.setFirstDisplayedDay(this.now);
        if (bl) {
            this.monthView.setSelectionDate(this.now);
        } else {
            this.monthView.getSelectionModel().clearSelection();
            this.monthView.commitSelection();
        }
        logging.debug(this, " ------- setDate,  hour  " + this.calendar.get(11) + ", min " + this.calendar.get(12));
        this.timeSetter.setHour(this.calendar.get(11));
        this.timeSetter.setMin(this.calendar.get(12));
    }

    public void setHour(int n) {
        this.timeSetter.setHour(n);
    }

    public void setMin(int n) {
        this.timeSetter.setMin(n);
    }

    public void setSelectionDate(Date date) {
        logging.debug(this, " setSelectionDate " + date);
        if (date != null) {
            this.monthView.ensureDateVisible(date);
        }
        this.calendar.setTime(date);
        this.monthView.setSelectionDate(date);
        this.timeSetter.setHour(this.calendar.get(11));
        this.timeSetter.setMin(this.calendar.get(12));
    }

    public int getHour() {
        return this.timeSetter.getHour();
    }

    public int getMin() {
        return this.timeSetter.getHour();
    }

    public Date getSelectionDate() {
        return this.monthView.getFirstSelectionDate();
    }

    public Timestamp getSelectedSqlTime() {
        if (this.monthView.getFirstSelectionDate() == null) {
            return null;
        }
        this.calendar.setTime(this.monthView.getFirstSelectionDate());
        this.calendar.add(10, this.timeSetter.getHour());
        this.calendar.add(12, this.timeSetter.getMin());
        return new Timestamp(this.calendar.getTimeInMillis());
    }

    public void addDateSelectionListener(DateSelectionListener dateSelectionListener) {
        this.monthView.getSelectionModel().addDateSelectionListener(dateSelectionListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.monthView.addActionListener(actionListener);
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        this.monthView.addKeyListener(keyListener);
    }

    public void addMonthViewMouseListener(MouseListener mouseListener) {
        this.monthView.addMouseListener(mouseListener);
    }

    @Override
    public void valueChanged(DateSelectionEvent dateSelectionEvent) {
        if (this.withMovingSelectionDate && !this.calendar.getTime().equals(this.monthView.getFirstSelectionDate()) && this.monthView.getFirstSelectionDate() != null) {
            this.calendar.setTime(this.monthView.getFirstSelectionDate());
        }
    }

    protected static String[] getMonthStrings() {
        int n;
        String[] stringArray = new DateFormatSymbols().getMonths();
        if (stringArray[n = stringArray.length - 1] == null || stringArray[n].length() <= 0) {
            String[] stringArray2 = new String[n];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            return stringArray2;
        }
        return stringArray;
    }
}

