/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.swing;

import de.uib.configed.Globals;
import de.uib.utilities.observer.ObservableSubject;
import de.uib.utilities.observer.swing.JTextFieldObserved;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RecordPane
extends JPanel
implements KeyListener {
    protected int lineHeight = 28;
    protected int vGapSize = 10;
    protected int hGapSize = 10;
    protected int minFieldWidth = 60;
    protected int maxFieldWidth = Short.MAX_VALUE;
    protected int minLabelWidth = 30;
    protected int maxLabelWidth = 100;
    protected ObservableSubject editingNotifier;
    protected Map<String, JLabel> labelfields;
    protected Map<String, JTextFieldObserved> datafields;
    protected LinkedHashMap<String, String> data;
    protected Map<String, String> labels;
    protected Map<String, String> hints;
    protected Map<String, Boolean> editable;

    public RecordPane() {
    }

    public RecordPane(LinkedHashMap<String, String> linkedHashMap, Map<String, String> map, Map<String, String> map2, Map<String, Boolean> map3) {
        this.init(linkedHashMap, map, map2, map3);
    }

    public void setObservableSubject(ObservableSubject observableSubject) {
        this.editingNotifier = observableSubject == null ? new TheObservableSubject() : observableSubject;
        for (String string : this.datafields.keySet()) {
            this.datafields.get(string).setGlobalObservableSubject(this.editingNotifier);
        }
    }

    public void setData(LinkedHashMap<String, String> linkedHashMap, Map<String, String> map, Map<String, String> map2, Map<String, Boolean> map3) {
        this.init(linkedHashMap, map, map2, map3);
    }

    protected void init(LinkedHashMap<String, String> linkedHashMap, Map<String, String> map, Map<String, String> map2, Map<String, Boolean> map3) {
        this.data = linkedHashMap;
        this.labels = map;
        this.editable = map3;
        this.hints = map2;
        this.initComponents();
    }

    protected void initComponents() {
        Object object;
        this.setBackground(Globals.backgroundWhite);
        this.labelfields = new HashMap<String, JLabel>();
        this.datafields = new HashMap<String, JTextFieldObserved>();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        if (this.data == null) {
            return;
        }
        for (String object22 : this.data.keySet()) {
            object = new JLabel();
            if (this.labels == null || this.labels.get(object22) == null) {
                ((JLabel)object).setText("");
            } else {
                ((JLabel)object).setText(this.labels.get(object22));
            }
            ((JComponent)object).setFont(Globals.defaultFontBig);
            this.labelfields.put(object22, (JLabel)object);
            JTextFieldObserved jTextFieldObserved = new JTextFieldObserved();
            if (this.data.get(object22) != null) {
                jTextFieldObserved.setText("" + this.data.get(object22));
            } else {
                jTextFieldObserved.setText("");
            }
            jTextFieldObserved.setFont(Globals.defaultFontBig);
            jTextFieldObserved.getCaret().setBlinkRate(0);
            if (this.hints != null) {
                jTextFieldObserved.setToolTipText(this.hints.get(object22));
            }
            if (this.editable != null && this.editable.get(object22) != null) {
                jTextFieldObserved.setEditable(this.editable.get(object22));
                jTextFieldObserved.setEnabled(this.editable.get(object22));
            } else {
                jTextFieldObserved.setEditable(false);
                jTextFieldObserved.setEnabled(false);
            }
            jTextFieldObserved.addKeyListener(this);
            this.datafields.put(object22, jTextFieldObserved);
        }
        HashMap hashMap = new HashMap();
        GroupLayout.ParallelGroup parallelGroup = groupLayout.createParallelGroup();
        for (String string : this.data.keySet()) {
            parallelGroup.addGroup(groupLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.labelfields.get(string), this.minLabelWidth, -2, this.maxLabelWidth).addGap(5, 5, 5).addComponent(this.datafields.get(string), this.minFieldWidth, -2, this.maxFieldWidth).addGap(5, 5, 5));
        }
        groupLayout.setHorizontalGroup(parallelGroup);
        object = groupLayout.createSequentialGroup();
        ((GroupLayout.SequentialGroup)object).addGap(10, 10, 10);
        for (String string : this.data.keySet()) {
            ((GroupLayout.SequentialGroup)object).addGap(10, 10, 10);
            ((GroupLayout.SequentialGroup)object).addGroup(groupLayout.createParallelGroup().addComponent(this.labelfields.get(string), this.lineHeight, this.lineHeight, this.lineHeight).addComponent(this.datafields.get(string), this.lineHeight, this.lineHeight, this.lineHeight));
        }
        ((GroupLayout.SequentialGroup)object).addGap(10, 10, 10);
        groupLayout.setVerticalGroup((GroupLayout.Group)object);
    }

    public LinkedHashMap<String, String> getData() {
        for (String string : this.data.keySet()) {
            this.data.put(string, this.datafields.get(string).getText());
        }
        return this.data;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    public static void main(String[] stringArray) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("field1", "test1");
        linkedHashMap.put("field2", "test2");
        linkedHashMap.put("field3", "test3");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("field1", "label1");
        hashMap.put("field2", "label2");
        hashMap.put("field3", "labelt3");
        HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
        hashMap2.put("field1", true);
        hashMap2.put("field2", true);
        hashMap2.put("field3", true);
        RecordPane recordPane = new RecordPane(linkedHashMap, hashMap, null, hashMap2);
        recordPane.setObservableSubject(null);
        JDialog jDialog = new JDialog();
        jDialog.setSize(new Dimension(300, 300));
        jDialog.add(recordPane);
        jDialog.setModal(true);
        jDialog.setVisible(true);
    }

    protected class TheObservableSubject
    extends ObservableSubject {
        protected TheObservableSubject() {
        }

        @Override
        public void notifyObservers() {
            System.out.println("RecordPane: notifyObservers ");
        }
    }
}

