/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.swing;

import de.uib.utilities.swing.FEdit;
import java.awt.Component;
import java.awt.event.KeyEvent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FEditText
extends FEdit
implements DocumentListener {
    private JScrollPane scrollpane;
    private JTextArea textarea;
    private boolean singleLine;

    public FEditText(String string, String string2) {
        super(string, string2);
        this.initFEditText();
        this.setSingleLine(false);
    }

    public FEditText(String string) {
        super(string);
        this.initFEditText();
    }

    protected void initFEditText() {
        this.scrollpane = new JScrollPane();
        this.textarea = new JTextArea();
        this.scrollpane.setViewportView(this.textarea);
        this.editingArea.add((Component)this.scrollpane, "Center");
        this.textarea.setEditable(true);
        this.textarea.addKeyListener(this);
        this.textarea.getDocument().addDocumentListener(this);
        this.setStartText(this.initialText);
    }

    public void setSingleLine(boolean bl) {
        this.singleLine = bl;
        this.textarea.setLineWrap(!this.singleLine);
        this.textarea.setWrapStyleWord(!this.singleLine);
    }

    @Override
    public void setStartText(String string) {
        super.setStartText(string);
        this.textarea.setText(string);
    }

    @Override
    public String getText() {
        this.textarea.setText(this.textarea.getText().replaceAll("\t", ""));
        if (this.singleLine) {
            this.textarea.setText(this.textarea.getText().replaceAll("\n", ""));
        }
        this.initialText = this.textarea.getText();
        return this.initialText;
    }

    public void select(int n, int n2) {
        this.textarea.select(n, n2);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.textarea) {
            if ((keyEvent.getModifiersEx() & 0x40) == 64 && keyEvent.getKeyCode() == 9) {
                this.buttonCommit.requestFocusInWindow();
            } else if (keyEvent.getKeyCode() == 10 && this.singleLine) {
                this.commit();
            }
        }
        super.keyPressed(keyEvent);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.setDataChanged(true);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setDataChanged(true);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setDataChanged(true);
    }
}

