/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.swing;

import de.uib.configed.Globals;
import de.uib.utilities.logging.logging;
import de.uib.utilities.swing.FEditObject;
import de.uib.utilities.swing.list.StandardListCellRenderer;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.CellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class FEditList
extends FEditObject
implements ListSelectionListener,
ActionListener,
KeyListener,
MouseListener {
    private JScrollPane scrollpane;
    protected JList visibleList;
    private JTextComponent tracker;
    private ListModel initialModel;
    private List<Object> initiallySelected;
    protected Object selValue = "";
    protected JPopupMenu popup;
    private CellEditor celleditor;

    public FEditList() {
        this((JTextComponent)null);
    }

    public FEditList(JTextComponent jTextComponent) {
        this(jTextComponent, null);
    }

    public FEditList(JTextComponent jTextComponent, CellEditor cellEditor) {
        super("");
        this.tracker = jTextComponent;
        this.celleditor = cellEditor;
        this.visibleList = new JList();
        this.visibleList.setSelectionMode(0);
        this.visibleList.addListSelectionListener(this);
        this.visibleList.setCellRenderer(new StandardListCellRenderer());
        this.visibleList.addMouseListener(this);
        this.scrollpane = new JScrollPane();
        this.scrollpane.setViewportView(this.visibleList);
        this.editingArea.add((Component)this.scrollpane, "Center");
        this.editable = false;
        this.popup = new JPopupMenu();
        this.visibleList.setComponentPopupMenu(this.popup);
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.visibleList.addKeyListener(this);
    }

    public void setCellRenderer(ListCellRenderer listCellRenderer) {
        this.visibleList.setCellRenderer(listCellRenderer);
    }

    public void setListModel(ListModel listModel) {
        this.visibleList.setModel(listModel);
        this.initialModel = listModel;
    }

    public void setSelectionMode(int n) {
        this.visibleList.setSelectionMode(n);
    }

    @Override
    public void setEditable(boolean bl) {
        super.setEditable(bl);
        this.extraField.setVisible(bl);
        this.buttonRemove.setVisible(bl);
        this.buttonAdd.setVisible(bl);
    }

    protected Object getValueAt(Point point) {
        return this.visibleList.getModel().getElementAt(this.visibleList.locationToIndex(point));
    }

    protected void setExtraFieldToListValueAt(Point point) {
        String string = "" + this.getValueAt(point);
        this.extraField.setText(string);
        this.extraFieldChanged(false);
    }

    protected void addSelectedValues(List<Object> list) {
        if (list == null) {
            return;
        }
        ListModel listModel = this.visibleList.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            Object e = listModel.getElementAt(i);
            if (!list.contains(e)) continue;
            this.visibleList.addSelectionInterval(i, i);
        }
        this.visibleList.ensureIndexIsVisible(this.visibleList.getMaxSelectionIndex());
    }

    public void initSelection() {
        this.visibleList.setSelectedIndex(0);
    }

    public void setSelectedValues(List<Object> list) {
        this.initiallySelected = list;
        this.visibleList.clearSelection();
        this.addSelectedValues(list);
    }

    public void setSelectedValue(Object object) {
        this.visibleList.setSelectedValue(object, true);
    }

    private void addElementFromExtraField(Object object) {
        this.addElement(object);
        this.extraFieldChanged(false);
    }

    protected void addElement(Object object) {
        ListModel listModel = this.visibleList.getModel();
        if (listModel instanceof DefaultListModel) {
            if (!((DefaultListModel)listModel).contains(object)) {
                ((DefaultListModel)listModel).addElement(object);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(object);
                this.addSelectedValues(arrayList);
            }
        } else {
            logging.error(this, "for element adding required instance of DefaultListModel");
        }
    }

    @Override
    public Object getValue() {
        return this.getSelectedList();
    }

    private void setTracker(Object object) {
        if (this.tracker != null) {
            this.tracker.setText("" + object);
        }
    }

    @Override
    public void setStartValue(Object object) {
        super.setStartValue(object);
        this.setTracker(object);
    }

    @Override
    protected void cancel() {
        this.setListModel(this.initialModel);
        this.setSelectedValues(this.initiallySelected);
        super.cancel();
        if (this.celleditor != null) {
            this.celleditor.stopCellEditing();
        }
    }

    @Override
    protected void commit() {
        if (Globals.isReadOnly()) {
            this.cancel();
        } else {
            if (this.celleditor != null) {
                this.celleditor.stopCellEditing();
            }
            if (this.leaveOnCommit) {
                this.leave();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.buttonAdd) {
            this.addElementFromExtraField(this.extraField.getText());
        } else if (actionEvent.getSource() == this.buttonRemove) {
            this.visibleList.clearSelection();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        super.keyPressed(keyEvent);
        if (keyEvent.getSource() == this.buttonAdd) {
            this.addElementFromExtraField(this.extraField.getText());
        } else if (keyEvent.getSource() == this.buttonRemove) {
            this.visibleList.clearSelection();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            this.setExtraFieldToListValueAt(mouseEvent.getPoint());
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public boolean init() {
        this.setStartValue(this.selValue);
        return super.init();
    }

    public List getSelectedList() {
        ArrayList arrayList = new ArrayList();
        ListModel listModel = this.visibleList.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            Object e = listModel.getElementAt(i);
            if (!this.visibleList.isSelectedIndex(i)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        List list = this.getSelectedList();
        this.setDataChanged(true);
        this.setTracker(list);
        this.buttonRemove.setEnabled(list.size() > 0);
    }
}

