/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class ClippedTitleTabbedPane
extends JTabbedPane {
    private double proportionOfTotalWidth = 1.0;

    private int calcWidth() {
        return (int)((double)this.getWidth() * this.proportionOfTotalWidth);
    }

    public void setProportionOfTotalWidth(double d) {
        this.proportionOfTotalWidth = d;
    }

    public ClippedTitleTabbedPane() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ClippedTitleTabbedPane.this.initTabWidth();
            }
        });
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ClippedTitleTabbedPane.this.initTabWidth();
            }
        });
    }

    private Insets getTabInsets() {
        Insets insets = UIManager.getInsets("TabbedPane.tabInsets");
        if (insets != null) {
            return insets;
        }
        SynthStyle synthStyle = SynthLookAndFeel.getStyle(this, Region.TABBED_PANE_TAB);
        SynthContext synthContext = new SynthContext(this, Region.TABBED_PANE_TAB, synthStyle, 1);
        return synthStyle.getInsets(synthContext, null);
    }

    private Insets getTabAreaInsets() {
        Insets insets = UIManager.getInsets("TabbedPane.tabAreaInsets");
        if (insets != null) {
            return insets;
        }
        SynthStyle synthStyle = SynthLookAndFeel.getStyle(this, Region.TABBED_PANE_TAB_AREA);
        SynthContext synthContext = new SynthContext(this, Region.TABBED_PANE_TAB_AREA, synthStyle, 1);
        return synthStyle.getInsets(synthContext, null);
    }

    @Override
    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        super.insertTab(string, icon, component, string2 == null ? string : string2, n);
        JLabel jLabel = new JLabel(string, 0);
        Dimension dimension = jLabel.getPreferredSize();
        Insets insets = this.getTabInsets();
        jLabel.setPreferredSize(new Dimension(0, dimension.height + insets.top + insets.bottom));
        this.setTabComponentAt(n, jLabel);
        this.initTabWidth();
    }

    public void initTabWidth() {
        JLabel jLabel;
        Insets insets = this.getTabInsets();
        Insets insets2 = this.getTabAreaInsets();
        Insets insets3 = this.getInsets();
        int n = this.calcWidth() - insets2.left - insets2.right - insets3.left - insets3.right;
        int n2 = this.getTabCount();
        int n3 = 0;
        int n4 = 0;
        switch (this.getTabPlacement()) {
            case 2: 
            case 4: {
                n3 = n / 4;
                n4 = 0;
                break;
            }
            default: {
                n3 = n / n2;
                n4 = n - n3 * n2;
            }
        }
        n3 = n3 - insets.left - insets.right - 3;
        for (int i = 0; i < n2 && (jLabel = (JLabel)this.getTabComponentAt(i)) != null; ++i) {
            jLabel.setPreferredSize(new Dimension(n3 + (i < n4 ? 1 : 0), jLabel.getPreferredSize().height));
        }
        this.revalidate();
    }
}

