/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.script;

import de.uib.utilities.logging.logging;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Interpreter {
    protected LinkedHashMap<String, Object> specialValues;
    private String command;

    public Interpreter(String[] stringArray) {
        this.initSpecialValues(stringArray);
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public static List<String> splitToList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = " \t\n\r\f";
        String string3 = "'\"";
        String string4 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2 + string3, true);
        StringBuffer stringBuffer = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            if (string3.indexOf(string5) > -1) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                    string4 = string5;
                    continue;
                }
                if (string5.equals(string4)) {
                    arrayList.add(stringBuffer.toString());
                    stringBuffer = null;
                    continue;
                }
                stringBuffer.append(string5);
                continue;
            }
            if (string2.indexOf(string5) > -1) {
                if (stringBuffer == null) continue;
                stringBuffer.append(string5);
                continue;
            }
            if (stringBuffer == null) {
                arrayList.add(string5);
                continue;
            }
            stringBuffer.append(string5);
        }
        if (stringBuffer != null) {
            arrayList.add(stringBuffer.toString());
        }
        return arrayList;
    }

    public static String[] splitToStringArr(String string) {
        return Interpreter.splitToList(string).toArray(new String[0]);
    }

    protected void initSpecialValues(String[] stringArray) {
        this.specialValues = new LinkedHashMap();
        for (int i = 0; i < stringArray.length; ++i) {
            this.specialValues.put(stringArray[i], "");
        }
    }

    public void setValues(Map<String, Object> map) {
        for (String string : map.keySet()) {
            if (this.specialValues.get(string) == null) {
                logging.warning(this, "value set for an unknown key");
                continue;
            }
            this.specialValues.put(string, "" + map.get(string));
        }
    }

    public String interpret() {
        for (String string : this.specialValues.keySet()) {
            logging.debug(this, "interpret: replace " + string + " by " + this.specialValues.get(string));
            this.command = this.command.replace(string, (String)this.specialValues.get(string));
        }
        logging.debug(this, "produced command " + this.command);
        return this.command;
    }
}

