/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.observer;

import de.uib.utilities.observer.ObservableSubject;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DataEditListener
implements DocumentListener,
ItemListener,
KeyListener {
    public static final String commitRequest = "COMMIT";
    public static final String cancelRequest = "CANCEL";
    protected Object source;
    protected ObservableSubject dataChangedSubject;
    protected boolean withFocusCheck = true;

    protected void act() {
        if (this.dataChangedSubject == null) {
            return;
        }
        if (!this.withFocusCheck || this.source instanceof JComponent && ((JComponent)this.source).hasFocus()) {
            this.dataChangedSubject.setChanged();
            this.dataChangedSubject.notifyObservers();
        }
    }

    protected void requestAction(String string) {
        if (this.dataChangedSubject == null) {
            return;
        }
        if ((!this.withFocusCheck || this.source instanceof JComponent && ((JComponent)this.source).hasFocus()) && !string.equals(cancelRequest) && !string.equals(commitRequest)) {
            this.dataChangedSubject.setChanged();
            this.dataChangedSubject.notifyObservers(string);
        }
    }

    public DataEditListener(ObservableSubject observableSubject, Object object, boolean bl) {
        this.source = object;
        this.withFocusCheck = bl;
        this.dataChangedSubject = observableSubject;
    }

    public DataEditListener(ObservableSubject observableSubject, Object object) {
        this(observableSubject, object, true);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.act();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.act();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.act();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.act();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.requestAction(commitRequest);
        } else if (keyEvent.getKeyCode() == 27) {
            this.requestAction(cancelRequest);
        } else if (!keyEvent.isActionKey()) {
            this.act();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

