/*
 * Decompiled with CFR 0.152.
 */
package de.uib.opsidatamodel.productstate;

import de.uib.configed.Globals;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class InstallationStatus {
    public static final String KEY = "installationStatus";
    public static final int CONFLICT = -4;
    public static final int INVALID = -2;
    public static final int UNDEFINED = -1;
    public static final int NOT_INSTALLED = 0;
    public static final int INSTALLED = 1;
    public static final int UNKNOWN = 2;
    public static final int FAILED = 4;
    public static final Color NOT_INSTALLEDcolor = Globals.INVISIBLE;
    public static final Color INSTALLEDcolor = Globals.okGreen;
    public static final Color UNKNOWNcolor = Globals.unknownBlue;
    private static Map<Integer, String> state2label;
    private static Map<String, Integer> label2state;
    private static Map<String, String> label2displayLabel;
    private static Map<String, String> displayLabel2label;
    private static Map<String, Color> label2textColor;
    private static Vector<Integer> states;
    private static Vector<String> labels;
    private static String[] choiceLabels;
    private int state = -2;

    private static void checkCollections() {
        if (states != null) {
            return;
        }
        states = new Vector();
        states.add(-4);
        states.add(-2);
        states.add(-1);
        states.add(1);
        states.add(0);
        states.add(4);
        states.add(2);
        labels = new Vector();
        labels.add("mixed");
        labels.add("");
        labels.add("undefined");
        labels.add("installed");
        labels.add("not_installed");
        labels.add("failed");
        labels.add("unknown");
        state2label = new HashMap<Integer, String>();
        state2label.put(-4, "mixed");
        state2label.put(-2, "");
        state2label.put(-1, "undefined");
        state2label.put(1, "installed");
        state2label.put(0, "not_installed");
        state2label.put(4, "failed");
        state2label.put(2, "unknown");
        label2state = new HashMap<String, Integer>();
        label2state.put("mixed", -4);
        label2state.put("", -2);
        label2state.put("undefined", -1);
        label2state.put("installed", 1);
        label2state.put("not_installed", 0);
        label2state.put("failed", 4);
        label2state.put("unknown", 2);
        label2displayLabel = new HashMap<String, String>();
        label2displayLabel.put("mixed", "mixed");
        label2displayLabel.put("", "");
        label2displayLabel.put("undefined", "undefined");
        label2displayLabel.put("installed", "installed");
        label2displayLabel.put("not_installed", "not_installed");
        label2displayLabel.put("failed", "failed");
        label2displayLabel.put("unknown", "unknown");
        displayLabel2label = new HashMap<String, String>();
        displayLabel2label.put("mixed", "mixed");
        displayLabel2label.put("", "");
        displayLabel2label.put("undefined", "undefined");
        displayLabel2label.put("installed", "installed");
        displayLabel2label.put("not_installed", "not_installed");
        displayLabel2label.put("failed", "failed");
        displayLabel2label.put("unknown", "unknown");
        choiceLabels = new String[]{label2displayLabel.get("not_installed"), label2displayLabel.get("installed"), label2displayLabel.get("unknown")};
        label2textColor = new HashMap<String, Color>();
        label2textColor.put("not_installed", NOT_INSTALLEDcolor);
        label2textColor.put("installed", INSTALLEDcolor);
        label2textColor.put("unknown", UNKNOWNcolor);
    }

    public static Map<String, String> getLabel2DisplayLabel() {
        InstallationStatus.checkCollections();
        return label2displayLabel;
    }

    public static Map<String, Color> getLabel2TextColor() {
        InstallationStatus.checkCollections();
        return label2textColor;
    }

    public static boolean existsState(int n) {
        InstallationStatus.checkCollections();
        return states.contains(n);
    }

    public static boolean existsLabel(String string) {
        InstallationStatus.checkCollections();
        return labels.contains(string);
    }

    public static String getLabel(int n) {
        InstallationStatus.checkCollections();
        if (!InstallationStatus.existsState(n)) {
            return null;
        }
        return state2label.get(n);
    }

    public static Vector<String> getLabels() {
        InstallationStatus.checkCollections();
        return labels;
    }

    public static Integer getVal(String string) {
        InstallationStatus.checkCollections();
        if (string == null || string.equals("")) {
            return 2;
        }
        if (!InstallationStatus.existsLabel(string)) {
            return null;
        }
        return label2state.get(string);
    }

    public static String getDisplayLabel(int n) {
        InstallationStatus.checkCollections();
        return label2displayLabel.get(InstallationStatus.getLabel(n));
    }

    public static final String[] getDisplayLabelsForChoice() {
        InstallationStatus.checkCollections();
        return choiceLabels;
    }

    public int getVal() {
        return this.state;
    }

    public String getString() {
        return InstallationStatus.getLabel(this.state);
    }

    public String toString() {
        return InstallationStatus.getLabel(this.state);
    }

    public static InstallationStatus produceFromDisplayLabel(String string) {
        return InstallationStatus.produceFromLabel(displayLabel2label.get(string));
    }

    public static InstallationStatus produceFromLabel(String string) {
        InstallationStatus.checkCollections();
        if (string == null) {
            return new InstallationStatus(-2);
        }
        if (!labels.contains(string)) {
            return new InstallationStatus(-2);
        }
        return new InstallationStatus(InstallationStatus.getVal(string));
    }

    public InstallationStatus() {
    }

    public InstallationStatus(int n) {
        this.state = InstallationStatus.existsState(n) ? n : -2;
    }

    public static void main(String[] stringArray) {
        InstallationStatus.checkCollections();
        Iterator<Integer> iterator = states.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ++n;
            int n2 = iterator.next();
        }
    }
}

