/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.gui;

import de.uib.configed.Globals;
import de.uib.utilities.logging.logging;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;

public class DepotsList
extends JList
implements ComponentListener {
    MyListCellRenderer myListCellRenderer;
    private Vector saveV;

    public DepotsList() {
        this.setBackground(Globals.backgroundWhite);
        this.setSelectionBackground(Globals.defaultTableCellSelectedBgColor);
        this.setSelectionForeground(Color.black);
        this.setSelectionMode(2);
        this.myListCellRenderer = new MyListCellRenderer();
        this.setCellRenderer(this.myListCellRenderer);
    }

    public void setInfo(Map<String, Map<String, Object>> map) {
        this.myListCellRenderer.setInfo(map);
    }

    public void setListData(Vector vector) {
        super.setListData(vector);
        this.saveV = vector;
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.ensureIndexIsVisible(this.getSelectedIndex());
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.ensureIndexIsVisible(this.getSelectedIndex());
    }

    private int getIndexOf(Object object) {
        return this.saveV.indexOf(object);
    }

    public void selectAll() {
        this.getSelectionModel().setValueIsAdjusting(true);
        this.setSelectionInterval(0, this.getModel().getSize() - 1);
        this.getSelectionModel().setValueIsAdjusting(false);
    }

    public void addToSelection(List<String> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        this.getSelectionModel().setValueIsAdjusting(true);
        for (String string : list) {
            int n = this.getIndexOf(string);
            if (n <= -1) continue;
            this.addSelectionInterval(n, n);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
    }

    class MyListCellRenderer
    extends DefaultListCellRenderer {
        protected int FILL_LENGTH = 30;
        Map<String, Map<String, Object>> extendedInfo;

        public void setInfo(Map<String, Map<String, Object>> map) {
            logging.debug(this, "setInfo " + map);
            this.extendedInfo = map;
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (component == null || !(component instanceof JComponent)) {
                return component;
            }
            JComponent jComponent = (JComponent)component;
            if (jComponent instanceof JLabel) {
                String string = null;
                String string2 = "";
                if (object != null) {
                    string2 = "" + object;
                }
                string = this.extendedInfo != null && this.extendedInfo.get(string2) != null && this.extendedInfo.get(string2).get("description") != null && !("" + this.extendedInfo.get(string2).get("description")).equals("") ? "" + this.extendedInfo.get(object).get("description") : string2;
                string = Globals.fillStringToLength(string + " ", this.FILL_LENGTH);
                ((JLabel)jComponent).setToolTipText(string);
            }
            return jComponent;
        }
    }
}

