/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.clientselection.serializers;

import de.uib.utilities.logging.logging;
import java.io.IOException;
import java.io.StringReader;
import java.util.Deque;
import java.util.LinkedList;

class JsonParser {
    private StringReader reader;
    private PositionType currentPosition = PositionType.JsonValue;
    private String currentValue = null;
    private boolean inList = false;
    Deque<PositionType> stack;

    public JsonParser(String string) {
        this.reader = new StringReader(string);
        this.stack = new LinkedList<PositionType>();
    }

    public boolean next() throws IOException {
        char c;
        while (true) {
            int n;
            if ((n = this.reader.read()) == -1) {
                return false;
            }
            logging.debug(this, (char)n + " " + this.currentPosition.toString());
            this.managePosition();
            c = (char)n;
            if (Character.isWhitespace(c)) continue;
            if (c == ':' && this.currentPosition == PositionType.JsonName) {
                this.currentPosition = PositionType.JsonValue;
                continue;
            }
            if (c != ',' || this.currentPosition != PositionType.JsonValue) break;
            if (this.inList) continue;
            this.currentPosition = PositionType.JsonName;
        }
        if (c == '{' && this.currentPosition == PositionType.JsonValue) {
            this.currentPosition = PositionType.ObjectBegin;
            this.inList = false;
            return true;
        }
        if (c == '}' && this.currentPosition == PositionType.JsonValue) {
            this.currentPosition = PositionType.ObjectEnd;
            return true;
        }
        if (c == '[' && this.currentPosition == PositionType.JsonValue) {
            this.currentPosition = PositionType.ListBegin;
            this.inList = true;
            return true;
        }
        if (c == ']' && this.currentPosition == PositionType.JsonValue) {
            this.currentPosition = PositionType.ListEnd;
            this.inList = false;
            return true;
        }
        if (!(c != '\"' && !Character.isLetter(c) || this.currentPosition != PositionType.JsonValue && this.currentPosition != PositionType.JsonName)) {
            this.currentValue = this.getNextValue(c);
            return true;
        }
        throw new IllegalArgumentException("Unexpected character: " + c);
    }

    public PositionType getPositionType() {
        return this.currentPosition;
    }

    public String getValue() {
        return this.currentValue;
    }

    private String getNextValue(char c) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(c);
        int n = this.reader.read();
        if (c == '\"') {
            while (n != -1 && (char)n != '\"') {
                stringBuilder.append((char)n);
                n = this.reader.read();
            }
            if (n == -1) {
                throw new IllegalArgumentException("Unexpected EOF");
            }
            stringBuilder.append((char)n);
            return stringBuilder.toString();
        }
        while (n != -1 && (Character.isLetterOrDigit((char)n) || (char)n == '.')) {
            stringBuilder.append((char)n);
            n = this.reader.read();
        }
        this.reader.skip(-1L);
        return stringBuilder.toString();
    }

    private void managePosition() {
        if (this.currentPosition == PositionType.ObjectBegin) {
            this.stack.push(PositionType.ObjectBegin);
            this.currentPosition = PositionType.JsonName;
        } else if (this.currentPosition == PositionType.ListBegin) {
            this.stack.push(PositionType.ListBegin);
            this.currentPosition = PositionType.JsonValue;
        } else if (this.currentPosition == PositionType.ObjectEnd || this.currentPosition == PositionType.ListEnd) {
            this.stack.pop();
            this.currentPosition = this.stack.peek();
            logging.debug(this, "managePosition: " + this.currentPosition.toString());
            this.inList = this.currentPosition != PositionType.ObjectBegin;
            this.currentPosition = PositionType.JsonValue;
        }
    }

    public static enum PositionType {
        ObjectBegin,
        ObjectEnd,
        ListBegin,
        ListEnd,
        JsonName,
        JsonValue;

    }
}

