/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.clientselection;

import de.uib.configed.clientselection.SelectionManager;
import de.uib.messages.Messages;
import de.uib.opsidatamodel.PersistenceController;
import de.uib.opsidatamodel.PersistenceControllerFactory;
import de.uib.utilities.logging.logging;
import java.util.List;
import java.util.Map;

public class SavedSearchQuery {
    private final String usage = "\nconfiged_savedsearch [OPTIONS] [NAME]\n\nRuns the given search NAME and returns the matching clients. If NAME is not set, list all available searches.\n\nOPTIONS:\n  -h\tConfiguration server to connect to\n  -u\tUsername for authentication\n  -p\tPassword for authentication\n";
    private String[] args;
    private String host;
    private String user;
    private String password;
    private String search;

    public SavedSearchQuery() {
        logging.wantedDirectory = "";
        logging.setAktDebugLevel(-1);
    }

    public SavedSearchQuery(String[] stringArray) {
        this();
        this.args = stringArray;
        if (!this.parseArgs()) {
            this.showUsage();
            System.exit(10);
        }
    }

    public boolean parseArgs() {
        String string = null;
        this.search = null;
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i].equals("-h") || this.args[i].equals("-u") || this.args[i].equals("-p")) {
                if (string != null) {
                    return false;
                }
                string = this.args[i];
                continue;
            }
            if (string != null) {
                this.addInfo(string.trim(), this.args[i]);
                string = null;
                continue;
            }
            if (this.search != null) {
                return false;
            }
            this.search = this.args[i];
        }
        return true;
    }

    public void showUsage() {
        System.out.println("\nconfiged_savedsearch [OPTIONS] [NAME]\n\nRuns the given search NAME and returns the matching clients. If NAME is not set, list all available searches.\n\nOPTIONS:\n  -h\tConfiguration server to connect to\n  -u\tUsername for authentication\n  -p\tPassword for authentication\n");
    }

    public void setArgs(String string, String string2, String string3, String string4) {
        this.host = string;
        this.user = string2;
        this.password = string3;
        this.search = string4;
    }

    public void addMissingArgs() {
        if (this.host == null) {
            this.host = this.getInfo("Host: ", false);
        }
        if (this.user == null) {
            this.user = this.getInfo("User: ", false);
        }
        if (this.password == null) {
            this.password = this.getInfo("Password: ", true);
        }
    }

    public void runSearch() {
        Messages.setLocale("en");
        PersistenceController persistenceController = PersistenceControllerFactory.getNewPersistenceController(this.host, this.user, this.password);
        if (persistenceController == null) {
            System.err.println("Authentication error.");
            System.exit(1);
        }
        if (persistenceController.getConnectionState().getState() != 3) {
            System.err.println("Authentication error.");
            System.exit(1);
        }
        Map<String, Map<String, Object>> map = persistenceController.getHostInfoCollections().getAllDepots();
        persistenceController.getHostInfoCollections().getPcListForDepots(map.keySet().toArray(new String[0]));
        SelectionManager selectionManager = new SelectionManager(null);
        List<String> list = selectionManager.getSavedSearchesNames();
        if (this.search == null) {
            this.printResult(list);
            return;
        }
        if (!list.contains(this.search)) {
            System.err.println("Search not found.");
            System.exit(2);
        }
        selectionManager.loadSearch(this.search);
        this.printResult(selectionManager.selectClients());
    }

    public static void main(String[] stringArray) {
        SavedSearchQuery savedSearchQuery = new SavedSearchQuery(stringArray);
        if (!savedSearchQuery.parseArgs()) {
            savedSearchQuery.showUsage();
            System.exit(10);
        }
        savedSearchQuery.addMissingArgs();
        savedSearchQuery.runSearch();
    }

    private void addInfo(String string, String string2) {
        if (string.equals("-h")) {
            this.host = string2;
        } else if (string.equals("-u")) {
            this.user = string2;
        } else if (string.equals("-p")) {
            this.password = string2;
        } else {
            throw new IllegalArgumentException("Unknown option " + string);
        }
    }

    private String getInfo(String string, boolean bl) {
        if (System.console() == null) {
            return "";
        }
        System.out.print(string);
        if (bl) {
            return String.valueOf(System.console().readPassword()).trim();
        }
        return String.valueOf(System.console().readLine()).trim();
    }

    private void printResult(List<String> list) {
        for (String string : list) {
            System.out.println(string);
        }
    }
}

