package sbinary;

import Operations._;
import scala.collection._;
import generic.CanBuildFrom

trait BasicTypes extends CoreProtocol{
  implicit def optionsAreFormat[S](implicit bin : Format[S]) : Format[Option[S]] = new Format[Option[S]]{
    def reads(in : Input) = read[Byte](in) match {
      case 1 => Some(read[S](in));
      case 0 => None
    }

    def writes(out : Output, s : Option[S]) = s match {
      case Some(x) => { write[Byte](out, 1); write(out, x) }
      case None => write[Byte](out, 0);
    }
  }

  implicit def tuple2Format[T1,T2](implicit 
      bin1 : Format[T1] ,
      bin2 : Format[T2] 
    ) : Format[   Tuple2[T1 ,T2 ]
] = new Format[   Tuple2[T1 ,T2 ]
]{
      def reads (in : Input) :    Tuple2[T1 ,T2 ]
 = ( 
        read[T1](in),
        read[T2](in)
      )
    
      def writes(out : Output, tuple :    Tuple2[T1 ,T2 ]
) = {
        write(out, tuple._1);      
              write(out, tuple._2);      
      ;
      }
  }
  implicit def tuple3Format[T1,T2,T3](implicit 
      bin1 : Format[T1] ,
      bin2 : Format[T2] ,
      bin3 : Format[T3] 
    ) : Format[   Tuple3[T1 ,T2 ,T3 ]
] = new Format[   Tuple3[T1 ,T2 ,T3 ]
]{
      def reads (in : Input) :    Tuple3[T1 ,T2 ,T3 ]
 = ( 
        read[T1](in),
        read[T2](in),
        read[T3](in)
      )
    
      def writes(out : Output, tuple :    Tuple3[T1 ,T2 ,T3 ]
) = {
        write(out, tuple._1);      
              write(out, tuple._2);      
              write(out, tuple._3);      
      ;
      }
  }
  implicit def tuple4Format[T1,T2,T3,T4](implicit 
      bin1 : Format[T1] ,
      bin2 : Format[T2] ,
      bin3 : Format[T3] ,
      bin4 : Format[T4] 
    ) : Format[   Tuple4[T1 ,T2 ,T3 ,T4 ]
] = new Format[   Tuple4[T1 ,T2 ,T3 ,T4 ]
]{
      def reads (in : Input) :    Tuple4[T1 ,T2 ,T3 ,T4 ]
 = ( 
        read[T1](in),
        read[T2](in),
        read[T3](in),
        read[T4](in)
      )
    
      def writes(out : Output, tuple :    Tuple4[T1 ,T2 ,T3 ,T4 ]
) = {
        write(out, tuple._1);      
              write(out, tuple._2);      
              write(out, tuple._3);      
              write(out, tuple._4);      
      ;
      }
  }
  implicit def tuple5Format[T1,T2,T3,T4,T5](implicit 
      bin1 : Format[T1] ,
      bin2 : Format[T2] ,
      bin3 : Format[T3] ,
      bin4 : Format[T4] ,
      bin5 : Format[T5] 
    ) : Format[   Tuple5[T1 ,T2 ,T3 ,T4 ,T5 ]
] = new Format[   Tuple5[T1 ,T2 ,T3 ,T4 ,T5 ]
]{
      def reads (in : Input) :    Tuple5[T1 ,T2 ,T3 ,T4 ,T5 ]
 = ( 
        read[T1](in),
        read[T2](in),
        read[T3](in),
        read[T4](in),
        read[T5](in)
      )
    
      def writes(out : Output, tuple :    Tuple5[T1 ,T2 ,T3 ,T4 ,T5 ]
) = {
        write(out, tuple._1);      
              write(out, tuple._2);      
              write(out, tuple._3);      
              write(out, tuple._4);      
              write(out, tuple._5);      
      ;
      }
  }
  implicit def tuple6Format[T1,T2,T3,T4,T5,T6](implicit 
      bin1 : Format[T1] ,
      bin2 : Format[T2] ,
      bin3 : Format[T3] ,
      bin4 : Format[T4] ,
      bin5 : Format[T5] ,
      bin6 : Format[T6] 
    ) : Format[   Tuple6[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ]
] = new Format[   Tuple6[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ]
]{
      def reads (in : Input) :    Tuple6[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ]
 = ( 
        read[T1](in),
        read[T2](in),
        read[T3](in),
        read[T4](in),
        read[T5](in),
        read[T6](in)
      )
    
      def writes(out : Output, tuple :    Tuple6[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ]
) = {
        write(out, tuple._1);      
              write(out, tuple._2);      
              write(out, tuple._3);      
              write(out, tuple._4);      
              write(out, tuple._5);      
              write(out, tuple._6);      
      ;
      }
  }
  implicit def tuple7Format[T1,T2,T3,T4,T5,T6,T7](implicit 
      bin1 : Format[T1] ,
      bin2 : Format[T2] ,
      bin3 : Format[T3] ,
      bin4 : Format[T4] ,
      bin5 : Format[T5] ,
      bin6 : Format[T6] ,
      bin7 : Format[T7] 
    ) : Format[   Tuple7[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ]
] = new Format[   Tuple7[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ]
]{
      def reads (in : Input) :    Tuple7[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ]
 = ( 
        read[T1](in),
        read[T2](in),
        read[T3](in),
        read[T4](in),
        read[T5](in),
        read[T6](in),
        read[T7](in)
      )
    
      def writes(out : Output, tuple :    Tuple7[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ]
) = {
        write(out, tuple._1);      
              write(out, tuple._2);      
              write(out, tuple._3);      
              write(out, tuple._4);      
              write(out, tuple._5);      
              write(out, tuple._6);      
              write(out, tuple._7);      
      ;
      }
  }
  implicit def tuple8Format[T1,T2,T3,T4,T5,T6,T7,T8](implicit 
      bin1 : Format[T1] ,
      bin2 : Format[T2] ,
      bin3 : Format[T3] ,
      bin4 : Format[T4] ,
      bin5 : Format[T5] ,
      bin6 : Format[T6] ,
      bin7 : Format[T7] ,
      bin8 : Format[T8] 
    ) : Format[   Tuple8[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ]
] = new Format[   Tuple8[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ]
]{
      def reads (in : Input) :    Tuple8[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ]
 = ( 
        read[T1](in),
        read[T2](in),
        read[T3](in),
        read[T4](in),
        read[T5](in),
        read[T6](in),
        read[T7](in),
        read[T8](in)
      )
    
      def writes(out : Output, tuple :    Tuple8[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ]
) = {
        write(out, tuple._1);      
              write(out, tuple._2);      
              write(out, tuple._3);      
              write(out, tuple._4);      
              write(out, tuple._5);      
              write(out, tuple._6);      
              write(out, tuple._7);      
              write(out, tuple._8);      
      ;
      }
  }
  implicit def tuple9Format[T1,T2,T3,T4,T5,T6,T7,T8,T9](implicit 
      bin1 : Format[T1] ,
      bin2 : Format[T2] ,
      bin3 : Format[T3] ,
      bin4 : Format[T4] ,
      bin5 : Format[T5] ,
      bin6 : Format[T6] ,
      bin7 : Format[T7] ,
      bin8 : Format[T8] ,
      bin9 : Format[T9] 
    ) : Format[   Tuple9[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ]
] = new Format[   Tuple9[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ]
]{
      def reads (in : Input) :    Tuple9[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ]
 = ( 
        read[T1](in),
        read[T2](in),
        read[T3](in),
        read[T4](in),
        read[T5](in),
        read[T6](in),
        read[T7](in),
        read[T8](in),
        read[T9](in)
      )
    
      def writes(out : Output, tuple :    Tuple9[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ]
) = {
        write(out, tuple._1);      
              write(out, tuple._2);      
              write(out, tuple._3);      
              write(out, tuple._4);      
              write(out, tuple._5);      
              write(out, tuple._6);      
              write(out, tuple._7);      
              write(out, tuple._8);      
              write(out, tuple._9);      
      ;
      }
  }
  implicit def tuple10Format[T1,T2,T3,T4,T5,T6,T7,T8,T9,T10](implicit 
      bin1 : Format[T1] ,
      bin2 : Format[T2] ,
      bin3 : Format[T3] ,
      bin4 : Format[T4] ,
      bin5 : Format[T5] ,
      bin6 : Format[T6] ,
      bin7 : Format[T7] ,
      bin8 : Format[T8] ,
      bin9 : Format[T9] ,
      bin10 : Format[T10] 
    ) : Format[   Tuple10[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ]
] = new Format[   Tuple10[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ]
]{
      def reads (in : Input) :    Tuple10[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ]
 = ( 
        read[T1](in),
        read[T2](in),
        read[T3](in),
        read[T4](in),
        read[T5](in),
        read[T6](in),
        read[T7](in),
        read[T8](in),
        read[T9](in),
        read[T10](in)
      )
    
      def writes(out : Output, tuple :    Tuple10[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ]
) = {
        write(out, tuple._1);      
              write(out, tuple._2);      
              write(out, tuple._3);      
              write(out, tuple._4);      
              write(out, tuple._5);      
              write(out, tuple._6);      
              write(out, tuple._7);      
              write(out, tuple._8);      
              write(out, tuple._9);      
              write(out, tuple._10);      
      ;
      }
  }
  implicit def tuple11Format[T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11](implicit 
      bin1 : Format[T1] ,
      bin2 : Format[T2] ,
      bin3 : Format[T3] ,
      bin4 : Format[T4] ,
      bin5 : Format[T5] ,
      bin6 : Format[T6] ,
      bin7 : Format[T7] ,
      bin8 : Format[T8] ,
      bin9 : Format[T9] ,
      bin10 : Format[T10] ,
      bin11 : Format[T11] 
    ) : Format[   Tuple11[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ]
] = new Format[   Tuple11[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ]
]{
      def reads (in : Input) :    Tuple11[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ]
 = ( 
        read[T1](in),
        read[T2](in),
        read[T3](in),
        read[T4](in),
        read[T5](in),
        read[T6](in),
        read[T7](in),
        read[T8](in),
        read[T9](in),
        read[T10](in),
        read[T11](in)
      )
    
      def writes(out : Output, tuple :    Tuple11[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ]
) = {
        write(out, tuple._1);      
              write(out, tuple._2);      
              write(out, tuple._3);      
              write(out, tuple._4);      
              write(out, tuple._5);      
              write(out, tuple._6);      
              write(out, tuple._7);      
              write(out, tuple._8);      
              write(out, tuple._9);      
              write(out, tuple._10);      
              write(out, tuple._11);      
      ;
      }
  }
  implicit def tuple12Format[T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12](implicit 
      bin1 : Format[T1] ,
      bin2 : Format[T2] ,
      bin3 : Format[T3] ,
      bin4 : Format[T4] ,
      bin5 : Format[T5] ,
      bin6 : Format[T6] ,
      bin7 : Format[T7] ,
      bin8 : Format[T8] ,
      bin9 : Format[T9] ,
      bin10 : Format[T10] ,
      bin11 : Format[T11] ,
      bin12 : Format[T12] 
    ) : Format[   Tuple12[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ]
] = new Format[   Tuple12[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ]
]{
      def reads (in : Input) :    Tuple12[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ]
 = ( 
        read[T1](in),
        read[T2](in),
        read[T3](in),
        read[T4](in),
        read[T5](in),
        read[T6](in),
        read[T7](in),
        read[T8](in),
        read[T9](in),
        read[T10](in),
        read[T11](in),
        read[T12](in)
      )
    
      def writes(out : Output, tuple :    Tuple12[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ]
) = {
        write(out, tuple._1);      
              write(out, tuple._2);      
              write(out, tuple._3);      
              write(out, tuple._4);      
              write(out, tuple._5);      
              write(out, tuple._6);      
              write(out, tuple._7);      
              write(out, tuple._8);      
              write(out, tuple._9);      
              write(out, tuple._10);      
              write(out, tuple._11);      
              write(out, tuple._12);      
      ;
      }
  }
  implicit def tuple13Format[T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13](implicit 
      bin1 : Format[T1] ,
      bin2 : Format[T2] ,
      bin3 : Format[T3] ,
      bin4 : Format[T4] ,
      bin5 : Format[T5] ,
      bin6 : Format[T6] ,
      bin7 : Format[T7] ,
      bin8 : Format[T8] ,
      bin9 : Format[T9] ,
      bin10 : Format[T10] ,
      bin11 : Format[T11] ,
      bin12 : Format[T12] ,
      bin13 : Format[T13] 
    ) : Format[   Tuple13[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ]
] = new Format[   Tuple13[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ]
]{
      def reads (in : Input) :    Tuple13[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ]
 = ( 
        read[T1](in),
        read[T2](in),
        read[T3](in),
        read[T4](in),
        read[T5](in),
        read[T6](in),
        read[T7](in),
        read[T8](in),
        read[T9](in),
        read[T10](in),
        read[T11](in),
        read[T12](in),
        read[T13](in)
      )
    
      def writes(out : Output, tuple :    Tuple13[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ]
) = {
        write(out, tuple._1);      
              write(out, tuple._2);      
              write(out, tuple._3);      
              write(out, tuple._4);      
              write(out, tuple._5);      
              write(out, tuple._6);      
              write(out, tuple._7);      
              write(out, tuple._8);      
              write(out, tuple._9);      
              write(out, tuple._10);      
              write(out, tuple._11);      
              write(out, tuple._12);      
              write(out, tuple._13);      
      ;
      }
  }
  implicit def tuple14Format[T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14](implicit 
      bin1 : Format[T1] ,
      bin2 : Format[T2] ,
      bin3 : Format[T3] ,
      bin4 : Format[T4] ,
      bin5 : Format[T5] ,
      bin6 : Format[T6] ,
      bin7 : Format[T7] ,
      bin8 : Format[T8] ,
      bin9 : Format[T9] ,
      bin10 : Format[T10] ,
      bin11 : Format[T11] ,
      bin12 : Format[T12] ,
      bin13 : Format[T13] ,
      bin14 : Format[T14] 
    ) : Format[   Tuple14[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ]
] = new Format[   Tuple14[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ]
]{
      def reads (in : Input) :    Tuple14[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ]
 = ( 
        read[T1](in),
        read[T2](in),
        read[T3](in),
        read[T4](in),
        read[T5](in),
        read[T6](in),
        read[T7](in),
        read[T8](in),
        read[T9](in),
        read[T10](in),
        read[T11](in),
        read[T12](in),
        read[T13](in),
        read[T14](in)
      )
    
      def writes(out : Output, tuple :    Tuple14[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ]
) = {
        write(out, tuple._1);      
              write(out, tuple._2);      
              write(out, tuple._3);      
              write(out, tuple._4);      
              write(out, tuple._5);      
              write(out, tuple._6);      
              write(out, tuple._7);      
              write(out, tuple._8);      
              write(out, tuple._9);      
              write(out, tuple._10);      
              write(out, tuple._11);      
              write(out, tuple._12);      
              write(out, tuple._13);      
              write(out, tuple._14);      
      ;
      }
  }
  implicit def tuple15Format[T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15](implicit 
      bin1 : Format[T1] ,
      bin2 : Format[T2] ,
      bin3 : Format[T3] ,
      bin4 : Format[T4] ,
      bin5 : Format[T5] ,
      bin6 : Format[T6] ,
      bin7 : Format[T7] ,
      bin8 : Format[T8] ,
      bin9 : Format[T9] ,
      bin10 : Format[T10] ,
      bin11 : Format[T11] ,
      bin12 : Format[T12] ,
      bin13 : Format[T13] ,
      bin14 : Format[T14] ,
      bin15 : Format[T15] 
    ) : Format[   Tuple15[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ]
] = new Format[   Tuple15[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ]
]{
      def reads (in : Input) :    Tuple15[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ]
 = ( 
        read[T1](in),
        read[T2](in),
        read[T3](in),
        read[T4](in),
        read[T5](in),
        read[T6](in),
        read[T7](in),
        read[T8](in),
        read[T9](in),
        read[T10](in),
        read[T11](in),
        read[T12](in),
        read[T13](in),
        read[T14](in),
        read[T15](in)
      )
    
      def writes(out : Output, tuple :    Tuple15[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ]
) = {
        write(out, tuple._1);      
              write(out, tuple._2);      
              write(out, tuple._3);      
              write(out, tuple._4);      
              write(out, tuple._5);      
              write(out, tuple._6);      
              write(out, tuple._7);      
              write(out, tuple._8);      
              write(out, tuple._9);      
              write(out, tuple._10);      
              write(out, tuple._11);      
              write(out, tuple._12);      
              write(out, tuple._13);      
              write(out, tuple._14);      
              write(out, tuple._15);      
      ;
      }
  }
  implicit def tuple16Format[T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16](implicit 
      bin1 : Format[T1] ,
      bin2 : Format[T2] ,
      bin3 : Format[T3] ,
      bin4 : Format[T4] ,
      bin5 : Format[T5] ,
      bin6 : Format[T6] ,
      bin7 : Format[T7] ,
      bin8 : Format[T8] ,
      bin9 : Format[T9] ,
      bin10 : Format[T10] ,
      bin11 : Format[T11] ,
      bin12 : Format[T12] ,
      bin13 : Format[T13] ,
      bin14 : Format[T14] ,
      bin15 : Format[T15] ,
      bin16 : Format[T16] 
    ) : Format[   Tuple16[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ,T16 ]
] = new Format[   Tuple16[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ,T16 ]
]{
      def reads (in : Input) :    Tuple16[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ,T16 ]
 = ( 
        read[T1](in),
        read[T2](in),
        read[T3](in),
        read[T4](in),
        read[T5](in),
        read[T6](in),
        read[T7](in),
        read[T8](in),
        read[T9](in),
        read[T10](in),
        read[T11](in),
        read[T12](in),
        read[T13](in),
        read[T14](in),
        read[T15](in),
        read[T16](in)
      )
    
      def writes(out : Output, tuple :    Tuple16[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ,T16 ]
) = {
        write(out, tuple._1);      
              write(out, tuple._2);      
              write(out, tuple._3);      
              write(out, tuple._4);      
              write(out, tuple._5);      
              write(out, tuple._6);      
              write(out, tuple._7);      
              write(out, tuple._8);      
              write(out, tuple._9);      
              write(out, tuple._10);      
              write(out, tuple._11);      
              write(out, tuple._12);      
              write(out, tuple._13);      
              write(out, tuple._14);      
              write(out, tuple._15);      
              write(out, tuple._16);      
      ;
      }
  }
  implicit def tuple17Format[T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17](implicit 
      bin1 : Format[T1] ,
      bin2 : Format[T2] ,
      bin3 : Format[T3] ,
      bin4 : Format[T4] ,
      bin5 : Format[T5] ,
      bin6 : Format[T6] ,
      bin7 : Format[T7] ,
      bin8 : Format[T8] ,
      bin9 : Format[T9] ,
      bin10 : Format[T10] ,
      bin11 : Format[T11] ,
      bin12 : Format[T12] ,
      bin13 : Format[T13] ,
      bin14 : Format[T14] ,
      bin15 : Format[T15] ,
      bin16 : Format[T16] ,
      bin17 : Format[T17] 
    ) : Format[   Tuple17[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ,T16 ,T17 ]
] = new Format[   Tuple17[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ,T16 ,T17 ]
]{
      def reads (in : Input) :    Tuple17[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ,T16 ,T17 ]
 = ( 
        read[T1](in),
        read[T2](in),
        read[T3](in),
        read[T4](in),
        read[T5](in),
        read[T6](in),
        read[T7](in),
        read[T8](in),
        read[T9](in),
        read[T10](in),
        read[T11](in),
        read[T12](in),
        read[T13](in),
        read[T14](in),
        read[T15](in),
        read[T16](in),
        read[T17](in)
      )
    
      def writes(out : Output, tuple :    Tuple17[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ,T16 ,T17 ]
) = {
        write(out, tuple._1);      
              write(out, tuple._2);      
              write(out, tuple._3);      
              write(out, tuple._4);      
              write(out, tuple._5);      
              write(out, tuple._6);      
              write(out, tuple._7);      
              write(out, tuple._8);      
              write(out, tuple._9);      
              write(out, tuple._10);      
              write(out, tuple._11);      
              write(out, tuple._12);      
              write(out, tuple._13);      
              write(out, tuple._14);      
              write(out, tuple._15);      
              write(out, tuple._16);      
              write(out, tuple._17);      
      ;
      }
  }
  implicit def tuple18Format[T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18](implicit 
      bin1 : Format[T1] ,
      bin2 : Format[T2] ,
      bin3 : Format[T3] ,
      bin4 : Format[T4] ,
      bin5 : Format[T5] ,
      bin6 : Format[T6] ,
      bin7 : Format[T7] ,
      bin8 : Format[T8] ,
      bin9 : Format[T9] ,
      bin10 : Format[T10] ,
      bin11 : Format[T11] ,
      bin12 : Format[T12] ,
      bin13 : Format[T13] ,
      bin14 : Format[T14] ,
      bin15 : Format[T15] ,
      bin16 : Format[T16] ,
      bin17 : Format[T17] ,
      bin18 : Format[T18] 
    ) : Format[   Tuple18[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ,T16 ,T17 ,T18 ]
] = new Format[   Tuple18[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ,T16 ,T17 ,T18 ]
]{
      def reads (in : Input) :    Tuple18[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ,T16 ,T17 ,T18 ]
 = ( 
        read[T1](in),
        read[T2](in),
        read[T3](in),
        read[T4](in),
        read[T5](in),
        read[T6](in),
        read[T7](in),
        read[T8](in),
        read[T9](in),
        read[T10](in),
        read[T11](in),
        read[T12](in),
        read[T13](in),
        read[T14](in),
        read[T15](in),
        read[T16](in),
        read[T17](in),
        read[T18](in)
      )
    
      def writes(out : Output, tuple :    Tuple18[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ,T16 ,T17 ,T18 ]
) = {
        write(out, tuple._1);      
              write(out, tuple._2);      
              write(out, tuple._3);      
              write(out, tuple._4);      
              write(out, tuple._5);      
              write(out, tuple._6);      
              write(out, tuple._7);      
              write(out, tuple._8);      
              write(out, tuple._9);      
              write(out, tuple._10);      
              write(out, tuple._11);      
              write(out, tuple._12);      
              write(out, tuple._13);      
              write(out, tuple._14);      
              write(out, tuple._15);      
              write(out, tuple._16);      
              write(out, tuple._17);      
              write(out, tuple._18);      
      ;
      }
  }
  implicit def tuple19Format[T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19](implicit 
      bin1 : Format[T1] ,
      bin2 : Format[T2] ,
      bin3 : Format[T3] ,
      bin4 : Format[T4] ,
      bin5 : Format[T5] ,
      bin6 : Format[T6] ,
      bin7 : Format[T7] ,
      bin8 : Format[T8] ,
      bin9 : Format[T9] ,
      bin10 : Format[T10] ,
      bin11 : Format[T11] ,
      bin12 : Format[T12] ,
      bin13 : Format[T13] ,
      bin14 : Format[T14] ,
      bin15 : Format[T15] ,
      bin16 : Format[T16] ,
      bin17 : Format[T17] ,
      bin18 : Format[T18] ,
      bin19 : Format[T19] 
    ) : Format[   Tuple19[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ,T16 ,T17 ,T18 ,T19 ]
] = new Format[   Tuple19[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ,T16 ,T17 ,T18 ,T19 ]
]{
      def reads (in : Input) :    Tuple19[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ,T16 ,T17 ,T18 ,T19 ]
 = ( 
        read[T1](in),
        read[T2](in),
        read[T3](in),
        read[T4](in),
        read[T5](in),
        read[T6](in),
        read[T7](in),
        read[T8](in),
        read[T9](in),
        read[T10](in),
        read[T11](in),
        read[T12](in),
        read[T13](in),
        read[T14](in),
        read[T15](in),
        read[T16](in),
        read[T17](in),
        read[T18](in),
        read[T19](in)
      )
    
      def writes(out : Output, tuple :    Tuple19[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ,T16 ,T17 ,T18 ,T19 ]
) = {
        write(out, tuple._1);      
              write(out, tuple._2);      
              write(out, tuple._3);      
              write(out, tuple._4);      
              write(out, tuple._5);      
              write(out, tuple._6);      
              write(out, tuple._7);      
              write(out, tuple._8);      
              write(out, tuple._9);      
              write(out, tuple._10);      
              write(out, tuple._11);      
              write(out, tuple._12);      
              write(out, tuple._13);      
              write(out, tuple._14);      
              write(out, tuple._15);      
              write(out, tuple._16);      
              write(out, tuple._17);      
              write(out, tuple._18);      
              write(out, tuple._19);      
      ;
      }
  }
  implicit def tuple20Format[T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20](implicit 
      bin1 : Format[T1] ,
      bin2 : Format[T2] ,
      bin3 : Format[T3] ,
      bin4 : Format[T4] ,
      bin5 : Format[T5] ,
      bin6 : Format[T6] ,
      bin7 : Format[T7] ,
      bin8 : Format[T8] ,
      bin9 : Format[T9] ,
      bin10 : Format[T10] ,
      bin11 : Format[T11] ,
      bin12 : Format[T12] ,
      bin13 : Format[T13] ,
      bin14 : Format[T14] ,
      bin15 : Format[T15] ,
      bin16 : Format[T16] ,
      bin17 : Format[T17] ,
      bin18 : Format[T18] ,
      bin19 : Format[T19] ,
      bin20 : Format[T20] 
    ) : Format[   Tuple20[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ,T16 ,T17 ,T18 ,T19 ,T20 ]
] = new Format[   Tuple20[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ,T16 ,T17 ,T18 ,T19 ,T20 ]
]{
      def reads (in : Input) :    Tuple20[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ,T16 ,T17 ,T18 ,T19 ,T20 ]
 = ( 
        read[T1](in),
        read[T2](in),
        read[T3](in),
        read[T4](in),
        read[T5](in),
        read[T6](in),
        read[T7](in),
        read[T8](in),
        read[T9](in),
        read[T10](in),
        read[T11](in),
        read[T12](in),
        read[T13](in),
        read[T14](in),
        read[T15](in),
        read[T16](in),
        read[T17](in),
        read[T18](in),
        read[T19](in),
        read[T20](in)
      )
    
      def writes(out : Output, tuple :    Tuple20[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ,T16 ,T17 ,T18 ,T19 ,T20 ]
) = {
        write(out, tuple._1);      
              write(out, tuple._2);      
              write(out, tuple._3);      
              write(out, tuple._4);      
              write(out, tuple._5);      
              write(out, tuple._6);      
              write(out, tuple._7);      
              write(out, tuple._8);      
              write(out, tuple._9);      
              write(out, tuple._10);      
              write(out, tuple._11);      
              write(out, tuple._12);      
              write(out, tuple._13);      
              write(out, tuple._14);      
              write(out, tuple._15);      
              write(out, tuple._16);      
              write(out, tuple._17);      
              write(out, tuple._18);      
              write(out, tuple._19);      
              write(out, tuple._20);      
      ;
      }
  }
  implicit def tuple21Format[T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21](implicit 
      bin1 : Format[T1] ,
      bin2 : Format[T2] ,
      bin3 : Format[T3] ,
      bin4 : Format[T4] ,
      bin5 : Format[T5] ,
      bin6 : Format[T6] ,
      bin7 : Format[T7] ,
      bin8 : Format[T8] ,
      bin9 : Format[T9] ,
      bin10 : Format[T10] ,
      bin11 : Format[T11] ,
      bin12 : Format[T12] ,
      bin13 : Format[T13] ,
      bin14 : Format[T14] ,
      bin15 : Format[T15] ,
      bin16 : Format[T16] ,
      bin17 : Format[T17] ,
      bin18 : Format[T18] ,
      bin19 : Format[T19] ,
      bin20 : Format[T20] ,
      bin21 : Format[T21] 
    ) : Format[   Tuple21[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ,T16 ,T17 ,T18 ,T19 ,T20 ,T21 ]
] = new Format[   Tuple21[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ,T16 ,T17 ,T18 ,T19 ,T20 ,T21 ]
]{
      def reads (in : Input) :    Tuple21[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ,T16 ,T17 ,T18 ,T19 ,T20 ,T21 ]
 = ( 
        read[T1](in),
        read[T2](in),
        read[T3](in),
        read[T4](in),
        read[T5](in),
        read[T6](in),
        read[T7](in),
        read[T8](in),
        read[T9](in),
        read[T10](in),
        read[T11](in),
        read[T12](in),
        read[T13](in),
        read[T14](in),
        read[T15](in),
        read[T16](in),
        read[T17](in),
        read[T18](in),
        read[T19](in),
        read[T20](in),
        read[T21](in)
      )
    
      def writes(out : Output, tuple :    Tuple21[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ,T16 ,T17 ,T18 ,T19 ,T20 ,T21 ]
) = {
        write(out, tuple._1);      
              write(out, tuple._2);      
              write(out, tuple._3);      
              write(out, tuple._4);      
              write(out, tuple._5);      
              write(out, tuple._6);      
              write(out, tuple._7);      
              write(out, tuple._8);      
              write(out, tuple._9);      
              write(out, tuple._10);      
              write(out, tuple._11);      
              write(out, tuple._12);      
              write(out, tuple._13);      
              write(out, tuple._14);      
              write(out, tuple._15);      
              write(out, tuple._16);      
              write(out, tuple._17);      
              write(out, tuple._18);      
              write(out, tuple._19);      
              write(out, tuple._20);      
              write(out, tuple._21);      
      ;
      }
  }
  implicit def tuple22Format[T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22](implicit 
      bin1 : Format[T1] ,
      bin2 : Format[T2] ,
      bin3 : Format[T3] ,
      bin4 : Format[T4] ,
      bin5 : Format[T5] ,
      bin6 : Format[T6] ,
      bin7 : Format[T7] ,
      bin8 : Format[T8] ,
      bin9 : Format[T9] ,
      bin10 : Format[T10] ,
      bin11 : Format[T11] ,
      bin12 : Format[T12] ,
      bin13 : Format[T13] ,
      bin14 : Format[T14] ,
      bin15 : Format[T15] ,
      bin16 : Format[T16] ,
      bin17 : Format[T17] ,
      bin18 : Format[T18] ,
      bin19 : Format[T19] ,
      bin20 : Format[T20] ,
      bin21 : Format[T21] ,
      bin22 : Format[T22] 
    ) : Format[   Tuple22[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ,T16 ,T17 ,T18 ,T19 ,T20 ,T21 ,T22 ]
] = new Format[   Tuple22[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ,T16 ,T17 ,T18 ,T19 ,T20 ,T21 ,T22 ]
]{
      def reads (in : Input) :    Tuple22[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ,T16 ,T17 ,T18 ,T19 ,T20 ,T21 ,T22 ]
 = ( 
        read[T1](in),
        read[T2](in),
        read[T3](in),
        read[T4](in),
        read[T5](in),
        read[T6](in),
        read[T7](in),
        read[T8](in),
        read[T9](in),
        read[T10](in),
        read[T11](in),
        read[T12](in),
        read[T13](in),
        read[T14](in),
        read[T15](in),
        read[T16](in),
        read[T17](in),
        read[T18](in),
        read[T19](in),
        read[T20](in),
        read[T21](in),
        read[T22](in)
      )
    
      def writes(out : Output, tuple :    Tuple22[T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,T8 ,T9 ,T10 ,T11 ,T12 ,T13 ,T14 ,T15 ,T16 ,T17 ,T18 ,T19 ,T20 ,T21 ,T22 ]
) = {
        write(out, tuple._1);      
              write(out, tuple._2);      
              write(out, tuple._3);      
              write(out, tuple._4);      
              write(out, tuple._5);      
              write(out, tuple._6);      
              write(out, tuple._7);      
              write(out, tuple._8);      
              write(out, tuple._9);      
              write(out, tuple._10);      
              write(out, tuple._11);      
              write(out, tuple._12);      
              write(out, tuple._13);      
              write(out, tuple._14);      
              write(out, tuple._15);      
              write(out, tuple._16);      
              write(out, tuple._17);      
              write(out, tuple._18);      
              write(out, tuple._19);      
              write(out, tuple._20);      
              write(out, tuple._21);      
              write(out, tuple._22);      
      ;
      }
  }
}

trait LowPriorityCollectionTypes extends Generic {
  def canBuildFormat[CC[X] <: Traversable[X], T](implicit bin : Format[T], cbf: CanBuildFrom[Nothing, T, CC[T]]) : Format[CC[T]] =
    new LengthEncoded[CC[T], T]{
      def build(length : Int, ts : Iterator[T]) = {
        val builder = cbf.apply()
        builder.sizeHint(length)
        builder ++= ts
		  if(ts.hasNext) error("Builder did not consume all input.") // no lazy builders allowed
        builder.result()
      } 
    }
}

trait CollectionTypes extends BasicTypes with LowPriorityCollectionTypes {
  implicit def listFormat[T](implicit bin : Format[T]) : Format[List[T]] = canBuildFormat[List, T]

  implicit def arrayFormat[T](implicit fmt : Format[T], mf : scala.reflect.Manifest[T]) : Format[Array[T]] = fmt match{
    case ByteFormat => ByteArrayFormat.asInstanceOf[Format[Array[T]]];
    case _ => 
      new CollectionFormat[Array[T], T]{
        def build(length : Int, ts : Iterator[T]) = {
          val result = new Array[T](length);
          ts.copyToArray(result, 0);
          result;
        }
        def size(a: Array[T]) = a.length
        def foreach(a: Array[T])(f: T => Unit) = a foreach f
      } 
    }

  implicit object ByteArrayFormat extends Format[Array[Byte]]{
    def reads(in : Input) = {
      val length = read[Int](in);
      val bytes = new Array[Byte](length);
      in.readFully(bytes);
      bytes; 
    }

    def writes(out : Output, bytes : Array[Byte]){
      write(out, bytes.length);
      out.writeAll(bytes);
    }
  }

  implicit def mutableSetFormat[T](implicit bin : Format[T]) : Format[mutable.Set[T]] = 
    viaSeq((x : Seq[T]) => mutable.Set(x :_*))

  implicit def immutableSetFormat[T](implicit bin : Format[T]) : Format[immutable.Set[T]] = 
    viaSeq((x : Seq[T]) => immutable.Set(x :_*))

  implicit def immutableSortedSetFormat[S](implicit ord : Ordering[S], binS : Format[S]) : Format[immutable.SortedSet[S]] = {
    viaSeq( (x : Seq[S]) => immutable.TreeSet[S](x :_*))
  }

  implicit def immutableMapFormat[S, T](implicit binS : Format[S], binT : Format[T]) : Format[immutable.Map[S, T]] =
    viaSeq( (x : Seq[(S, T)]) => immutable.Map(x :_*));

  implicit def immutableSortedMapFormat[S, T](implicit ord : Ordering[S], binS : Format[S], binT : Format[T]) : Format[immutable.SortedMap[S, T]] = {
    viaSeq( (x : Seq[(S, T)]) => immutable.TreeMap[S, T](x :_*))
  }

  /**
   * Format instance for streams.
   * Note that unlike almost all other collections this is not length encoded
   * Instead it is encoded with a sequence of byte separators, with a single
   * byte value of 1 preceding each element to be read and a value of 0 indicating
   * the stream termination.
   *
   * This is to ensure proper laziness behaviour - values will be written as they
   * become available rather than thunking the entire stream up front. 
   * 
   * Warning! The resulting Stream is not read lazily. If you wish to read a Stream
   * lazily you may consider it to be a sequence of Option[T]s terminated by a None.
   *
   * Note that this behaviour has changed from that of SFormat 0.2.1, though the format
   * remains the same.
   */
  implicit def streamFormat[S](implicit bin : Format[S]) : Format[Stream[S]] = new Format[Stream[S]]{
    def reads(in : Input) = {
      val buffer = new mutable.ArrayBuffer[S];
      while((read[Option[S]](in) match {
        case Some(s) => buffer += s; true;
        case None => false;
      })){};
      buffer.toStream;
    } 

    def writes(out : Output, stream : Stream[S]){
      stream.foreach(x => { write[Byte](out, 1); write(out, x); });
      write[Byte](out, 0);
    }
  }
}

trait StandardTypes extends CollectionTypes{
  implicit object BigIntFormat extends Format[BigInt]{
    def reads(in : Input) = BigInt(read[Array[Byte]](in));
    def writes(out : Output, i : BigInt) = write(out, i.toByteArray);
  }

  implicit object BigDecimalFormat extends Format[BigDecimal]{
    def reads(in : Input) = BigDecimal(read[String](in));
    def writes(out : Output, d : BigDecimal) = write(out, d.toString);
  }

  implicit object ClassFormat extends Format[Class[_]]{
    def reads(in : Input) = Class.forName(read[String](in));
    def writes(out : Output, clazz : Class[_]) = write(out, clazz.getName);
  }

  implicit lazy val SymbolFormat : Format[Symbol] = viaString(Symbol(_));

  import java.io.File;
  implicit lazy val FileFormat : Format[File] = viaString(new File(_ : String));

  import java.net.{URI, URL}
  implicit lazy val UrlFormat : Format[URL] = viaString(new URL(_ : String));
  implicit lazy val UriFormat : Format[URI] = viaString(new URI(_ : String));


  import scala.xml.{XML, Elem, NodeSeq};
  implicit lazy val XmlFormat : Format[NodeSeq] = new Format[NodeSeq]{
    def reads(in : Input) = XML.loadString(read[String](in)).child;
    def writes(out : Output, elem : NodeSeq) = write(out, <binary>elem</binary>.toString);
  }
}
