/*
 * Decompiled with CFR 0.152.
 */
package org.scalaide.debug.internal.expression;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvocationException;
import org.scalaide.debug.internal.expression.ExpressionException;
import org.scalaide.debug.internal.expression.ExpressionManager$;
import org.scalaide.debug.internal.expression.LambdaCompilationFailure;
import org.scalaide.debug.internal.expression.MethodInvocationException;
import org.scalaide.debug.internal.expression.MissingField;
import org.scalaide.debug.internal.expression.NotAtBreakpointException$;
import org.scalaide.debug.internal.expression.ReflectiveCompilationFailedWithClassNotFound;
import org.scalaide.debug.internal.expression.ReflectiveCompilationFailure;
import org.scalaide.debug.internal.expression.UnsupportedFeature;
import org.scalaide.debug.internal.expression.context.JdiContext;
import org.scalaide.debug.internal.expression.proxies.JdiProxy;
import org.scalaide.logging.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.Nothing$;
import scala.tools.reflect.ToolBoxError;
import scala.util.Failure;
import scala.util.Try;

public final class ExpressionException$
implements Serializable {
    public static final ExpressionException$ MODULE$;
    private final String throwDetected;
    private final String functionProxyArgumentTypeNotInferredMessage;
    private final String lambdaNestedInLambdaMessage;
    private final String notAtBreakpointExceptionMessage;

    static {
        new ExpressionException$();
    }

    public String throwDetected() {
        return this.throwDetected;
    }

    public String functionProxyArgumentTypeNotInferredMessage() {
        return this.functionProxyArgumentTypeNotInferredMessage;
    }

    public String lambdaNestedInLambdaMessage() {
        return this.lambdaNestedInLambdaMessage;
    }

    public String methodInvocationMessage(String reason) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception was thrown from debugged code, message: \"", "\"."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{reason}));
    }

    public String noBooleanJdiProxyExceptionMessage(String resultType) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Result type of expression must be boolean, was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultType}));
    }

    public String reflectiveCompilationFailureMessage(String reason) {
        return new StringBuilder().append((Object)"Compilation failed\n").append((Object)reason.replaceFirst("reflective typecheck has failed\\: ", "")).toString();
    }

    public String reflectiveCompilationFailureMessageWithDefaultPackageHint(String reason) {
        return new StringBuilder().append((Object)this.reflectiveCompilationFailureMessage(reason)).append((Object)new StringOps(Predef$.MODULE$.augmentString("\n        |If you are sure this class exist make sure you don't use default (empty) packages, as those are not supported.")).stripMargin()).toString();
    }

    public String notAtBreakpointExceptionMessage() {
        return this.notAtBreakpointExceptionMessage;
    }

    public String unsupportedFeatureMessage(String featureName) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using '", "' is not currently supported by expression evaluator."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{featureName}));
    }

    public String notExistingField(String name) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Field ", " does not exist in current scope."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}));
    }

    public String lambdaCompilationFailure(String lambdaSource) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not compile lambda expression: \\n", "\\nSee underlying message for more details."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{lambdaSource}));
    }

    public String multipleMethodsMatchNestedOneMessage(String methodName, Seq<String> candidates2) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"We cannot determine real name of nested method: ", "}.\n       |Candidates: ", "\n       |Nested methods are not fully supported in expression evaluator.\")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{methodName, candidates2.mkString(", ")})))).stripMargin();
    }

    public <A> Try<A> recoverFromErrors(Try<A> result, JdiContext context, Logger logger) {
        return result.recoverWith((PartialFunction)new Serializable(context, logger){
            public static final long serialVersionUID = 0L;
            private final JdiContext context$1;
            private final Logger logger$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Failure<Nothing$> failure;
                boolean bl = false;
                ToolBoxError toolBoxError = null;
                A1 A1 = x1;
                if (A1 instanceof AbsentInformationException) {
                    AbsentInformationException absentInformationException = (AbsentInformationException)A1;
                    this.logger$1.error((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Absent information exception";
                        }
                    }, (Throwable)absentInformationException);
                    failure = new Failure((Throwable)NotAtBreakpointException$.MODULE$);
                    return (B1)failure;
                }
                if (A1 instanceof IncompatibleThreadStateException) {
                    IncompatibleThreadStateException incompatibleThreadStateException = (IncompatibleThreadStateException)A1;
                    this.logger$1.error((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Incompatible thread state";
                        }
                    }, (Throwable)incompatibleThreadStateException);
                    failure = new Failure((Throwable)NotAtBreakpointException$.MODULE$);
                    return (B1)failure;
                }
                if (A1 instanceof InvocationException) {
                    InvocationException invocationException = (InvocationException)A1;
                    this.logger$1.error((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "JDI invocation exception";
                        }
                    }, (Throwable)invocationException);
                    JdiProxy underlying = this.context$1.valueProxy(invocationException.exception());
                    failure = new Failure((Throwable)new MethodInvocationException(this.context$1.show(underlying, false), invocationException));
                    return (B1)failure;
                }
                if (A1 instanceof UnsupportedFeature) {
                    UnsupportedFeature unsupportedFeature = (UnsupportedFeature)A1;
                    this.logger$1.warn((Function0)new Serializable(this, unsupportedFeature){
                        public static final long serialVersionUID = 0L;
                        private final UnsupportedFeature x6$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported feature was used: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x6$1.name()}));
                        }
                        {
                            this.x6$1 = x6$1;
                        }
                    }, (Throwable)unsupportedFeature);
                    failure = new Failure((Throwable)unsupportedFeature);
                    return (B1)failure;
                }
                if (A1 instanceof LambdaCompilationFailure) {
                    LambdaCompilationFailure lambdaCompilationFailure = (LambdaCompilationFailure)A1;
                    this.logger$1.warn((Function0)new Serializable(this, lambdaCompilationFailure){
                        public static final long serialVersionUID = 0L;
                        private final LambdaCompilationFailure x7$1;

                        public final String apply() {
                            return this.x7$1.getMessage();
                        }
                        {
                            this.x7$1 = x7$1;
                        }
                    }, lambdaCompilationFailure.getCause());
                    failure = new Failure((Throwable)lambdaCompilationFailure);
                    return (B1)failure;
                }
                if (A1 instanceof ExpressionException) {
                    ExpressionException expressionException = (ExpressionException)((Object)A1);
                    this.logger$1.error((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Exception during expression evaluation";
                        }
                    }, (Throwable)((Object)expressionException));
                    failure = new Failure((Throwable)((Object)expressionException));
                    return (B1)failure;
                }
                Option<String> option = ExpressionManager$.MODULE$.NonexisitngFieldEqualError().unapply(A1);
                if (!option.isEmpty()) {
                    String name = (String)option.get();
                    failure = new Failure((Throwable)new MissingField(name));
                    return (B1)failure;
                }
                if (A1 instanceof ToolBoxError) {
                    bl = true;
                    toolBoxError = (ToolBoxError)A1;
                    if (toolBoxError.getMessage().contains("not found: type")) {
                        failure = new Failure((Throwable)new ReflectiveCompilationFailedWithClassNotFound(toolBoxError.getMessage()));
                        return (B1)failure;
                    }
                }
                if (bl) {
                    failure = new Failure((Throwable)new ReflectiveCompilationFailure(toolBoxError.getMessage()));
                    return (B1)failure;
                }
                if (A1 instanceof NoSuchMethodError) {
                    NoSuchMethodError noSuchMethodError = (NoSuchMethodError)A1;
                    failure = new Failure((Throwable)new RuntimeException(noSuchMethodError.getMessage(), noSuchMethodError));
                    return (B1)failure;
                }
                if (A1 instanceof ClassNotLoadedException) {
                    ClassNotLoadedException classNotLoadedException = (ClassNotLoadedException)A1;
                    this.logger$1.error((Function0)new Serializable(this, classNotLoadedException){
                        public static final long serialVersionUID = 0L;
                        private final ClassNotLoadedException x12$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Class with name: ", " was not loaded."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x12$1.className()}));
                        }
                        {
                            this.x12$1 = x12$1;
                        }
                    }, (Throwable)classNotLoadedException);
                    failure = ExpressionException$.MODULE$.org$scalaide$debug$internal$expression$ExpressionException$$handleUnknownException(classNotLoadedException);
                    return (B1)failure;
                }
                if (A1 != null) {
                    A1 A12 = A1;
                    this.logger$1.error((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Unknown exception during evaluation";
                        }
                    }, A12);
                    failure = ExpressionException$.MODULE$.org$scalaide$debug$internal$expression$ExpressionException$$handleUnknownException(A12);
                    return (B1)failure;
                }
                failure = function1.apply(x1);
                return (B1)failure;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Throwable x1) {
                boolean bl = false;
                ToolBoxError toolBoxError = null;
                Throwable throwable = x1;
                if (throwable instanceof AbsentInformationException) {
                    return true;
                }
                if (throwable instanceof IncompatibleThreadStateException) {
                    return true;
                }
                if (throwable instanceof InvocationException) {
                    return true;
                }
                if (throwable instanceof UnsupportedFeature) {
                    return true;
                }
                if (throwable instanceof LambdaCompilationFailure) {
                    return true;
                }
                if (throwable instanceof ExpressionException) {
                    return true;
                }
                Option<String> option = ExpressionManager$.MODULE$.NonexisitngFieldEqualError().unapply(throwable);
                if (!option.isEmpty()) return true;
                if (throwable instanceof ToolBoxError) {
                    bl = true;
                    toolBoxError = (ToolBoxError)throwable;
                    if (toolBoxError.getMessage().contains("not found: type")) {
                        return true;
                    }
                }
                if (bl) {
                    return true;
                }
                if (throwable instanceof NoSuchMethodError) {
                    return true;
                }
                if (throwable instanceof ClassNotLoadedException) {
                    return true;
                }
                if (throwable == null) return false;
                return true;
            }
            {
                this.context$1 = context$1;
                this.logger$1 = logger$1;
            }
        });
    }

    public Failure<Nothing$> org$scalaide$debug$internal$expression$ExpressionException$$handleUnknownException(Throwable e) {
        String currentMessage = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception message: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getMessage()}));
        String newMessage = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception was thrown during expression evaluation. To see more details check scala-ide error log.\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{currentMessage}));
        return new Failure((Throwable)new RuntimeException(newMessage, e));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ExpressionException$() {
        MODULE$ = this;
        this.throwDetected = "Throwing exception from evaluated code is not possible.";
        this.functionProxyArgumentTypeNotInferredMessage = new StringOps(Predef$.MODULE$.augmentString("You used a lambda expression for which we could not infer its type parameters.\n      |Please provide explicit types for all lambda parameters.")).stripMargin();
        this.lambdaNestedInLambdaMessage = "Lambda containing another lambdas is currently not supported.";
        this.notAtBreakpointExceptionMessage = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Current thread is not suspended as a result of JDI event.\n       |Evaluating expressions in such state is not possible due to JDI limitation."})).s((Seq)Nil$.MODULE$))).stripMargin();
    }
}

