/*
 * Decompiled with CFR 0.152.
 */
package org.scalaide.util.internal.eclipse;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.UndoEdit;
import org.eclipse.ui.texteditor.ITextEditor;
import org.scalaide.ui.editor.ISourceViewerEditor;
import org.scalaide.util.eclipse.EditorUtils$;
import org.scalaide.util.eclipse.FileUtils$;
import org.scalaide.util.eclipse.RegionUtils$;
import org.scalaide.util.eclipse.RegionUtils$RichDocument$;
import org.scalaide.util.eclipse.RegionUtils$RichRegion$;
import org.scalaide.util.eclipse.RegionUtils$RichSelection$;
import org.scalaide.util.eclipse.RegionUtils$RichTextEdit$;
import org.scalaide.util.internal.eclipse.TextEditUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.io.AbstractFile;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.tools.refactoring.common.TextChange;

public final class TextEditUtils$ {
    public static final TextEditUtils$ MODULE$;

    static {
        new TextEditUtils$();
    }

    public UndoEdit applyRefactoringChangeToEditor(TextChange change, ITextEditor editor) {
        ReplaceEdit edit = new ReplaceEdit(change.from(), change.to() - change.from(), change.text());
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        return edit.apply(document);
    }

    public TextFileChange createTextFileChange(IFile file2, List<TextChange> fileChanges, boolean leaveDirty) {
        try {
            return this.checkedCreateTextFileChange(file2, fileChanges, leaveDirty);
        }
        catch (MalformedTreeException malformedTreeException) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|Couldn't create text file change, see root cause.\n                                            |The following changes were expected to be created: ", ".\n                                            |Document was:\n                                            |", "\n                                            |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileChanges, Source$.MODULE$.fromInputStream(file2.getContents(), Codec$.MODULE$.UTF8()).mkString()})))).stripMargin(), malformedTreeException);
        }
    }

    private TextFileChange checkedCreateTextFileChange(IFile file2, List<TextChange> fileChanges, boolean leaveDirty) {
        return new TextFileChange(file2, fileChanges, leaveDirty){
            private final MultiTextEdit org$scalaide$util$internal$eclipse$TextEditUtils$$anon$$fileChangeRootEdit;

            public MultiTextEdit org$scalaide$util$internal$eclipse$TextEditUtils$$anon$$fileChangeRootEdit() {
                return this.org$scalaide$util$internal$eclipse$TextEditUtils$$anon$$fileChangeRootEdit;
            }
            {
                this.org$scalaide$util$internal$eclipse$TextEditUtils$$anon$$fileChangeRootEdit = new MultiTextEdit();
                ((List)fileChanges$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ReplaceEdit apply(TextChange change) {
                        return new ReplaceEdit(change.from(), change.to() - change.from(), change.text());
                    }
                }, List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final void apply(TextEdit x$1) {
                        this.$outer.org$scalaide$util$internal$eclipse$TextEditUtils$$anon$$fileChangeRootEdit().addChild(x$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                if (leaveDirty$1) {
                    this.setSaveMode(4);
                } else {
                    this.setSaveMode(1);
                }
                this.setEdit((TextEdit)this.org$scalaide$util$internal$eclipse$TextEditUtils$$anon$$fileChangeRootEdit());
            }
        };
    }

    public Option<ITextSelection> applyChangesToFile(IDocument document, ITextSelection textSelection, AbstractFile file2, List<TextChange> changes, boolean leaveDirty) {
        try {
            return this.checkedApplyChangesToFile(document, textSelection, file2, changes, leaveDirty);
        }
        catch (MalformedTreeException malformedTreeException) {
            String sel = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"start=", ", length=", ", text=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)textSelection.getOffset()), BoxesRunTime.boxToInteger((int)textSelection.getLength()), textSelection.getText()}));
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|Couldn't perform text file change, see root cause.\n                                            |The selection was: ", ".\n                                            |The following changes were expected to be applied: ", ".\n                                            |Document was:\n                                            |", "\n                                            |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sel, changes, document.get()})))).stripMargin(), malformedTreeException);
        }
    }

    public boolean applyChangesToFile$default$5() {
        return false;
    }

    private Option<ITextSelection> checkedApplyChangesToFile(IDocument document, ITextSelection textSelection, AbstractFile file2, List<TextChange> changes, boolean leaveDirty) {
        return FileUtils$.MODULE$.toIFile(file2).map((Function1)new Serializable(document, textSelection, changes, leaveDirty){
            public static final long serialVersionUID = 0L;
            private final IDocument document$1;
            private final ITextSelection textSelection$1;
            private final List changes$1;
            private final boolean leaveDirty$2;

            public final ITextSelection apply(IFile f) {
                TextEdit textEdit = TextEditUtils$.MODULE$.createTextFileChange(f, (List<TextChange>)this.changes$1, this.leaveDirty$2).getEdit();
                if (textEdit instanceof MultiTextEdit) {
                    MultiTextEdit multiTextEdit = (MultiTextEdit)textEdit;
                    ITextSelection iTextSelection = TextEditUtils$.MODULE$.applyMultiTextEdit(this.document$1, this.textSelection$1, multiTextEdit);
                    return iTextSelection;
                }
                throw new MatchError((Object)textEdit);
            }
            {
                this.document$1 = document$1;
                this.textSelection$1 = textSelection$1;
                this.changes$1 = changes$1;
                this.leaveDirty$2 = leaveDirty$2;
            }
        });
    }

    public void applyChangesToFileWhileKeepingSelection(IDocument document, ITextSelection textSelection, AbstractFile file2, List<TextChange> changes, boolean saveAfter) {
        this.applyChangesToFile(document, textSelection, file2, changes, saveAfter).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(ITextSelection selection2) {
                EditorUtils$.MODULE$.doWithCurrentEditor((Function1<ISourceViewerEditor, BoxedUnit>)new Serializable(this, selection2){
                    public static final long serialVersionUID = 0L;
                    private final ITextSelection selection$1;

                    public final void apply(ISourceViewerEditor x$1) {
                        x$1.selectAndReveal(this.selection$1.getOffset(), this.selection$1.getLength());
                    }
                    {
                        this.selection$1 = selection$1;
                    }
                });
            }
        });
    }

    public boolean applyChangesToFileWhileKeepingSelection$default$5() {
        return true;
    }

    public ITextSelection applyMultiTextEdit(IDocument document, ITextSelection textSelection, MultiTextEdit edit) {
        int selStart = RegionUtils$RichSelection$.MODULE$.start$extension(RegionUtils$.MODULE$.RichSelection(textSelection));
        int selLen = RegionUtils$RichSelection$.MODULE$.length$extension(RegionUtils$.MODULE$.RichSelection(textSelection));
        int selEnd = RegionUtils$RichSelection$.MODULE$.end$extension(RegionUtils$.MODULE$.RichSelection(textSelection));
        Option overlappingEdit = Predef$.MODULE$.refArrayOps((Object[])edit.getChildren()).find((Function1)new Serializable(selStart, selEnd){
            public static final long serialVersionUID = 0L;
            private final int selStart$1;
            private final int selEnd$1;

            public final boolean apply(TextEdit e) {
                return TextEditUtils$.MODULE$.org$scalaide$util$internal$eclipse$TextEditUtils$$selectionOverlapsRegion$1(e.getRegion(), this.selStart$1, this.selEnd$1);
            }
            {
                this.selStart$1 = selStart$1;
                this.selEnd$1 = selEnd$1;
            }
        });
        return (ITextSelection)overlappingEdit.map((Function1)new Serializable(document, edit, selStart, selLen, selEnd){
            public static final long serialVersionUID = 0L;
            private final IDocument document$2;
            private final MultiTextEdit edit$1;
            private final int selStart$1;
            private final int selLen$1;
            private final int selEnd$1;

            public final TextSelection apply(TextEdit overlappingEdit) {
                return TextEditUtils$.MODULE$.org$scalaide$util$internal$eclipse$TextEditUtils$$handleOverlap$1(overlappingEdit, this.document$2, this.edit$1, this.selStart$1, this.selLen$1, this.selEnd$1);
            }
            {
                this.document$2 = document$2;
                this.edit$1 = edit$1;
                this.selStart$1 = selStart$1;
                this.selLen$1 = selLen$1;
                this.selEnd$1 = selEnd$1;
            }
        }).getOrElse((Function0)new Serializable(document, edit, selStart, selLen){
            public static final long serialVersionUID = 0L;
            private final IDocument document$2;
            private final MultiTextEdit edit$1;
            private final int selStart$1;
            private final int selLen$1;

            public final TextSelection apply() {
                return TextEditUtils$.MODULE$.org$scalaide$util$internal$eclipse$TextEditUtils$$handleNonOverlap$1(this.document$2, this.edit$1, this.selStart$1, this.selLen$1);
            }
            {
                this.document$2 = document$2;
                this.edit$1 = edit$1;
                this.selStart$1 = selStart$1;
                this.selLen$1 = selLen$1;
            }
        });
    }

    public final boolean org$scalaide$util$internal$eclipse$TextEditUtils$$selectionOverlapsRegion$1(IRegion region, int selStart$1, int selEnd$1) {
        int rStart = RegionUtils$RichRegion$.MODULE$.start$extension(RegionUtils$.MODULE$.RichRegion(region));
        int rEnd = RegionUtils$RichRegion$.MODULE$.end$extension(RegionUtils$.MODULE$.RichRegion(region));
        return !(selStart$1 < rStart && selEnd$1 < rStart || selStart$1 > rEnd && selEnd$1 > rEnd);
    }

    public final TextSelection org$scalaide$util$internal$eclipse$TextEditUtils$$handleNonOverlap$1(IDocument document$2, MultiTextEdit edit$1, int selStart$1, int selLen$1) {
        RangeMarker currentPosition = new RangeMarker(selStart$1, selLen$1);
        edit$1.addChild((TextEdit)currentPosition);
        edit$1.apply(document$2);
        return new TextSelection(document$2, RegionUtils$RichTextEdit$.MODULE$.start$extension(RegionUtils$.MODULE$.RichTextEdit((TextEdit)currentPosition)), RegionUtils$RichTextEdit$.MODULE$.length$extension(RegionUtils$.MODULE$.RichTextEdit((TextEdit)currentPosition)));
    }

    private final int offsetInIntersection$1(int selStart$1, int rStart$1, int rLen$1) {
        return rLen$1 - (selStart$1 - rStart$1);
    }

    private final int adjustOffset$1(int overlapToPreserve, IDocument document$2, MultiTextEdit edit$1, int selStart$1) {
        int lenAfterSelection = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])edit$1.getChildren()).collect((PartialFunction)new Serializable(selStart$1){
            public static final long serialVersionUID = 0L;
            private final int selStart$1;

            public final <A1 extends TextEdit, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (RegionUtils$RichTextEdit$.MODULE$.start$extension(RegionUtils$.MODULE$.RichTextEdit(A1)) > this.selStart$1) {
                    int n;
                    A1 A12 = A1;
                    if (A12 instanceof ReplaceEdit) {
                        ReplaceEdit replaceEdit = (ReplaceEdit)A12;
                        n = RegionUtils$RichTextEdit$.MODULE$.length$extension(RegionUtils$.MODULE$.RichTextEdit((TextEdit)replaceEdit)) - replaceEdit.getText().length();
                    } else {
                        n = RegionUtils$RichTextEdit$.MODULE$.length$extension(RegionUtils$.MODULE$.RichTextEdit(A12));
                    }
                    object = BoxesRunTime.boxToInteger((int)n);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(TextEdit x1) {
                TextEdit textEdit = x1;
                boolean bl = RegionUtils$RichTextEdit$.MODULE$.start$extension(RegionUtils$.MODULE$.RichTextEdit(textEdit)) > this.selStart$1;
                return bl;
            }
            {
                this.selStart$1 = selStart$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int originalLength = RegionUtils$RichDocument$.MODULE$.length$extension(RegionUtils$.MODULE$.RichDocument(document$2));
        edit$1.apply(document$2);
        int modifiedLength = RegionUtils$RichDocument$.MODULE$.length$extension(RegionUtils$.MODULE$.RichDocument(document$2)) - originalLength;
        return selStart$1 + modifiedLength + lenAfterSelection + overlapToPreserve;
    }

    public final TextSelection org$scalaide$util$internal$eclipse$TextEditUtils$$handleOverlap$1(TextEdit overlappingEdit, IDocument document$2, MultiTextEdit edit$1, int selStart$1, int selLen$1, int selEnd$1) {
        Tuple2.mcII.sp sp2;
        Tuple2.mcII.sp sp3;
        int rStart = RegionUtils$RichTextEdit$.MODULE$.start$extension(RegionUtils$.MODULE$.RichTextEdit(overlappingEdit));
        int rLen = RegionUtils$RichTextEdit$.MODULE$.length$extension(RegionUtils$.MODULE$.RichTextEdit(overlappingEdit));
        int rEnd = RegionUtils$RichTextEdit$.MODULE$.end$extension(RegionUtils$.MODULE$.RichTextEdit(overlappingEdit));
        if (selStart$1 < rStart && selEnd$1 < rEnd) {
            sp3 = new Tuple2.mcII.sp(this.adjustOffset$1(0, document$2, edit$1, selStart$1), selLen$1 - (selEnd$1 - rStart));
        } else if (selStart$1 < rStart && selEnd$1 >= rEnd) {
            int n;
            TextEdit textEdit = overlappingEdit;
            if (textEdit instanceof ReplaceEdit) {
                ReplaceEdit replaceEdit = (ReplaceEdit)textEdit;
                n = RegionUtils$RichTextEdit$.MODULE$.length$extension(RegionUtils$.MODULE$.RichTextEdit((TextEdit)replaceEdit)) - replaceEdit.getText().length();
            } else {
                n = RegionUtils$RichTextEdit$.MODULE$.length$extension(RegionUtils$.MODULE$.RichTextEdit(textEdit));
            }
            int sub = n;
            sp3 = new Tuple2.mcII.sp(this.adjustOffset$1(0, document$2, edit$1, selStart$1), selLen$1 - sub);
        } else {
            sp3 = sp2 = selStart$1 < rEnd && selEnd$1 < rEnd ? new Tuple2.mcII.sp(this.adjustOffset$1(this.offsetInIntersection$1(selStart$1, rStart, rLen), document$2, edit$1, selStart$1), 0) : new Tuple2.mcII.sp(this.adjustOffset$1(this.offsetInIntersection$1(selStart$1, rStart, rLen), document$2, edit$1, selStart$1), selLen$1 - (rEnd - selStart$1));
        }
        if (sp2 != null) {
            Tuple2.mcII.sp sp4;
            int newOffset2 = sp2._1$mcI$sp();
            int newLen = sp2._2$mcI$sp();
            Tuple2.mcII.sp sp5 = sp4 = new Tuple2.mcII.sp(newOffset2, newLen);
            int newOffset3 = sp5._1$mcI$sp();
            int newLen2 = sp5._2$mcI$sp();
            return new TextSelection(document$2, newOffset3, newLen2);
        }
        throw new MatchError((Object)sp2);
    }

    private TextEditUtils$() {
        MODULE$ = this;
    }
}

