/*
 * Decompiled with CFR 0.152.
 */
package org.scalaide.util.eclipse;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.scalaide.core.resources.EclipseResource$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.io.AbstractFile;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

public final class FileUtils$ {
    public static final FileUtils$ MODULE$;

    static {
        new FileUtils$();
    }

    public Option<IFile> toIFile(AbstractFile file2) {
        Some some;
        AbstractFile abstractFile = file2;
        if (abstractFile == null) {
            some = None$.MODULE$;
        } else {
            IResource file3;
            Option<IResource> option = EclipseResource$.MODULE$.unapply(abstractFile);
            if (!option.isEmpty() && (file3 = (IResource)option.get()) instanceof IFile) {
                IFile iFile = (IFile)file3;
                some = new Some((Object)iFile);
            } else {
                IPath path = Path.fromOSString((String)abstractFile.path());
                some = this.resourceForPath(path, this.resourceForPath$default$2());
            }
        }
        return some;
    }

    public Option<IPath> toIPath(AbstractFile file2) {
        return this.toIFile(file2).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final IPath apply(IFile x$1) {
                return x$1.getFullPath();
            }
        });
    }

    public void clearBuildErrors(IFile file2, IProgressMonitor monitor) {
        try {
            file2.deleteMarkers("org.scala-ide.sdt.core.problem", true, 2);
        }
        catch (ResourceException resourceException) {}
    }

    public Seq<IMarker> findBuildErrors(IResource file2) {
        return Predef$.MODULE$.wrapRefArray((Object[])file2.findMarkers("org.scala-ide.sdt.core.problem", true, 2));
    }

    public boolean hasBuildErrors(IResource file2) {
        return Predef$.MODULE$.refArrayOps((Object[])file2.findMarkers("org.scala-ide.sdt.core.problem", true, 2)).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(IMarker x$2) {
                return BoxesRunTime.equals((Object)x$2.getAttribute("severity"), (Object)BoxesRunTime.boxToInteger((int)2));
            }
        });
    }

    public void deleteDir(File dir) {
        if (dir.isDirectory()) {
            Predef$.MODULE$.refArrayOps((Object[])dir.listFiles()).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Object apply(File f) {
                    Boolean bl;
                    if (f.isDirectory()) {
                        FileUtils$.MODULE$.deleteDir(f);
                        bl = BoxedUnit.UNIT;
                    } else {
                        bl = BoxesRunTime.boxToBoolean((boolean)f.delete());
                    }
                    return bl;
                }
            });
            dir.delete();
        }
    }

    public Try<BoxedUnit> createFile(IFile file2) {
        return Try$.MODULE$.apply((Function0)new Serializable(file2){
            public static final long serialVersionUID = 0L;
            private final IFile file$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.createParentFolders$1(this.file$1.getParent());
                this.file$1.create((InputStream)new ByteArrayInputStream((byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte())), true, null);
            }

            private final void createParentFolders$1(IContainer c) {
                IFolder iFolder;
                IContainer iContainer = c;
                if (iContainer instanceof IFolder && !(iFolder = (IFolder)iContainer).exists()) {
                    this.createParentFolders$1(iFolder.getParent());
                    iFolder.create(true, true, null);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                this.file$1 = file$1;
            }
        });
    }

    public Option<IFile> resourceForPath(IPath location, IPath prefix) {
        IFile[] resources = (IFile[])Try$.MODULE$.apply((Function0)new Serializable(location){
            public static final long serialVersionUID = 0L;
            private final IPath location$1;

            public final IFile[] apply() {
                return ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(URIUtil.toURI((IPath)this.location$1));
            }
            {
                this.location$1 = location$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final IFile[] apply() {
                return (IFile[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(IFile.class));
            }
        });
        return Predef$.MODULE$.refArrayOps((Object[])resources).find((Function1)new Serializable(prefix){
            public static final long serialVersionUID = 0L;
            private final IPath prefix$1;

            public final boolean apply(IFile x$3) {
                return this.prefix$1.isPrefixOf(x$3.getFullPath());
            }
            {
                this.prefix$1 = prefix$1;
            }
        });
    }

    public IPath resourceForPath$default$2() {
        return Path.EMPTY;
    }

    public boolean isBuildable(IFile file2) {
        return this.isBuildable(file2.getName());
    }

    public boolean isBuildable(String fileName) {
        return fileName.endsWith(".scala") || fileName.endsWith(".java");
    }

    private FileUtils$() {
        MODULE$ = this;
    }
}

