/*
 * Decompiled with CFR 0.152.
 */
package org.scalaide.ui.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.scalaide.core.IScalaPlugin$;
import org.scalaide.core.IScalaProject;
import org.scalaide.core.compiler.IScalaPresentationCompiler;
import org.scalaide.core.compiler.IScalaPresentationCompiler$Implicits$;
import org.scalaide.core.compiler.IScalaPresentationCompiler$Implicits$RichResponse$;
import org.scalaide.core.internal.project.ScalaProject$;
import org.scalaide.ui.wizards.Invalid;
import org.scalaide.ui.wizards.ScalaFileCreator;
import org.scalaide.ui.wizards.ScalaFileCreator$;
import org.scalaide.ui.wizards.ScalaFileCreator$$anonfun$9$;
import org.scalaide.ui.wizards.Valid$;
import org.scalaide.ui.wizards.Validation;
import org.scalaide.util.internal.Commons$;
import org.scalaide.util.internal.eclipse.ProjectUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.WrappedArray;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.internal.Symbols;
import scala.runtime.BoxesRunTime;
import scala.tools.nsc.Global;
import scala.tools.nsc.interactive.Response;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scalariform.lexer.ScalaLexer$;

public abstract class ScalaFileCreator$class {
    public static Map templateVariables(ScalaFileCreator $this, IContainer folder, String name) {
        return $this.generateTemplateVariables(name);
    }

    public static String initialPath(ScalaFileCreator $this, IResource res) {
        Seq<IPath> srcDirs = ProjectUtils$.MODULE$.sourceDirs(res.getProject());
        return $this.generateInitialPath(res.getFullPath(), srcDirs, res.getType() == 2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Validation validateName(ScalaFileCreator $this, IContainer folder, String name) {
        Invalid invalid;
        if (ScalaProject$.MODULE$.isScalaProject(folder.getProject())) {
            void var6_8;
            Either<Invalid, Function1<IContainer, Validation>> either = $this.doValidation(name);
            if (either instanceof Left) {
                Invalid v;
                Left left = (Left)either;
                Invalid invalid2 = v = (Invalid)left.a();
            } else {
                if (!(either instanceof Right)) throw new MatchError(either);
                Right right = (Right)either;
                Function1 f = (Function1)right.b();
                Validation validation = (Validation)f.apply((Object)folder);
            }
            invalid = var6_8;
            return invalid;
        } else {
            invalid = new Invalid("Not a Scala project");
        }
        return invalid;
    }

    public static IFile create(ScalaFileCreator $this, IContainer folder, String name) {
        String filePath = name.replace('.', '/');
        return folder.getFile((IPath)new Path(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".scala"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath}))));
    }

    public static Seq completionEntries(ScalaFileCreator $this, IContainer folder, String name) {
        Option ret = ProjectUtils$.MODULE$.projectAsJavaProject(folder.getProject()).map((Function1)new Serializable($this, folder, name){
            public static final long serialVersionUID = 0L;
            private final IContainer folder$1;
            private final String name$1;

            public final String[] apply(IJavaProject jp) {
                IPackageFragmentRoot root = jp.findPackageFragmentRoot(this.folder$1.getFullPath());
                String[] pkgs = (String[])Predef$.MODULE$.refArrayOps((Object[])root.getChildren()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(IJavaElement x$3) {
                        return x$3.getElementName();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                String ignoreCaseMatcher = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(?i)\\\\Q", "\\\\E.*"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1}));
                return (String[])Predef$.MODULE$.refArrayOps((Object[])pkgs).filter((Function1)new Serializable(this, ignoreCaseMatcher){
                    public static final long serialVersionUID = 0L;
                    private final String ignoreCaseMatcher$1;

                    public final boolean apply(String x$4) {
                        return x$4.matches(this.ignoreCaseMatcher$1);
                    }
                    {
                        this.ignoreCaseMatcher$1 = ignoreCaseMatcher$1;
                    }
                });
            }
            {
                this.folder$1 = folder$1;
                this.name$1 = name$1;
            }
        });
        return (Seq)ret.fold((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        }, (Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final WrappedArray<String> apply(String[] x) {
                return Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.identity((Object)x));
            }
        });
    }

    public static String generateInitialPath(ScalaFileCreator $this, IPath path, Seq srcDirs, boolean isDirectory) {
        return (String)srcDirs.find((Function1)new Serializable($this, path){
            public static final long serialVersionUID = 0L;
            private final IPath path$1;

            public final boolean apply(IPath x$5) {
                return x$5.isPrefixOf(this.path$1);
            }
            {
                this.path$1 = path$1;
            }
        }).map((Function1)new Serializable($this, path){
            public static final long serialVersionUID = 0L;
            private final IPath path$1;

            public final IPath apply(IPath srcDir) {
                return this.path$1.removeFirstSegments(srcDir.segmentCount());
            }
            {
                this.path$1 = path$1;
            }
        }).map((Function1)new Serializable($this, isDirectory){
            public static final long serialVersionUID = 0L;
            private final boolean isDirectory$1;

            public final IPath apply(IPath pkgOrFilePath) {
                return this.isDirectory$1 ? pkgOrFilePath : pkgOrFilePath.removeLastSegments(1);
            }
            {
                this.isDirectory$1 = isDirectory$1;
            }
        }).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(IPath x$6) {
                return Predef$.MODULE$.refArrayOps((Object[])x$6.segments()).mkString(".");
            }
        }).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String pkg) {
                return pkg.isEmpty() ? "" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pkg}));
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
    }

    public static Either doValidation(ScalaFileCreator $this, String name) {
        return name.isEmpty() ? package$.MODULE$.Left().apply((Object)new Invalid("No file path specified")) : $this.validateFullyQualifiedType(name);
    }

    public static Either validateFullyQualifiedType(ScalaFileCreator $this, String fullyQualifiedType) {
        Left left;
        Seq<String> parts = Commons$.MODULE$.split(fullyQualifiedType, '.');
        if (((String)parts.last()).isEmpty()) {
            left = package$.MODULE$.Left().apply((Object)new Invalid("No type name specified"));
        } else {
            Right right;
            Option option = ScalaFileCreator$class.packageIdentCheck$1($this, parts).orElse((Function0)new Serializable($this, parts){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ScalaFileCreator $outer;
                private final Seq parts$1;

                public final Option<String> apply() {
                    return ScalaFileCreator$class.typeIdentCheck$1(this.$outer, this.parts$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parts$1 = parts$1;
                }
            });
            if (option instanceof Some) {
                Some some = (Some)option;
                String e = (String)some.x();
                right = package$.MODULE$.Left().apply((Object)new Invalid(e));
            } else {
                right = package$.MODULE$.Right().apply((Object)new Serializable($this, fullyQualifiedType){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ScalaFileCreator $outer;
                    private final String fullyQualifiedType$1;

                    public final Validation apply(IContainer x$9) {
                        return this.$outer.checkTypeExists(x$9, this.fullyQualifiedType$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.fullyQualifiedType$1 = fullyQualifiedType$1;
                    }
                });
            }
            left = right;
        }
        return left;
    }

    public static boolean isValidScalaPackageIdent(ScalaFileCreator $this, String str) {
        boolean validIdent = new StringOps(Predef$.MODULE$.augmentString(str)).nonEmpty() && Character.isJavaIdentifierStart(BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(str)).head())) && new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(str)).tail())).forall((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$1) {
                return Character.isJavaIdentifierPart(x$1);
            }
        });
        return validIdent && !ScalaFileCreator$.MODULE$.ScalaKeywords().contains((Object)str) && !ScalaFileCreator$.MODULE$.JavaKeywords().contains((Object)str);
    }

    public static Validation checkTypeExists(ScalaFileCreator $this, IContainer folder, String fullyQualifiedType) {
        Option<IScalaProject> scalaProject;
        boolean typeExists;
        String path = fullyQualifiedType.replace('.', '/');
        return folder.getFile((IPath)new Path(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".scala"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})))).exists() ? new Invalid("File already exists") : ((typeExists = BoxesRunTime.unboxToBoolean((Object)(scalaProject = IScalaPlugin$.MODULE$.apply().asScalaProject(folder.getProject())).flatMap((Function1)new Serializable($this, fullyQualifiedType){
            public static final long serialVersionUID = 0L;
            public final String fullyQualifiedType$2;

            public final Option<Object> apply(IScalaProject scalaProject) {
                return scalaProject.presentationCompiler().apply(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ScalaFileCreator$.anonfun.9 $outer;

                    public final Option<Object> apply(IScalaPresentationCompiler compiler) {
                        Response<A> qual$1 = IScalaPresentationCompiler$Implicits$.MODULE$.RichResponse(compiler.asyncExec(new Serializable(this, compiler){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ScalaFileCreator$$anonfun$9$.anonfun.apply.2 $outer;
                            private final IScalaPresentationCompiler compiler$1;

                            public final boolean apply() {
                                return this.apply$mcZ$sp();
                            }

                            public boolean apply$mcZ$sp() {
                                Symbols.Symbol symbol = ((Global)this.compiler$1).rootMirror().getClassIfDefined(this.$outer.org$scalaide$ui$wizards$ScalaFileCreator$$anonfun$$anonfun$$$outer().fullyQualifiedType$2);
                                Symbols.NoSymbol noSymbol = ((Symbols)this.compiler$1).NoSymbol();
                                return symbol != null ? !symbol.equals(noSymbol) : noSymbol != null;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.compiler$1 = compiler$1;
                            }
                        }));
                        Duration x$10 = IScalaPresentationCompiler$Implicits$RichResponse$.MODULE$.getOption$default$1$extension(qual$1);
                        return IScalaPresentationCompiler$Implicits$RichResponse$.MODULE$.getOption$extension(qual$1, x$10);
                    }

                    public /* synthetic */ ScalaFileCreator$.anonfun.9 org$scalaide$ui$wizards$ScalaFileCreator$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).flatten(Predef$.MODULE$.$conforms());
            }
            {
                this.fullyQualifiedType$2 = fullyQualifiedType$2;
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }))) ? new Invalid("Type already exists") : Valid$.MODULE$);
    }

    public static Map generateTemplateVariables(ScalaFileCreator $this, String pkg) {
        int splitPos = pkg.lastIndexOf(46);
        return splitPos < 0 ? (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ScalaFileCreator$.MODULE$.VariableTypeName()), (Object)pkg)})) : (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ScalaFileCreator$.MODULE$.VariablePackageName()), (Object)pkg.substring(0, splitPos)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ScalaFileCreator$.MODULE$.VariableTypeName()), (Object)pkg.substring(splitPos + 1))}));
    }

    public static final boolean isValidScalaTypeIdent$1(ScalaFileCreator $this, String str) {
        boolean conformsToIdentToken = ScalaLexer$.MODULE$.tokenise(str, true, ScalaLexer$.MODULE$.tokenise$default$3()).size() == 2;
        return conformsToIdentToken && !ScalaFileCreator$.MODULE$.ScalaKeywords().contains((Object)str);
    }

    private static final Option packageIdentCheck$1(ScalaFileCreator $this, Seq parts$1) {
        return ((IterableLike)parts$1.init()).find((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScalaFileCreator $outer;

            public final boolean apply(String x$7) {
                return !this.$outer.isValidScalaPackageIdent(x$7);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String e) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' is not a valid package name"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e}));
            }
        });
    }

    public static final Option typeIdentCheck$1(ScalaFileCreator $this, Seq parts$1) {
        return ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)parts$1.last()}))).find((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScalaFileCreator $outer;

            public final boolean apply(String x$8) {
                return !ScalaFileCreator$class.isValidScalaTypeIdent$1(this.$outer, x$8);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String e) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' is not a valid type name"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e}));
            }
        });
    }

    public static void $init$(ScalaFileCreator $this) {
    }
}

